package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/**
 * 残留任务控制器
 * @version
 */
@Controller
@RequestMapping("${systemPath}/residual")
public class ComTaskResidualController extends BaseController {

	/**待处理任务列表*/
	private static final String RESIDUAL_LIST = getViewPath("admin/residual/residual_list");


	@Autowired
	private ComTaskResidualService ctrS;

	/**待处理任务列表*/
	@RequiresPermissions("residual:win:list")
	@RequestMapping(value = "/win/list")
	public String winList(Model model,@RequestParam Map<Object,Object> params , HttpServletRequest request) {
		return RESIDUAL_LIST;
	}

	/**待处理任务删除*/
	@RequiresPermissions("residual:win:del")
	@RequestMapping(value = "/del" , method = RequestMethod.POST)
	public @ResponseBody Object del(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return ctrS.del(p);
	}

	/**批量处理任务*/
	@RequiresPermissions("residual:win:del")
	@RequestMapping(value = "/batchExecuteTask" , method = RequestMethod.POST)
	public @ResponseBody Object batchExecuteTask(HttpServletRequest req, HttpServletResponse resp) {
		return ctrS.batchExecuteTask();
	}

	/**待处理任务删除*/
	@RequiresPermissions("residual:win:del")
	@RequestMapping(value = "/executeTask" , method = RequestMethod.POST)
	public @ResponseBody Object executeTask(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		return ctrS.executeTask(p);
	}

	/**公告信息列表分页*/
	@RequiresPermissions("residual:win:list")
	@RequestMapping(value = "/query" , method = RequestMethod.POST)
	public @ResponseBody Object query(@RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		Map<Object,Object> p = CTLUtil.init(req,params);
		CTLUtil.out(ctrS.query(params),resp); return null;
	}

}