package com.bcxin.ins.models.ueditor.util;

import org.apache.commons.lang3.RandomStringUtils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 文件名生成帮助类
 */
public class FileNameUtils {

	/**
	 * 生成当前年月格式的文件路径
	 * 
	 * yyyyMM 200806
	 * 
	 * @return
	 */
	public static String genPathName() {
		//日期格式化对象，将当前日期格式化成yyyyMM格式，用于生成目录。
		SimpleDateFormat pathDf = new SimpleDateFormat("yyyyMM");
		return pathDf.format(new Date());
	}

	/**
	 * 生产以当前日、时间开头加4位随机数的文件名
	 * 
	 * ddHHmmss 03102230
	 * 
	 * @return 10位长度文件名
	 */
	public static String genFileName() {
		//日期格式化对象，将当前日期格式化成ddHHmmss格式，用于生成文件名。
		SimpleDateFormat nameDf = new SimpleDateFormat("ddHHmmss");
		return nameDf.format(new Date()) + RandomStringUtils.random(4, Num62.N36_CHARS);
	}

	/**
	 * 生产以当前时间开头加4位随机数的文件名
	 * 
	 * @param ext
	 *            文件名后缀，不带'.'
	 * @return 10位长度文件名+文件后缀
	 */
	public static String genFileName(String ext) {
		return genFileName() + "." + ext;
	}

	public static String getFileSufix(String fileName) {
		int splitIndex = fileName.lastIndexOf('.');
		return fileName.substring(splitIndex + 1);
	}

	public static void main(String[] args) {
		System.out.println(genPathName());
		System.out.println(genFileName());
	}
}
