package com.bcxin.ins.models.product.util;

import com.bcxin.ins.util.MD5Utils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Random;

/**
 * 邀请码生成器，算法原理：<br/>
 * 1) 获取id: 1127738 <br/>
 * 2) 使用自定义进制转为：gpm6 <br/>
 * 3) 转为字符串，并在后面加'o'字符：gpm6o <br/>
 * 4）在后面随机产生若干个随机数字字符：gpm6o7 <br/>
 * 转为自定义进制后就不会出现o这个字符，然后在后面加个'o'，这样就能确定唯一性。最后在后面产生一些随机字符进行补全。<br/>
 * @author jiayu.qiu 连载 zxf
 */
public class ShareCodeUtil {
    /** 自定义进制(0,1没有加入,容易与o,l混淆) */
    private static final char[] r=new char[]{'q', 'w', 'e', '8', 'a', 's', '2', 'd', 'z', 'x', '9', 'c', '7', 'p', '5', 'i', 'k', '3', 'm', 'j', 'u', 'f', 'r', '4', 'v', 'y', 'l', 't', 'n', '6', 'b', 'g', 'h'};

    /** (不能与自定义进制有重复) */
    private static final char b='o';

    /** 进制长度 */
    private static final int binLen=r.length;

    /** 序列最小长度 */
    private static final int s=8;

    /**
     * 根据ID生成8位随机码
     * @param id ID
     * @return 随机码
     */
    public static String toSerialCode(long id) throws NoSuchAlgorithmException {
        char[] buf=new char[32];
        int charPos=32;
        int rm = (int)(10.0*Math.random()+1);
        id = Long.parseLong(String.valueOf(id)+String.valueOf(rm));
        while((id / binLen) > 0) {
            int ind=(int)(id % binLen);
            // System.out.println(num + "-->" + ind);
            buf[--charPos]=r[ind];
            id /= binLen;
        }
        buf[--charPos]=r[(int)(id % binLen)];
        // System.out.println(num + "-->" + num % binLen);
        String str=new String(buf, charPos, (32 - charPos));
        String m1 = Base64.getEncoder().encodeToString(str.substring(0,rm).getBytes());
        String m2 = MD5Utils.getMD5(str.substring(rm,str.length()));
        String mdStr = m1+m2;
        mdStr = mdStr.replace("=","");
        int stL = mdStr.length();
        int idL = str.length();
        char[] tca = mdStr.toCharArray();
        buf=new char[32];
        charPos=32;
        int v = 0;
        while(stL / idL > 0) {
            int ind=(int)(idL % stL);
            buf[--charPos]=tca[ind];
            idL = str.substring(v++,idL).length();
            mdStr = mdStr.substring(ind,stL);
            stL = mdStr.length();
            if(v>idL){
                break;
            }
        }
        buf[--charPos]=tca[(int)(idL % stL)];
        String nStr=new String(buf, charPos, (32 - charPos));
        Random rnd = new Random();
        // 不够长度的自动随机补全
        if(nStr.length() < s) {
            StringBuilder sb=new StringBuilder();
            for(int i=1; i <= s - nStr.length(); i++) {
                sb.append(r[rnd.nextInt(binLen)]);
            }
            nStr+=sb.toString();
        }
        return nStr;
    }

    public static long codeToId(String code) {
        char chs[]=code.toCharArray();
        long res=0L;
        for(int i=0; i < chs.length; i++) {
            int ind=0;
            for(int j=0; j < binLen; j++) {
                if(chs[i] == r[j]) {
                    ind=j;
                    break;
                }
            }
            if(chs[i] == b) {
                break;
            }
            if(i > 0) {
                res=res * binLen + ind;
            } else {
                res=ind;
            }
            // System.out.println(ind + "-->" + res);
        }
        return res;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssS");
        for(int i = 0; i<100; i++){
            Long a = Long.parseLong(sdf.format(new Date()));
            String b = toSerialCode(a);
            System.out.println(a + "-->" + b);
        }
    }
}
