package com.bcxin.ins.models.product.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.entity.product_core.ProResponsibility;
import com.bcxin.ins.models.product.dao.InsProductResponsibilityDao;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * 保障责任
 * Created by playboy on 2017/3/30.
 */
@Service
public class InsProductResponsibilityServiceImpl extends ServiceImpl<InsProductResponsibilityDao,ProResponsibility> implements InsProductResponsibilityService {

    @Autowired
    private InsProductResponsibilityDao dao;
    /**
     * 根据产品id查询保障责任
     * @param product_id
     * @return
     */
    @Override
    public List<ResponsibilityVo> getResponsibilityVoListByProductID(Long product_id){
        return dao.getResponsibilityVoListByProductID(product_id);
    }

    /**
     * 查询保障责任
     * @return
     */
    @Override
    public List<ResponsibilityVo> findResponsibilityVoList(String pro_primary_id){
        String key = ConstProp.REDIS_HEAD_PRODUCT_RESPONSIBILITY;
        List<ResponsibilityVo> voList;
        if(JedisUtils.exists(key)){
            voList = JSON.parseArray(JedisUtils.get(key),ResponsibilityVo.class);
        }else{
            voList = dao.findResponsibilityVoList();
            //设置一个月过期
            JedisUtils.set(key,JSON.toJSONString(voList),ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
        }
        if(StringUtils.isNotEmpty(pro_primary_id)){
            voList = voList.stream()
                    .filter(e -> pro_primary_id.contains(e.getPro_primary_id()))
                    .collect(Collectors.toList());
        }
        return voList;
    }


    /**
     * <b> 查询保障责任 </b>
     * @param pro_primary_id 产品id
     * @param responsibilityIds 保障责任id
     * @author ZXF
     * @create 2023/12/28 0028 15:57
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<ResponsibilityVo> findResponsibilityVoListByResponsibilityIds(String pro_primary_id,String responsibilityIds){
        if(StringUtils.isEmpty(responsibilityIds)&&StringUtils.isEmpty(pro_primary_id)){
            return new ArrayList<>();
        }
        if(StringUtils.isEmpty(responsibilityIds)){
            return findResponsibilityVoList(pro_primary_id);
        }
        return dao.getResponsibilityVoListByResponsibilityIds(responsibilityIds.split(","));
    }
}
