package com.bcxin.ins.models.product.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.models.product.dao.InsProductLogDao;
import com.bcxin.ins.models.product.entity.InsProductLog;
import com.bcxin.ins.models.product.service.InsProductLogService;
import com.bcxin.ins.models.product.util.ProductUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;


@Service
@Transactional
public class InsProductLogServiceImpl extends BaseServiceImpl<InsProductLogDao, InsProductLog> implements InsProductLogService {

    @Autowired
    InsProductLogDao insProductLogDao;


    @Override
    public List<InsProductLog> findProductLogList(InsProductLog log) {
        return insProductLogDao.findProductLogList(log);
    }

    @Override
    public void saveProductLog(Long pid, String productTypeFee) {

         int num=insProductLogDao.getTotalLog(pid);//根据id查询 该产品入库情况
         if(num==0){
             //新增
             InsProductLog  log= new InsProductLog(pid);
             log.setUpdateStatus(productTypeFee);
             log.setUpdateType(ProductUtil.PRODUCT_METHOD_ADD);
             log.setCreateBy(SysUserUtils.getUser());
             log.setCreateTime(new Date());
             insProductLogDao.insert(log);
         }else{
             //修改
             InsProductLog  log= new InsProductLog(pid);
             log.setUpdateStatus(productTypeFee);
             log.setUpdateType(ProductUtil.PRODUCT_METHOD_UPD);
             log.setCreateBy(SysUserUtils.getUser());
             log.setCreateTime(new Date());
             insProductLogDao.insert(log);
         }

    }
}
