package com.bcxin.ins.models.product.service;


import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.InsProductVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.mybatisplus.service.IService;

import java.util.List;

public interface InsProductService extends IService<ProPrimary> {

	List<ProPrimary> findProductList(ProPrimary insProduct);

	List<ProPrimary> findProductList(String keyword);

	List<ProPrimary> fillProductList(String[] pids);

	List<SysCompany> fillCompanyList(String[] cids);

	InsProductVo getProductAttrListByPid(Long pid, String type);

	ProPrimary getProduct(Long pid);

	ProPrimary findProductByCode(String code);

	void accordingToProductIDToGetInsProductSetUpOrderFormVo(OrderFormVo vo, Long insProduct_id);

	void accordingToProductIDToGetInsProductSetUpAdviceNoteVo(AdviceNoteVo vo, Long insProduct_id);

	List<ProductVo> selectProductVoList(ProPrimary insProduct);

	ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID);

	ProductVo willInsProductSetUpProductVo(ProPrimary ip);

	/**
	 * 根据产品ID查询产品list
	 */
	List<ProPrimary> findByIdsList(List<Long> ids);

	/**
	 *根据产品ID查询
	 * @param ids
	 * @return
	 */
	List<ProPrimary> findByIdsArray(Long[] ids,String companyId);
}
