package com.bcxin.ins.models.pro.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.dao.MyUtilMapper;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.*;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.entity.product_core.*;
import com.bcxin.ins.models.pro.dao.*;
import com.bcxin.ins.models.pro.service.*;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.io.FileUtil;
import com.xiaoleilu.hutool.poi.excel.ExcelReader;
import com.xiaoleilu.hutool.poi.excel.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* 类名称：SysUserServiceImpl   
* 类描述：SysUser 表业务逻辑层接口实现类   
* 创建人：liujinju
* @version
 */
@Service
@Transactional
public class MyProServiceImpl extends ServiceImpl<MyProMapper, ProPrimary> implements MyProService {
    private static Logger log = LoggerFactory.getLogger(MyProServiceImpl.class);

    @Autowired
    private MyProMapper proM;
    @Autowired
    private ProResponsibilityService proRS;
    @Autowired
    private ProCategoryService proCS;
    @Autowired
    private MyUtilService utilS;
    @Autowired
    private MyUtilMapper utilM;

    @Autowired
    private ProPrimaryService proPrimaryService;
    @Autowired
    private ProPrimaryCostService proPrimaryCostService;
    @Autowired
    private ProPrimaryExpireService proPrimaryExpireService;
    @Autowired
    private ProExpCustomsCompaniesService proECC;
    @Autowired
    private ProPrimaryRuleXWCKService proRXWCK;
    @Autowired
    private ProTicketService proTicketService;
    @Autowired
    private ProRtSellRegionService proRtSellRegionService;
    @Autowired 
    private ProRtProtectAreaService proRtProtectAreaService;
    @Autowired
    private ProRtProfessionService proRtProfessionService;
    @Autowired
    private ProProfessionService  proProfessionService;
    @Autowired
    private ProDeliveryService proDeliveryService;
    @Autowired
    private ProClausesService proClausesService;
    @Autowired
    private ProDangerLevelService proDangerLevelService;

    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    private ProCategory getTop(ProCategory p){
        ProCategory n = proCS.selectById(p.getType_parent_id());//得到父节点
        if(n==null){
            return p; //跳出递归
        }else{
            return getTop(n); //继续递归
        }
    }

    /**
     * 递归获得父节点
     *
     * @param p
     * @return
     */
    @Override
    public Map<Object, Object> queryTopParent(Map<Object, Object> p) {
        ProCategory n = proCS.selectById(Long.valueOf(String.valueOf(p.get("pro_category_id"))));
        return DOM.dtm(getTop(n));
    }

    @Override
    public List<Map<Object, Object>> queryProByID(Map<Object, Object> p) {
        return proM.queryProByID(p);
    }

    /**
     * 产品列表分页查询
     *
     * @param p
     */
    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(proM.queryCnt(p),proM.query(p));
    }

    /**
     * 产品分类分页查询
     *
     * @param p
     */
    @Override
    public PageResult queryCategory(Map<Object, Object> p) {
        return new PageResult(proM.queryCategoryCnt(p),proM.queryCategory(p));
    }


    /**
     * 小微企业信用险的区域规则配置列表查询，传入产品ID
     *
     * @param p
     */
    @Override
    public PageResult queryRXWCK(Map<Object, Object> p) {
        return new PageResult(proM.queryRXWCKCnt(p),proM.queryRXWCK(p));
    }

    /**
     * 新增区域规则配置
     *
     * @param p
     */
    @Override
    public R rXWCKAdd(Map<Object, Object> p) {
        try{
            //区域规则配置城市重复，某个产品下不重复
            if(proRXWCK.selectList(new EntityWrapper<ProPrimaryRuleXWCK>().addFilter("city_code={0} and pro_primary_id={1}",p.get("city_code"),p.get("pro_primary_id"))).size()>0) {
                return new R(false, "该城市已配置规则，请重新输入！");
            }


            //插入区域规则配置
            ProPrimaryRuleXWCK  mpr = (ProPrimaryRuleXWCK) DOM.mtd(p,new ProPrimaryRuleXWCK()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setPro_primary_rule_xwck_id(null); //保护ID
            mpr.setUpdate_time(new Date());
            proRXWCK.insert(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增区域规则配置，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    /**
     * 修改区域规则配置
     *
     * @param p
     */
    @Override
    public R rXWCKUpd(Map<Object, Object> p) {
        try{
            if(proRXWCK.selectList(new EntityWrapper<ProPrimaryRuleXWCK>().addFilter("city_code={0} and pro_primary_id={1} and pro_primary_rule_xwck_id != {2}"
                    ,p.get("city_code"),p.get("pro_primary_id"),p.get("pro_primary_rule_xwck_id"))).size()>0) {
                return new R(false, "该城市已配置规则，请重新输入！");
            }
            //修改区域规则配置
            ProPrimaryRuleXWCK  mpr =  DOM.mtd(p,new ProPrimaryRuleXWCK()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setUpdate_time(new Date());
            proRXWCK.updateById(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增区域规则配置，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 删除区域规则配置
     *
     * @param p
     */
    @Override
    public R rXWCKDel(Map<Object, Object> p) {
        try{
            //删除区域规则配置记录
            proRXWCK.deleteById(Long.valueOf(String.valueOf(p.get("pro_primary_rule_xwck_id"))));
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 小微企业出口企业信息列表查询
     *
     * @param p
     */
    @Override
    public PageResult queryECC(Map<Object, Object> p) {
        return new PageResult(proM.queryECCCnt(p),proM.queryECC(p));
    }

    /**
     * 批量新增出口企业信息
     *
     * @param mFile
     */
    @Override
    public R eCCFile(MultipartFile mFile) {
        if(mFile == null){
            return new R(false,"文件不存在");
        }
        try{
            InputStream is = mFile.getInputStream();
            ExcelReader reader = ExcelUtil.getReader(is);
            List<Map<String,Object>> mList = reader.readAll();
            if(mList.size()==0){
                return new R(false,"excel解析失败");
            }
            ProExpCustomsCompanies ecc = null;
            List<ProExpCustomsCompanies> eccs = Lists.newArrayList();
            String msgArr = ConstProp.BLANK_CHAR;
            int count = 0;
            int suCount = 0;
            for(Map<String,Object> p : mList){
                count++;
                ecc = new ProExpCustomsCompanies();
                //区域规则配置城市重复，某个产品下不重复
                if(proECC.selectList(new EntityWrapper<ProExpCustomsCompanies>().addFilter("customs_code={0} and company_name={1}",p.get("企业代码"),p.get("企业名称"))).size()>0){
                    msgArr = msgArr + "-" + p.get("企业代码");
                    continue;
                }
                ecc.setCustoms_code(String.valueOf(p.get("企业代码")));
                ecc.setCompany_name(String.valueOf(p.get("企业名称")));
                BigDecimal ea = BigDecimal.ZERO;
                if(p.get("出口金额") != null){
                    ea = new BigDecimal(String.valueOf(p.get("出口金额")));
                }
                ecc.setExport_amount(ea);
                ecc.setVersions_number(String.valueOf(p.get("版本")));
                ecc.setPro_exp_customs_companies_id(IdWorker.getId()); //保护ID
                eccs.add(ecc);
                ecc = null;
                suCount++;
            }
            if(eccs.size()>0){
                proECC.batchInsert(eccs);
            }
            String msg = "数据合计："+count+" 条，已插入："+suCount+" 条";
            if(StringUtils.isNotEmpty(msgArr)){
                msg = msg + ",其它数据已存在请手动修改（海关代码："+msgArr+"）";
            }
            return new R(true,msg);
        } catch (Exception e) {
            log.error("新增出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
        /*try{
            //区域规则配置城市重复，某个产品下不重复
            if(proECC.selectList(new EntityWrapper<ProExpCustomsCompanies>().addFilter("customs_code={0} and company_name={1}",p.get("customs_code"),p.get("company_name"))).size()>0)
                return new R(false,"该企业已存在，请重新输入！");


            //插入区域规则配置
            ProExpCustomsCompanies  pecc = (ProExpCustomsCompanies) DOM.mtd(p,new ProExpCustomsCompanies()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            pecc.setPro_exp_customs_companies_id(null); //保护ID
            proECC.insert(pecc);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }*/
    }


    /**
     * 新增出口企业信息
     *
     * @param p
     */
    @Override
    public R eCCAdd(Map<Object, Object> p) {
        try{
            //区域规则配置城市重复，某个产品下不重复
            if(proECC.selectList(new EntityWrapper<ProExpCustomsCompanies>().addFilter("customs_code={0} and company_name={1}",p.get("customs_code"),p.get("company_name"))).size()>0) {
                return new R(false, "该企业已存在，请重新输入！");
            }

            //插入区域规则配置
            ProExpCustomsCompanies  pecc = (ProExpCustomsCompanies) DOM.mtd(p,new ProExpCustomsCompanies()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            pecc.setPro_exp_customs_companies_id(null); //保护ID
            proECC.insert(pecc);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    /**
     * 修改出口企业信息
     *
     * @param p
     */
    @Override
    public R eCCUpd(Map<Object, Object> p) {
        try{
            if(proECC.selectList(new EntityWrapper<ProExpCustomsCompanies>().addFilter("customs_code={0} and company_name={1} and pro_exp_customs_companies_id != {2}"
                    ,p.get("customs_code"),p.get("company_name"),p.get("pro_exp_customs_companies_id"))).size()>0) {
                return new R(false, "该出口企业信息已存在，请重新输入！");
            }
            //修改区域规则配置
            ProExpCustomsCompanies  pecc =  DOM.mtd(p,new ProExpCustomsCompanies()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            proECC.updateById(pecc);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 删除出口企业信息
     *
     * @param p
     */
    @Override
    public R eCCDel(Map<Object, Object> p) {
        try{
            //删除区域规则配置记录
            proECC.deleteById(Long.valueOf(String.valueOf(p.get("pro_exp_customs_companies_id"))));
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("删除出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 批量清空出口企业信息
     *
     * @param p
     */
    @Override
    public R eCCBatchDel(Map<Object, Object> p) {
        try{
            //批量清空出口企业信息
            proECC.deleteByBatch();
            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("批量清空出口企业信息，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }


    /**
     * 某个产品的保障责任列表查询，传入产品ID
     *
     * @param p
     */
    @Override
    public PageResult querySR(Map<Object, Object> p) {
        return new PageResult(proM.querySRCnt(p),proM.querySR(p));
    }

    /**
     * 新增保障责任
     *
     * @param p
     */
    @Override
    public R srAdd(Map<Object, Object> p) {
        try{
            //保障责任名称重复，某个产品下不重复
            if(proRS.selectList(new EntityWrapper<ProResponsibility>().addFilter("name={0} and pro_primary_id={1}",p.get("name"),p.get("pro_primary_id"))).size()>0) {
                return new R(false, "保障责任名称已经存在，请重新输入！");
            }


            //插入保障责任
            ProResponsibility  mpr = (ProResponsibility) DOM.mtd(p,new ProResponsibility()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setPro_responsibility_id(null); //保护ID
            mpr.setCreate_time(new Date());
            mpr.setCreate_by(Long.valueOf(String.valueOf(p.get("system_params_user_id"))));
            proRS.insert(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }


    /**
     * 修改保障责任
     *
     * @param p
     */
    @Override
    public R srUpd(Map<Object, Object> p) {
        try{
            if(proRS.selectList(new EntityWrapper<ProResponsibility>().addFilter("name={0} and pro_primary_id={1} and pro_responsibility_id != {2}"
                    ,p.get("name"),p.get("pro_primary_id"),p.get("pro_responsibility_id"))).size()>0) {
                return new R(false, "保障责任名称已经存在，请重新输入！");
            }
            //插入保障责任
            ProResponsibility  mpr =  DOM.mtd(p,new ProResponsibility()); //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段

            proRS.updateById(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }



    /**
     * 修改保障责任
     *
     * @param p
     */
    @Override
    public R srDel(Map<Object, Object> p) {
        try{
            //插入保障责任
            ProResponsibility  mpr = new ProResponsibility() ; //保存用户，弱数据安全，如果用户知道字段，可以插入其他字段
            mpr.setPro_responsibility_id(Long.valueOf(String.valueOf(p.get("pro_responsibility_id"))));
            mpr.setStatus(2);
            proRS.updateById(mpr);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }

    }

    /**
     * 产品表手动同步
     * 做校验 startDate参数这里是必填，由控制层校验
     * @param p
     */
    @CacheEvict(value="PROCACHE",allEntries=true)
    @Override
    public R proSync(Map<Object, Object> p ) {
        System.out.println("xxxxxx");
        try{
            //查询出参数
            //http请求的string
            //解析string为List<Map>对象
            //根据ID进行比对，不存在就插入，否则更新
            p.put("sys_sync_id",3);
            Map<Object,Object> sync = utilM.getHTTP(p);
            List<Map<Object,Object>> l = utilS.getHTTPString(p);
            if(l==null ) {
                return new R(true,"无数据更新");
            }
            if(l.size()==0) {
                return new R(true,"无数据更新");
            }
            List<ProPrimary> addList  = Lists.newArrayList();
            List<ProPrimary> updList  = Lists.newArrayList();
            for(Map<Object,Object> e : l){
                if(e.get("id")==null) {
                    continue;
                }
                if(this.selectById(Long.valueOf(String.valueOf(e.get("id"))))==null){//如果不存在就插入，否则更新
                    addList.add(getProPrimary(e,sync));
                }else{
                    updList.add(getProPrimary(e,sync));
                }
            }
            if(addList.size()!=0) {
                this.insertBatch(addList);
            }
            if(updList.size()!=0) {
                this.updateBatchById(updList);
            }
            log.info("产品同步结果>>>>>>>>>>>>>>>新增"+addList.size()+" 修改"+updList.size());
            //同步产品结束后清理产品缓存
            myAsyncExecutor.execute(()->{
                try {
                    JedisUtils.batchDel(ConstProp.REDIS_HEAD_PROCACHE);
                    JedisUtils.batchDel(ConstProp.REDIS_HEAD_PRODUCT_PCO);
                    JedisUtils.batchDel(ConstProp.REDIS_HEAD_PRODUCT_ID);
                } catch(Exception e) {
                    log.info("产品同步结束时，产品缓存清理失败，错误："+ e.getMessage());
                }
            });
            return new R(true,"操作成功，产品同步结果:新增"+addList.size()+" 修改"+updList.size());
        } catch (Exception e) {
            log.error("产品同步，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    /**
     * 产品分类表手动同步
     * 做校验 startDate参数这里是必填，由控制层校验
     * @param p
     */
    @Override
    public R categorySync(Map<Object, Object> p) {
        //TODO 做校验 startDate参数这里是必填，由控制层校验
        try{
            //查询出参数
            //http请求的string
            //解析string为List<Map>对象
            //根据ID进行比对，不存在就插入，否则更新
            p.put("sys_sync_id",1);
            Map<Object,Object> sync = utilM.getHTTP(p);
            List<Map<Object,Object>> l = utilS.getHTTPString(p);

            if(l==null ) {
                return new R(true,"无数据更新");
            }
            if(l.size()==0) {
                return new R(true,"无数据更新");
            }
            List<ProCategory> addList  = Lists.newArrayList();
            List<ProCategory> updList  = Lists.newArrayList();
            for(Map<Object,Object> e : l){
                if(e.get("id")==null) {
                    continue;
                }
                if(proCS.selectById(Long.valueOf(String.valueOf(e.get("id"))))==null){//如果不存在就插入，否则更新
                    addList.add(getMyProCategory(e));
                }else{
                    updList.add(getMyProCategory(e));
                }
            }
            if(addList.size()!=0) {
                proCS.insertBatch(addList);
            }
            if(updList.size()!=0) {
                proCS.updateBatchById(updList);
            }
            log.info("产品分类同步结果>>>>>>>>>>>>>>>新增"+addList.size()+" 修改"+updList.size());
            return new R(true,"操作成功，产品分类同步结果:新增"+addList.size()+" 修改"+updList.size());
        } catch (Exception e) {
            log.error("产品分类同步，事务发现异常，回滚数据",e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    private ProCategory getMyProCategory(Map<Object, Object> e) {
        ProCategory row = new ProCategory();
        if(e.get("id")!=null) {
            row.setPro_category_id(Long.valueOf(String.valueOf(e.get("id"))));
        }
        if(e.get("type")!=null) {
            row.setType(Integer.valueOf(String.valueOf(e.get("type"))));
        }
        if(e.get("typeName")!=null) {
            row.setType_name(String.valueOf(e.get("typeName")));
        }
        if(e.get("typeLevel")!=null) {
            row.setType_level(String.valueOf(e.get("typeLevel")));
        }
        if(e.get("parentId")!=null) {
            row.setType_parent_id(Long.valueOf(String.valueOf(e.get("parentId"))));
        }
        if(e.get("insType")!=null) {
            row.setIns_type(Integer.valueOf(String.valueOf(e.get("insType"))));
        }
        if(e.get("status")!=null){
            if("9".equals(String.valueOf(e.get("status")))){
                row.setStatus(2);
            }else{
                row.setStatus(Integer.valueOf(String.valueOf(e.get("status"))));
            }
        }
        return row;
    }

    private ProPrimary getProPrimary(Map<Object, Object> e , Map<Object,Object> sync) {
        ProPrimary row = new ProPrimary();
        if(e.get("id")!=null) {
            row.setPro_primary_id(Long.valueOf(String.valueOf(e.get("id"))));
        }
        if(e.get("name")!=null) {
            row.setInsurance_name(String.valueOf(e.get("name")));
        }
        if(e.get("supplierId")!=null) {
            row.setSupplier_id(Long.valueOf(String.valueOf(e.get("supplierId"))));
        }
        if(e.get("label")!=null) {
            row.setLabel(String.valueOf(e.get("label")));
        }
        if(e.get("tradeType")!=null) {
            row.setTrade_type(String.valueOf(e.get("tradeType"))); //市场属性分类
        }
        if(e.get("responsibilityType")!=null) {
            row.setCategory_id(String.valueOf(e.get("responsibilityType"))); //产分类
        }
        if(e.get("picture")!=null) {
            row.setPicture(String.valueOf(sync.get("head"))+String.valueOf(e.get("picture")));
        }
        if(e.get("intro")!=null) {
            row.setIntro(String.valueOf(e.get("intro")));
        }
        if(e.get("declaration")!=null) {
            row.setDeclaration(String.valueOf(e.get("declaration")));
        }
        if(e.get("address")!=null) {
            row.setAddress(String.valueOf(e.get("address")));
        }
        if(e.get("information")!=null) {
            row.setInformation(String.valueOf(e.get("information")));
        }
        if(e.get("remarks")!=null) {
            row.setRemarks(String.valueOf(e.get("remarks")));
        }
        if(e.get("createTime")!=null) {
            row.setCreate_time(new Date(Long.valueOf(String.valueOf(e.get("createTime")))));
        }
        if(e.get("updateTime")!=null) {
            row.setUpdate_time(new Date(Long.valueOf(String.valueOf(e.get("updateTime")))));
        }
        if(e.get("venueName")!=null) {
            row.setVenue_name(String.valueOf(e.get("venueName")));
        }
        if(e.get("peripheralParking")!=null) {
            row.setPeripheral_parking(String.valueOf(e.get("peripheralParking")));
        }
        if(e.get("district")!=null) {
            row.setDistrict(String.valueOf(e.get("district")));
        }
        if(e.get("insuranceFaq")!=null) {
            row.setInsurance_faq(String.valueOf(e.get("insuranceFaq")));
        }
        if(e.get("sample")!=null) {
            row.setSample(String.valueOf(e.get("sample")));
        }
        if(e.get("productType")!=null) {
            row.setProduct_type(String.valueOf(e.get("productType")));
        }
        if(e.get("status")==null){
            return row;
        }
        if("9".equals(String.valueOf(e.get("status")))){
            row.setStatus(2);
        }else{
            row.setStatus(Integer.valueOf(String.valueOf(e.get("status"))));
        }
        return row;
    }

    public ProPrimary getProByID(Map<Object, Object> p){
        p.put("sys_sync_id",3);
        p.put("productId",p.get("pro_primary_id"));
        List<Map<Object,Object>> l = utilS.getHTTPString(p);
        if(l==null || l.size()==0) {
            return new ProPrimary();
        }
        return getProPrimary(l.get(0), utilM.getHTTP(p));
    }

    @Override
    public R addPro(Map<Object, Object> p , CommonsMultipartFile[] files) {
        log.info("获得的参数是>>>>>>>>>>>>>>>>>"+JSON.toJSONString(p));
        try{
            if(p.get("pro_primary_id")==null) {
                return new R(false, "产品ID没有设置");
            }
            Long pro_primary_id = Long.valueOf(String.valueOf(p.get("pro_primary_id")));

            ProPrimary proPrimary = (ProPrimary) DOM.mtd(p, getProByID(p));
            ProPrimaryCost proPrimaryCost = (ProPrimaryCost) DOM.mtd(p,new ProPrimaryCost());
            ProPrimaryExpire proPrimaryExpire = (ProPrimaryExpire) DOM.mtd(p,new ProPrimaryExpire());
            ProTicket proTicket = (ProTicket) DOM.mtd(p,new ProTicket());
            ProDelivery proDelivery = (ProDelivery) DOM.mtd(p,new ProDelivery());
            //初始默认下架
            if(proPrimary.getStatus()==null){
                proPrimary.setStatus(0);
            }
            proPrimaryService.insert(proPrimary);
            proPrimaryCostService.insert(proPrimaryCost);
            proPrimaryExpireService.insert(proPrimaryExpire);
            proTicketService.insert(proTicket);
            proDeliveryService.insert(proDelivery);

            maintainRelationShip(p, files, pro_primary_id);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("信用险，事务发现异常，回滚数据",e); TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    @Override
    public R updPro(Map<Object, Object> p , CommonsMultipartFile[] files) {
        log.info("获得的参数是>>>>>>>>>>>>>>>>>"+JSON.toJSONString(p));
        try{
            if(p.get("pro_primary_id")==null) {
                return new R(false, "产品ID没有设置");
            }
            Long pro_primary_id = Long.valueOf(String.valueOf(p.get("pro_primary_id")));

            ProPrimary proPrimary = (ProPrimary) DOM.mtd(p, getProByID(p));
            ProPrimaryCost proPrimaryCost = (ProPrimaryCost) DOM.mtd(p,new ProPrimaryCost());
            ProPrimaryExpire proPrimaryExpire = (ProPrimaryExpire) DOM.mtd(p,new ProPrimaryExpire());
            ProTicket proTicket = (ProTicket) DOM.mtd(p,new ProTicket());
            ProDelivery proDelivery = (ProDelivery) DOM.mtd(p,new ProDelivery());

            if(!(proPrimaryService.update(proPrimary,new EntityWrapper<ProPrimary>().where("pro_primary_id={0}",pro_primary_id)))) {
                proPrimaryService.insert(proPrimary);
            }
            if(!(proPrimaryCostService.update(proPrimaryCost,new EntityWrapper<ProPrimaryCost>().where("pro_primary_id={0}",pro_primary_id)))) {
                proPrimaryCostService.insert(proPrimaryCost);
            }
            if(!(proPrimaryExpireService.update(proPrimaryExpire,new EntityWrapper<ProPrimaryExpire>().where("pro_primary_id={0}",pro_primary_id)))){
                proPrimaryExpireService.insert(proPrimaryExpire);
            }
            if(!(proTicketService.update(proTicket,new EntityWrapper<ProTicket>().where("pro_primary_id={0}",pro_primary_id)))) {
                proTicketService.insert(proTicket);
            }
            if(!proDeliveryService.update(proDelivery,new EntityWrapper<ProDelivery>().where("pro_primary_id={0}",pro_primary_id))) {
                proDeliveryService.insert(proDelivery);
            }
            maintainRelationShip(p, files, pro_primary_id);

            return new R(true,"操作成功");
        } catch (Exception e) {
            log.error("保证保险，事务发现异常，回滚数据",e); TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false,"操作失败");
        }
    }

    /**
     * 关系表处理
     * @param p
     * @param files
     * @param pro_primary_id
     */
    private void maintainRelationShip(Map<Object, Object> p, CommonsMultipartFile[] files, Long pro_primary_id) {
        Map<String,Object> dp = Maps.newHashMap();
        dp.put("pro_primary_id",p.get("pro_primary_id")); //col=val

        //插入可销售区域表关系表
        if(p.get("sell_region")!=null && (!"".equals(String.valueOf(p.get("sell_region")).trim()))){
            String[] sell_regions = StringUtils.split(String.valueOf(p.get("sell_region")),",");//1,2,3,4,
            List<ProRtSellRegion> l1 = Lists.newArrayList();
            for (String s : sell_regions){
                ProRtSellRegion row = new ProRtSellRegion();
                row.setPro_primary_id(pro_primary_id);
                row.setCodes(s);
                l1.add(row);
            }
            proRtSellRegionService.deleteByMap(dp);
            proRtSellRegionService.insertBatch(l1);
        }

        //插入可保障区域表
        if(p.get("protect_area")!=null&& (!"".equals(String.valueOf(p.get("protect_area")).trim()))){
            String[] protect_areas = StringUtils.split(String.valueOf(p.get("protect_area")),",");//1,2,3,4,
            List<ProRtProtectArea> l2 = Lists.newArrayList();
            for (String s : protect_areas){
                ProRtProtectArea row = new ProRtProtectArea();
                row.setPro_primary_id(pro_primary_id);
                row.setCodes(s);
                l2.add(row);
            }
            proRtProtectAreaService.deleteByMap(dp);
            proRtProtectAreaService.insertBatch(l2);
        }

        //插入职业分类
        if(p.get("profession_category")!=null&& (!"".equals(String.valueOf(p.get("profession_category")).trim()))){
            String[] profession_categorys = StringUtils.split(String.valueOf(p.get("profession_category")),",");//1,2,3,4,
            List<ProRtProfession> l3 = Lists.newArrayList();
            for (String s : profession_categorys){
                ProRtProfession row = new ProRtProfession();
                row.setPro_primary_id(pro_primary_id);
                row.setPro_profession_id(Long.valueOf(String.valueOf(s)));
                l3.add(row);
            }
            proRtProfessionService.deleteByMap(dp);
            proRtProfessionService.batchUpdate(l3);
        }

        //插入条款表
        if(files!=null||files.length>=1){
            proClausesInsert(files, pro_primary_id, dp);

        }

        //插入危险等级
        if(p.get("danger_names")!=null&& (!"".equals(String.valueOf(p.get("danger_names")).trim()))
                &&p.get("danger_codes")!=null&& (!"".equals(String.valueOf(p.get("danger_codes")).trim())) ){
            List<String> danger_names  = JSON.parseArray(String.valueOf(p.get("danger_names")),String.class);
            List<String> danger_codes  = JSON.parseArray(String.valueOf(p.get("danger_codes")),String.class);
            List<ProDangerLevel> l5 = Lists.newArrayList();
            for (int i = 0; i < danger_codes.size(); i++) {
                ProDangerLevel row = new ProDangerLevel();
                row.setPro_danger_level_id(com.bcxin.mybatisplus.toolkit.IdWorker.getId());
                row.setPro_primary_id(pro_primary_id);
                row.setDanger_name(danger_names.get(i));
                row.setCodes(danger_codes.get(i));
                l5.add(row);
            }
            proDangerLevelService.deleteByMap(dp);
            proDangerLevelService.batchInsert(l5);
        }
    }

    /**
     * <b> 插入条款表 </b>
     * @author ZXF
     * @create 2020/09/14 0014 16:55
     * @version
     * @注意事项 </b>
     */
    private void proClausesInsert(CommonsMultipartFile[] files, Long pro_primary_id, Map<String, Object> dp) {
        int i=0;
        //如果文件有一个是空文件，默认不做修改
        for(CommonsMultipartFile file: files){
            if(file.getSize()==0) {
                i++ ;
            }
        }
        if(i>0){
            return;
        }
        proClausesService.deleteByMap(dp);
        List<ProClauses> pcs = Lists.newArrayList();
        for (CommonsMultipartFile file: files) {
            log.info("得到上传的文件名---------->" + file.getOriginalFilename());
            ProClauses pc  = new ProClauses();
            pc.setPro_primary_id(pro_primary_id);
            pc.setClauses_file(file.getBytes());
            pc.setFile_size(String.valueOf(file.getSize()));
            pc.setSuffix("pdf");
            pc.setFile_name(file.getOriginalFilename());
            pc.setPro_clauses_id(com.bcxin.mybatisplus.toolkit.IdWorker.getId());
            pcs.add(pc);
        }
        proClausesService.batchInsert(pcs);
    }

    @Override
    public R addSource(Map<Object, Object> p, HttpServletRequest request) {
        try {
            String pId = String.valueOf(p.get("pId"));
            String source = String.valueOf(p.get("source"));
            if(StringUtils.isEmpty(pId)||StringUtils.isEmpty(source)){
                return new R(false, "数据缺失");
            }
            ProPrimary proPrimary = proPrimaryService.selectById(Long.parseLong(pId));
            proPrimary.setSource(source);
            if(!proPrimaryService.updateById(proPrimary)){
                return new R(false, "供应标识标记失败");
            }
            return new R(true, "供应标识标记成功");
        } catch (Exception e) {
            return new R(false, e.getMessage());
        }
    }

}