package com.bcxin.ins.models.order.policy.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysDict;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.entity.policy_core.InsShipInvoices;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.models.order.policy.service.ShipDeclareService;
import com.bcxin.ins.models.order.policy.service.ShipInvoicesService;
import com.bcxin.ins.vo.*;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;


/**
 * 出运后台管理controller<br>
 * @author liumd
 * @date 2017年1月19日
 */
@Controller
@RequestMapping("${systemPath}/ship/ht/declare")
public class ShipDeclareHtController extends BaseController {
	
	@Autowired
	private ShipDeclareService shipDeclareService;
	@Autowired
	private ShipInvoicesService shipInvoicesService;
	@Autowired
	private InsInsuranceSlipService insInsuranceSlipService;
	@Autowired
	private InsTopBuyersService insTopBuyersService;

	/** PG2.1 订单列表 */
	private static final String ORDER_LIST = getViewPath("admin/shipment/declare/shipdeclare_manager_list");
	
	/**  出运订单详情页面*/
	private static final String EXPORTS_CREDIT_DETATIL = getViewPath("admin/shipment/declare/shipdeclare_credit_detatil");
	
	/** 后台管理登录页面 */
	private static final String ADMIN_LOGIN = getViewPath("admin/login/admin_login");
	
	
	@RequestMapping("/findOrderList")
	public String findOrderList(ModelMap model) {
		SysUser user= SysUserUtils.getUser();
		if(user==null){
			return  ADMIN_LOGIN;
		}
		List<ShipDeclareHtIndexVo> lis = shipDeclareService.getAllShipDeclare();
		model.addAttribute("shipDeclareList", lis);
		return ORDER_LIST;
	}
	
	private List<String> getInsuredNameList(Long orderFormId){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsInsuranceSlip(orderFormId);
		//获取被保险人列表
		if(insInsuranceSlip != null){
			List<InsRoleInpolicy> insRoleInpolicy = insInsuranceSlip.getRolesOfKind(ConstProp.DIGIT_ONE);
			List<String> insuredNameList = new ArrayList<String>();
			if(insRoleInpolicy != null){
				for (InsRoleInpolicy role : insRoleInpolicy) {
					insuredNameList.add(role.getName_cn());
				}
			}
			return insuredNameList != null ? insuredNameList : null;
		}else{
			return null;
		}
	}
	
	//获取结算方式下拉框
		private List<SysDictVo> getPaymentTermsList() {
			List<SysDict> paymentTerms = SysDictUtils.getDictList("paymentTerms");
			List<SysDictVo> paymentTermsList = new ArrayList<SysDictVo>();
			for (SysDict sysDict : paymentTerms) {
				SysDictVo sdv = new SysDictVo();
				sdv.setValue(sysDict.getValue());
				sdv.setType(sysDict.getType());
				sdv.setLabel(sysDict.getLabel());
				paymentTermsList.add(sdv);
			}
			return paymentTermsList;
		}

		// 获取运输方式下拉框
		private List<SysDictVo> getTransportTypeList() {
			List<SysDict> transportType = SysDictUtils.getDictList("transportType");
			List<SysDictVo> transportTypeList = new ArrayList<SysDictVo>();
			for (SysDict sysDict : transportType) {
				SysDictVo sdv = new SysDictVo();
				sdv.setValue(sysDict.getValue());
				sdv.setType(sysDict.getType());
				sdv.setLabel(sysDict.getLabel());
				transportTypeList.add(sdv);
			}
			return transportTypeList;
		}
	
	
	@RequestMapping("/goDetail/{externalReference}/{declareId}/{invoiceId}")
	public String goDetail(ModelMap model,@PathVariable String externalReference,@PathVariable Long declareId, @PathVariable Long invoiceId) throws IllegalAccessException, InvocationTargetException{
		ShipDeclareVo shipDeclareVo = new ShipDeclareVo();
		InsShipDeclare shipDeclare = shipDeclareService.selectById(declareId);
		InsShipInvoices shipInvoices = shipInvoicesService.selectById(invoiceId);
		BeanUtils.copyProperties(shipDeclareVo, shipDeclare);
//		shipDeclareVo.setinvoice_amounts(shipInvoices.getInvoice_amounts());
//		shipDeclareVo.setInvoiceNo(shipInvoices.getInvoice_no());
//		shipDeclareVo.setInsuredNameList(this.getInsuredNameList(shipDeclare.getInsurance_slip_id()));
		Long insTopBuyersId = shipDeclare.getSt_top_buyers_id();
		StTopBuyers insTopBuyers = insTopBuyersService.selectById(insTopBuyersId);
		String code = insTopBuyers.getCom_buyer().getCode();
		//重构中
		TopBuyersVo buyers  = insTopBuyersService.getBuyersVoById(insTopBuyersId);

		model.put("topBuyersVo", buyers);
		model.put("external_reference", externalReference);
		model.put("code", code);
		model.put("insTopBuyersId", shipDeclare.getSt_top_buyers_id());
		model.put("orderFormId", shipDeclare.getInsurance_slip_id());
		model.put("shipDeclareVo", shipDeclareVo);
		model.put("paymentTermsList", this.getPaymentTermsList());
		model.put("transportTypeList", this.getTransportTypeList());
		return EXPORTS_CREDIT_DETATIL;
	}

}
