package com.bcxin.ins.models.order.policy.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.models.order.policy.service.InsBuyersService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsTopBuyersService;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * <b>信用额度</b>
 * 
 * @author liyongqiang
 * @date 2017年1月8日 下午2:15:17
 * @注意事项 </b>
 * <b>
 */
@Controller
//@SessionAttributes("policy")//保单id
@RequestMapping("${systemPath}/exports/credit")
public class InsBuyerController  extends BaseController {
	
	@Autowired
	private InsInsuranceSlipService insInsuranceSlipService;//订单的service
	
	@Autowired
	private InsBuyersService insBuyersService;//买家的 service
	
	@Autowired
	private InsTopBuyersService insTopBuyersService;

	/**  保单列表选择页面  */
	private static final String EXPORTS_CREDIT_LIST = getViewPath("admin/policy/export/policy_credit_list");
	
	/**  信用额度详情页面 (修改额度用的)*/
	private static final String EXPORTS_CREDIT_DETATIL = getViewPath("admin/policy/export/policy_credit_detatil");


	/**  信用额度详情页面 （查看详情用的）*/
	private static final String EXPORTS_CREDIT_DETATIL_INFO = getViewPath("admin/policy/export/policy_credit_detatil_info");

	/**
	 * <b>保单选择  </b> 
	 * 
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月8日 下午2:23:04
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/policyChange")
	public String policyChange(Model model,DwzPage page) {
		SysUser user = SysUserUtils.getUser();
		List<TopBuyersVo> bList = insTopBuyersService.findTopBuyersOrder(page, user);
		model.addAttribute("bList", bList);
		return EXPORTS_CREDIT_LIST;
	}
	
	
	
	
	/**
	 * <b>审核某个用户的额度 </b> 
	 * 
	 * @param oid
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月17日 下午9:46:03
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/getTopBuyers/{oid}")
	public String getTopBuyers(@PathVariable Long oid,ModelMap model) {

		TopBuyersVo  topBuyersVo  =insTopBuyersService.getBuyersVoById(oid);
		model.addAttribute("topBuyersVo", topBuyersVo);
		return EXPORTS_CREDIT_DETATIL;
	}

	/**
	 * 获取详细信息
	 * @param oid
	 * @param model
	 * @return
	 */
	@RequestMapping("/getTopBuyersInfo/{oid}")
	public String getTopBuyersInfo(@PathVariable Long oid,ModelMap model) {

		TopBuyersVo  topBuyersVo  =insTopBuyersService.getBuyersVoById(oid);
		model.addAttribute("topBuyersVo", topBuyersVo);
		return EXPORTS_CREDIT_DETATIL_INFO;
	}


	/**
	 * <b>限额批复</b> 
	 * 
	 * @param model
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月8日 下午2:37:39
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/quotaApproval")
	@ResponseBody
	public AjaxResult quotaApproval(ModelMap model, TopBuyersVo  buyersVo,String buyerCode) {
		/*	已批复	2				  
		正常	3				  
		拒批	1			  
		取消申请	4				  
		申请中	0*/
//		InsBuyers insBuyers= insBuyersService.selectInsBuyersByCode(buyerCode);
//		if(insBuyers==null){
//			return fail(false,"卖家代码重复！！");
//		}

		if(buyersVo.getOid()!=null){
			 long  oid= Long.parseLong(buyersVo.getOid());
			 StTopBuyers topBuyers = insTopBuyersService.packagingInsTopBuyers(oid);
			 if(buyersVo.getReplaystatus().equals(ConstProp.DIGIT_ZERO)){//审核不通过
				 topBuyers.setReply_remark(buyersVo.getReply_remark());//设置通不过的理由
				 topBuyers.setApply_type(ConstProp.DIGIT_ONE);
				 topBuyers.setReply_date(new Date());
				 insTopBuyersService.updateById(topBuyers);
				 return success(true,"拒批成功！");
			 }else{
				 if(buyerCode==null||"".equals(buyerCode)){
					 return fail(false,"卖家代码不能为空！！");
				 }
				 topBuyers.setReply_amount(buyersVo.getReply_amount());
				 topBuyers.setUnused_amount(buyersVo.getReply_amount());
				 topBuyers.setApply_type(ConstProp.DIGIT_TWO);
				 ComBuyers buyers=topBuyers.getCom_buyer();
//				 if(buyers.getCode()==null){
//					 buyers.setCode(game(7));
//				 }
				 buyers.setCode(buyerCode);
				 insBuyersService.updateById(buyers);//保存买家代码
				 topBuyers.setReply_date(DateUtil.getTimestamp());
				 insTopBuyersService.updateById(topBuyers);
				 return json(true,"/exports/credit/policyChange");
			 }

		 }
		 return fail(false,"提交失败");
        
	}

	/**
	 * 获取count个随机数
	 * @param count 随机数个数
	 * @return
	 */
	public static String game(int count) throws Exception {
		Random r = new Random();;
		StringBuffer sb = new StringBuffer();
		String str = "0123456789";
		for(int i=0;i<count;i++){
			int num = r.nextInt(str.length());
			sb.append(str.charAt(num));
			str = str.replace((str.charAt(num)+""), "");
		}
		return sb.toString();
	}
	
}
