package com.bcxin.ins.models.order.policy.service.impl;


import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.models.order.policy.dao.SpecialExhibitionDao;
import com.bcxin.ins.models.order.policy.service.SpecialExhibitionService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>展责险特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialExhibitionServiceImpl extends ServiceImpl<SpecialExhibitionDao, SpecialExhibition> implements SpecialExhibitionService {

	@Autowired
	private SpecialExhibitionDao dao;

	public SpecialExhibition initSpecialExhibition(){
		SpecialExhibition specialExhibition = new SpecialExhibition();//
		dao.insert(specialExhibition);
		return specialExhibition;
	}

	/**
	 * <b>根据Vo及展责ID更新SpecialExhibition数据 </b>
	 *
	 * @param vo
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheSpecialExhibitionVoSetUpSpecialExhibition(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), specialExhibition);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(specialExhibition);
	}

	/**
	 * <b>获取SpecialExhibitionVo根据展责险id查询展责险信息插入到SpecialExhibitionVo </b>
	 *
	 * @param vo 展责险辅助表
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialExhibitionVoByPolicyID(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		if(specialExhibition != null){
			try {
				MyConverUtil.map2PO(MyConverUtil.PO2Map(specialExhibition), vo);
				if(specialExhibition.getStar_time() != null){
					vo.setStar_time(DateUtil.convertDateToString(specialExhibition.getStar_time(),DateUtil.FORMAT2));
				}
				if(specialExhibition.getEnd_time() != null){
					vo.setEnd_time(DateUtil.convertDateToString(specialExhibition.getEnd_time(),DateUtil.FORMAT2));
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}


	/**
	 * <b>获取SpecialExhibitionVo根据展责险id查询展责险信息插入到SpecialExhibitionVo </b>
	 *
	 * @param vo 展责险辅助表
	 * @param seID 展责险id
	 * @author ZXF
	 * @date 2017年9月12日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialExhibitionVoByPolicyID2(SpecialExhibitionVo vo, Long seID){
		SpecialExhibition specialExhibition = dao.selectById(seID);
		if(specialExhibition == null){
			return;
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(specialExhibition), vo);
			if(specialExhibition.getStar_time() != null){
				vo.setStar_time(DateUtil.convertDateToString(specialExhibition.getStar_time(),DateUtil.FORMAT1_1));
			}
			if(specialExhibition.getEnd_time() != null){
				vo.setEnd_time(DateUtil.convertDateToString(specialExhibition.getEnd_time(),DateUtil.FORMAT1_1));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
