package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsShipDeclare;
import com.bcxin.ins.models.order.policy.dao.ShipDeclareDao;
import com.bcxin.ins.models.order.policy.service.ShipDeclareService;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ShipDeclareHtIndexVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 出运Service
 * @author liumd
 * @date 2016年12月30日
 */
@Service
@Transactional
public class ShipDeclareServiceImpl extends ServiceImpl<ShipDeclareDao, InsShipDeclare> implements ShipDeclareService {
	
	@Autowired
	private ShipDeclareDao dao;

	@Override
	public InsShipDeclare getShipDeclareById(Long id) {
		List<InsShipDeclare> lis = dao.getShipDeclareById(id);
		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis.get(ConstProp.INT_NUMBER_ZERO) : null;
	}

//	@Override
//	public List<ShipDeclare> getShipDeclareByInsOrderFormId(Long insOrderFormId, DwzPage page) {
//		List<ShipDeclare> lis = new ArrayList<ShipDeclare>();
//		if(page != null){
//			Page<ShipDeclare> pageHelper = PageHelper.startPage(page.getPageNum(), page.getNumPerPage(), true);
//			lis = shipDeclareDao.getShipDeclareByInsOrderFormId(insOrderFormId);
//			page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
//		}else{
//			lis = shipDeclareDao.getShipDeclareByInsOrderFormId(insOrderFormId);
//		}
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
//	}

//	@Override
//	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormId(Long insOrderFormId, DwzPage page) {
//		Page<ShipDeclareMultipleVo> pageHelper = PageHelper.startPage(page.getPageNum(), page.getNumPerPage(), true);
//		List<ShipDeclareMultipleVo> lis = shipDeclareDao.getShipDeclareVoByInsOrderFormId(insOrderFormId);
//		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
//	}

//	@Override
//	public List<ShipDeclareMultipleVo> getShipDeclareVoByInsOrderFormIdAndVo(Long insOrderFormId, ShipDeclareStepTwoSearchVo searchVo, DwzPage page) {
//		String insured = null;
//		String country = null;
//		String buyerName = null;
//		String startDate = null;
//		String endDate = null;
//		String declareType = null;
//		if(StringUtils.isNotBlank(searchVo.getInsured())){
//			insured = searchVo.getInsured();
//		}
//		if(StringUtils.isNotBlank(searchVo.getCountry())){
//			country = searchVo.getCountry();
//		}
//		if(StringUtils.isNotBlank(searchVo.getBuyerName())){
//			buyerName = searchVo.getBuyerName();
//		}
//		if(StringUtils.isNotBlank(searchVo.getStartDate())){
//			startDate = searchVo.getStartDate() + " 00:00:00";
//		}
//		if(StringUtils.isNotBlank(searchVo.getEndDate())){
//			endDate = searchVo.getEndDate() + " 23:59:59";
//		}
//		if(StringUtils.isNotBlank(searchVo.getDeclareType())){
//			declareType = searchVo.getDeclareType();
//		}
//		Page<ShipDeclareMultipleVo> pageHelper = PageHelper.startPage(page.getPageNum(), page.getNumPerPage(), true);
//		List<ShipDeclareMultipleVo> lis = shipDeclareDao.getShipDeclareVoByInsOrderFormIdAndVo(insOrderFormId, insured, country, buyerName, startDate, endDate, declareType);
//		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
//	}

	@Override
	public List<ShipDeclareHtIndexVo> getAllShipDeclare() {
		InsInsuranceSlip insOrderForm = new   InsInsuranceSlip();
//		SysUser user = insOrderForm.getCurrentUser();

//		if(null!=user.getSysCompany().getCompanyType()&&user.getSysCompany().getCompanyType().equals(SysCompany.COMPANY_TYPE_SUPPLIER)){
//			this.dataScopeFilter(insOrderForm,"p.supplier_id");
//		}else{
//			this.dataScopeFilter(insOrderForm,"iof.company_id");
//		}
		List<ShipDeclareHtIndexVo> lis = dao.getAllShipDeclare(insOrderForm);

		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;

	}

//	@Override
//	public List<OrderFormVo> getCanShipDeclareList(Long userId, DwzPage page) {
//		Page<OrderFormVo> pageHelper = PageHelper.startPage(page.getPageNum(), page.getNumPerPage(), true);
//		List<OrderFormVo> lis = shipDeclareDao.getCanShipDeclareList(userId);
//		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
//	}
//
//	@Override
//	public OrderFormVo getOrderFormVoByOrderFormId(Long orderFormId) {
//		List<OrderFormVo> lis = shipDeclareDao.getOrderFormVoByOrderFormId(orderFormId);
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis.get(0) : null;
//	}
//
//	@Override
//	public List<String> getInsureNameList(Long orderFormId) {
//		List<String> lis = shipDeclareDao.getInsureNameList(orderFormId);
//		return lis.size() > ConstProp.INT_NUMBER_ZERO ? lis : null;
//	}
	
	

}
