package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.models.order.policy.dao.LnAccusedDao;
import com.bcxin.ins.models.order.policy.service.LnAccusedService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.LnAccusedVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class LnAccusedServiceImpl extends ServiceImpl<LnAccusedDao, LnAccused> implements LnAccusedService {

	@Autowired
	private LnAccusedDao dao;

	/**
	 * <b>根据InsTurnoverid查询  LnAccused列表</b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 上午10:46:29
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<LnAccused> selectLnAccusedBySpecialLitigation(Long oid) {
		return dao.selectLnAccusedBySpecialLitigation(oid);
	}

	/**
	 * <b>根据Vo及短期出口ID更新LnAccused数据 </b>
	 *
	 * @param vo
	 * @param turnover_id 销售额表id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	/*public void accordingToTheLnAccusedVoSetUpLnAccused(LnAccusedVo vo,Long turnover_id){
		LnAccused insForecastedDetail = null;
		if(StringUtil.isNotEmpty(vo.getOid())){
			insForecastedDetail = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insForecastedDetail = new LnAccused();
			insForecastedDetail.getInsTurnover().setId(turnover_id);
			dao.insert(insForecastedDetail);
		}
		insForecastedDetail.setCountry(vo.getCountry());
		insForecastedDetail.setAnnualSales(vo.getAnnualSales());
		insForecastedDetail.setHca(vo.getHca());
		insForecastedDetail.setBuyersNum(vo.getBuyersNum());
		insForecastedDetail.setPaymentTerms(vo.getPaymentTerms());
		dao.updateById(insForecastedDetail);
	}*/

	/**
	 * <b>接收页面传回的未来一年内所须投保的信用销售总额信息列表进行更新 </b>
	 *
	 * @param voList 未来一年内所须投保的信用销售总额信息列表
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setLnAccusedByLnAccusedVo(List<LnAccusedVo> voList, Long special_litigation_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			ruleOutDoesNotExist(voList, special_litigation_id);
			for(LnAccusedVo vo : voList){
				accordingToTheLnAccusedVoSetUpLnAccused(vo,special_litigation_id);
			}
		}
	}

	/**
	 * <b>排除数据库存在的但页面被删除的条目信息，获取这些条目并删除 </b>
	 *
	 * @param voList
	 * @param special_litigation_id
	 * @author ZXF
	 * @date 2017年1月13日 上午10:59:02
	 * @注意事项 </b>
	 * <b>
	 */
	private void ruleOutDoesNotExist(List<LnAccusedVo> voList,
									 Long special_litigation_id) {
		List<LnAccused> fdList = selectLnAccusedBySpecialLitigation(special_litigation_id);
		for(LnAccused ifd : fdList){
			int i = ConstProp.INT_NUMBER_ZERO;
			for(LnAccusedVo vo : voList){
				if(StrUtil.isNotBlank(vo.getOid())){
					if(ifd.getLn_accused_id() == Long.parseLong(vo.getOid())){
						i = ConstProp.INT_NUMBER_ONE;
					}
				}
			}
			if(i == ConstProp.INT_NUMBER_ZERO){
				dao.deleteById(ifd.getLn_accused_id());
			}
		}
	}

	/**
	 * <b>根据未来一年内所须投保的信用销售总额交互辅助类更新LnAccused数据 </b>
	 *
	 * @param vo
	 * @param special_litigation_id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheLnAccusedVoSetUpLnAccused(LnAccusedVo vo, Long special_litigation_id){
		LnAccused lnAccused = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			lnAccused = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			lnAccused = new LnAccused();
			SpecialLitigation sl = new SpecialLitigation();
			sl.setSpecial_litigation_id(special_litigation_id);
			lnAccused.setSpecial_litigation(sl);
			dao.insert(lnAccused);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), lnAccused);
		} catch (Exception e) {
			e.printStackTrace();
		}
		lnAccused.setPar_business_path(StringUtils.isNotEmpty(vo.getPar_business_path()) ? vo.getPar_business_path() : ConstProp.DIGIT_ZERO);
		lnAccused.setPar_address_path(StringUtils.isNotEmpty(vo.getPar_address_path()) ? vo.getPar_address_path() : ConstProp.DIGIT_ZERO);
		lnAccused.setPar_idcard_path(StringUtils.isNotEmpty(vo.getPar_idcard_path()) ? vo.getPar_idcard_path() : ConstProp.DIGIT_ZERO);
		lnAccused.setPar_organizing_code(StringUtils.isNotEmpty(vo.getPar_organizing_code()) ? vo.getPar_organizing_code() : ConstProp.DIGIT_ZERO);
		lnAccused.setPar_spouse_card_path(StringUtils.isNotEmpty(vo.getPar_spouse_card_path()) ? vo.getPar_spouse_card_path() : ConstProp.DIGIT_ZERO);
		lnAccused.setPar_trauschein_path(StringUtils.isNotEmpty(vo.getPar_trauschein_path()) ? vo.getPar_trauschein_path() : ConstProp.DIGIT_ZERO);
		dao.updateById(lnAccused);
	}

	/**
	 * <b>根据List<LnAccused>封装到 List<LnAccusedVo>中</b>
	 *
	 * @param fdList
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午3:18:47
	 * @注意事项 </b>
	 * <b>
	 */
	public List<LnAccusedVo> packagingLnAccusedVoListByLnAccusedList(List<LnAccused> fdList){
		List<LnAccusedVo> voList = new ArrayList<LnAccusedVo>();
		if(fdList != null ){
			for(LnAccused ifd : fdList){
				voList.add(accordingToLnAccusedIntoLnAccusedVo(ifd));
			}
		}
		return voList;
	}

	/**
	 * <b>根据未来一年内所须投保的信用销售总额表信息转换成 LnAccusedVo </b>
	 *
	 * @param lnAccused
	 * @return
	 * @author ZXF
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	public LnAccusedVo accordingToLnAccusedIntoLnAccusedVo(LnAccused lnAccused){
		LnAccusedVo vo = new LnAccusedVo();
		vo.setOid(String.valueOf(lnAccused.getLn_accused_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(lnAccused), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setPar_address_path(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_address_path()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_address_path());
		vo.setPar_business_path(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_business_path()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_business_path());
		vo.setPar_idcard_path(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_idcard_path()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_idcard_path());
		vo.setPar_organizing_code(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_organizing_code()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_organizing_code());
		vo.setPar_spouse_card_path(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_spouse_card_path()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_spouse_card_path());
		vo.setPar_trauschein_path(ConstProp.DIGIT_ZERO.equals(lnAccused.getPar_trauschein_path()) ? ConstProp.BLANK_CHAR : lnAccused.getPar_trauschein_path());
		return vo;
	}
}
