package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.entity.MySysClientUser;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.MySysClientUserService;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.entity.policy_special.*;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.order.policy.dao.HirelingDao;
import com.bcxin.ins.models.order.policy.dao.InsRoleInpolicyDao;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>订单相关业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsuranceOperationServiceImpl implements InsuranceOperationService {

	private Logger log =  LoggerFactory.getLogger(InsuranceOperationServiceImpl.class);

	@Autowired
	private InsInsuranceSlipService insInsuranceSlipService;
	@Autowired
	private InsAgreementService insAgreementService;
	@Autowired
	private InsMicroExportService insMicroExportService;
	@Autowired
	private InsRoleInpolicyService insRoleInpolicyService;
	@Autowired
	private InsRoleInpolicyDao insRoleInpolicyDao;
	@Autowired
	private InsCommonExportService insCommonExportService;
	
	@Autowired
	private InsProductService insProductService;
	@Autowired
	private InsProductResponsibilityService insProductResponsibilityService;
	@Autowired
	private InsMailPolicyService insMailPolicyService;
	@Autowired
	private InsTransactionService insTransactionService;
	@Autowired
	private SpecialLitigationService specialLitigationService;
	@Autowired
	private SpecialBidService insSpecialBidService;
	@Autowired
	private SpecialPerformanceService insSpecialPerformanceService;
	@Autowired
	private SpecialPublicDutyService specialPublicDutyService;
	@Autowired
	private MySysClientUserService mySysClientUserService;
	@Autowired
	private SysLogService logService;
	@Autowired
	private InsUnderwriteService insUnderwriteService;
	@Autowired
	private SpecialExhibitionService specialExhibitionService;
	@Autowired
	private HirelingService hirelingService;
	@Autowired
	private HirelingDao hirelingDao;
	@Autowired
	private LnAccusedService lnAccusedService;
	@Autowired
	private PreseverApplyService preseverApplyService;
	@Autowired
	private ComTaskResidualService comTaskResidualService;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;

	/**
	 * 查看订单详情时获取订单承保表信息，有记录直接去，没记录就新增
	 * @param order
	 * @return
	 */
	public UnderwriteVo getUnderwriteByOrder(InsInsuranceSlip order){
		UnderwriteVo result = null;
		try {
			if(order != null){
				if(order.getUnderwrite() == null){
					insUnderwriteService.initInsUnderwrite();
					order.setUnderwrite(insUnderwriteService.initInsUnderwrite());
					insInsuranceSlipService.updateById(order);
				}
				result = insUnderwriteService.accordingToInsUnderwriteIntoUnderwriteVo(order.getUnderwrite());
			}
		}catch (Exception e){
			log.error("订单承保表更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return result;
	}

	/**
	 * 信用险核保信息更新，自平台调用
	 * @param signOperate
	 * @param vo
	 * @param order_id
	 * @return
	 */
	public AjaxResult updateOrderAudit(String signOperate, UnderwriteVo vo, Long order_id){
		try {
			if(ConstProp.DIGIT_ONE.equals(vo.getPayment_way())){
				vo.setYear_premium(vo.getInitial_premium());
			}
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.getInsOrderForm(order_id);
			if(insInsuranceSlip == null){
				return new AjaxResult(false, "核保数据丢失!");
			}
			vo.setIns_insurance_slip_id(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			if(StrUtil.isNotBlank(vo.getYear_premium())){
				insInsuranceSlip.setPremium(new BigDecimal(vo.getYear_premium()));
			}
			if(StrUtil.isNotBlank(vo.getTotal_rate())){
				insInsuranceSlip.setRate(new BigDecimal(vo.getTotal_rate()));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			insUnderwriteService.accordingToTheUnderwriteVoSetUpInsUnderwrite(vo);
			if(StrUtil.isBlank(vo.getOid())){
				return new AjaxResult(false, "核保信息更新失败!");
			}
			if(StrUtil.isNotBlank(signOperate)){
				if(StrUtil.isNotBlank(updateDataByUnderWrite(order_id,vo))){
					return new AjaxResult(true, "核保信息更新成功!");
				}else{
					return new AjaxResult(false, "核保状态更新失败!");
				}
			}else{
				return new AjaxResult(true, "核保信息保存成功!");
			}
		}catch (Exception e){
			log.error("核保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "核保信息更新出现异常!");
		}
	}

	/**
	 * 信用险核保信息更新，外平台调用
	 * @param request
	 * @param vo
	 * @param order_id
	 * @return
	 */
	public AjaxResult updateOrderAudit_API(HttpServletRequest request, String signOperate, String sup_id, UnderwriteVo vo, Long order_id){
		try {
			if(ConstProp.DIGIT_ONE.equals(vo.getPayment_way())){
				vo.setYear_premium(vo.getInitial_premium());
			}
			InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.getInsOrderForm(order_id);
			if(insInsuranceSlip == null){
				return new AjaxResult(false, "核保数据丢失!");
			}
			vo.setIns_insurance_slip_id(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
			if(StrUtil.isNotBlank(vo.getYear_premium())){
				insInsuranceSlip.setPremium(new BigDecimal(vo.getYear_premium()));
			}
			if(StrUtil.isNotBlank(vo.getTotal_rate())){
				insInsuranceSlip.setRate(new BigDecimal(vo.getTotal_rate()));
			}
			insInsuranceSlipService.updateById(insInsuranceSlip);
			insUnderwriteService.accordingToTheUnderwriteVoSetUpInsUnderwrite(vo);
			if(StrUtil.isBlank(vo.getOid())){
				return new AjaxResult(false, "核保信息更新失败!");
			}
			if(StrUtil.isNotBlank(signOperate)){
				if(StrUtil.isNotBlank(updateDataByUnderWrite(order_id,vo))){
					creatLog(request,"订单管理->核保-修改",null,sup_id);
					return new AjaxResult(true, "核保信息更新成功!");
				}else{
					return new AjaxResult(false, "核保状态更新失败!");
				}
			}else{
				return new AjaxResult(true, "核保信息保存成功!");
			}
		}catch (Exception e){
			log.error("核保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "核保信息更新出现异常!");
		}
	}

	/***
	 * 更新核保业务状态
	 * @return
	 */
	private String updateDataByUnderWrite(Long order_id,UnderwriteVo vo){
		String result = ConstProp.BLANK_CHAR;
		try {
			//完成更新后变更订单状态
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(order_id);
			String oStatus = ConstProp.DIGIT_FOUR;
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){ //诉讼核保完到支付
				oStatus = ConstProp.DIGIT_THREE;
			}
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(orderVo.getProduct_code())){//小微只需要核保
				oStatus = ConstProp.DIGIT_FIVE;
			}
			orderVo.setPolicy_status(oStatus);//改状态为“已核保”
			result = updateOrderFormStatus(orderVo);
		}catch (Exception e){
			log.error("核保状态更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return result;
	}

	/**
	 * 核保不通过业务方法，自平台调用
	 * @param ty
	 * @param remarks
	 * @param order_id
	 * @return
	 */
	public String orderAuditFail(String ty, String remarks, Long order_id){
		String result = ConstProp.BLANK_CHAR;
		try {
			if(ConstProp.DIGIT_ONE.equals(ty)){//1为核保不通过
				remarks = "核保不通过理由："+remarks;
			}else if(ConstProp.DIGIT_TWO.equals(ty)){//2为承保不通过
				remarks = "承保不通过理由："+remarks;
			}
			InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
			order.setRemarks(remarks);
			insInsuranceSlipService.updateById(order);
			//完成更新后变更订单状态
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(order_id);
			orderVo.setPolicy_status(ConstProp.DIGIT_FIFTEEN);//改状态为“已拒保”
			result = updateOrderFormStatus(orderVo);
		}catch (Exception e){
			log.error("核保不通过信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return result;
	}

	/**
	 * 核保不通过业务方法，自平台调用
	 * @param ty
	 * @param remarks
	 * @param order_id
	 * @return
	 */
	public String orderAuditFail_API(HttpServletRequest request, String sup_id, String ty, String remarks, Long order_id){
		String result = ConstProp.BLANK_CHAR;

		try {
			if(ConstProp.DIGIT_ONE.equals(ty)){//1为核保不通过
				remarks = "核保不通过理由："+remarks;
			}else if(ConstProp.DIGIT_TWO.equals(ty)){//2为承保不通过
				remarks = "承保不通过理由："+remarks;
			}
			InsInsuranceSlip order = insInsuranceSlipService.selectById(order_id);
			order.setRemarks(remarks);
			insInsuranceSlipService.updateById(order);
			//完成更新后变更订单状态
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(order_id);
			orderVo.setPolicy_status(ConstProp.DIGIT_FIFTEEN);//改状态为“已拒保”
			result = updateOrderFormStatus(orderVo);
			creatLog(request,"订单管理->核/承保->拒保",null,sup_id);
		}catch (Exception e){
			log.error("核保不通过信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return result;
	}

	/**
	 * 订单承保业务处理（信用险），自平台业务
	 * @param orderFormVo 订单部分信息
	 * @param underwritingOid 承保表id
	 * @param acceptanceTime 承保时间
	 * @param out_of_pocket 实收金额
	 * @param signOperate 是否更新状态
	 * @return
	 */
	public AjaxResult updateOrderUnderwriting(OrderFormVo orderFormVo,String underwritingOid,String acceptanceTime,String out_of_pocket,String signOperate){
		if(StrUtil.isBlank(orderFormVo.getOid())){
			return new AjaxResult(false, "承保失败!");
		}
		try {
			//完成更新后变更订单状态
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(Long.parseLong(orderFormVo.getOid()));
			if(StrUtil.isNotBlank(underwritingOid)&&StrUtil.isNotBlank(acceptanceTime)){
				InsUnderwrite insUnderwrite = insUnderwriteService.selectById(Long.parseLong(underwritingOid));
				insUnderwrite.setAcceptance_time(com.bcxin.ins.util.toolbox.DateUtil.parse(acceptanceTime,"yyyy/MM/dd"));
				insUnderwriteService.updateById(insUnderwrite);
			}
			updatePayNumber(orderFormVo.getOid(), orderFormVo.getPay_order_number(), out_of_pocket, orderVo.getProduct_code());
			insInsuranceSlipService.updateOrderUnderwriting(orderFormVo);
			if(StrUtil.isBlank(signOperate)){
				return new AjaxResult(true, "已保存承保信息!");
			}

			String oStatus = DictConst.ORDER_STATUS_YCB;
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.BZX_SSBQ.equals(orderVo.getProduct_code())){ //诉讼核保完到支付
				oStatus = DictConst.ORDER_STATUS_YCB;
			}
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(orderVo.getProduct_code())){//小微承保后直接为已承保
				oStatus = DictConst.ORDER_STATUS_YCB;
			}
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){//企业短期承保后直接为已承保
				oStatus = DictConst.ORDER_STATUS_HZF;
			}
			orderVo.setPolicy_status(oStatus);
			if(StrUtil.isNotBlank(updateOrderFormStatus(orderVo))){
				return new AjaxResult(true, "承保信息更新成功!");
			}else{
				return new AjaxResult(false, "承保状态更新失败!");
			}
		}catch (Exception e){
			log.error("承保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "承保信息更新出现异常!");
		}
	}

	/**
	 * <b> 诉讼更新支付凭证 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 10:55
	 * @version
	 * @注意事项 </b>
	 */
	private void updatePayNumber(String oid, String pay_order_number, String out_of_pocket, String product_code) {
		if(StringUtils.isEmpty(product_code)){
			return;
		}
		if(!"BZX-GCLY".equals(product_code) && !"BZX-SSBQ".equals(product_code)){
			return;
		}
		if(StrUtil.isBlank(pay_order_number)||StrUtil.isBlank(out_of_pocket)) {
			return;
		}
		//更新支付凭证号
		List<InsTransaction> tranList = insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(oid));
		if(tranList != null ? tranList.size()> ConstProp.INT_NUMBER_ZERO : false){
			InsTransaction tran = tranList.get(ConstProp.INT_NUMBER_ZERO);
			tran.setPay_order_number(pay_order_number);
			tran.setOut_of_pocket(new BigDecimal(out_of_pocket));
			tran.setStatus(ConstProp.INT_NUMBER_ONE);  //设置为已支付
			tran.setTransaction_status(DictConst.PAY_STATUS_YZF);
			tran.setEnd_time(new Date());//交易结束时间
			insTransactionService.updateById(tran);
		}
	}

	/**
	 * 订单承保业务处理（信用险），对接外部平台业务方法
	 * @param request
	 * @param sup_id
	 * @param orderFormVo
	 * @param underwritingOid
	 * @param acceptanceTime
	 * @param out_of_pocket
	 * @param signOperate
	 * @return
	 */
	@Override
	public AjaxResult updateOrderUnderwriting_API(HttpServletRequest request,String sup_id,OrderFormVo orderFormVo,String underwritingOid,String acceptanceTime,String out_of_pocket,String signOperate){
		if(StrUtil.isBlank(orderFormVo.getOid())){
			return new AjaxResult(false, "承保失败!");
		}
		try {
			//完成更新后变更订单状态
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(Long.parseLong(orderFormVo.getOid()));
			if(StrUtil.isNotBlank(underwritingOid)&&StrUtil.isNotBlank(acceptanceTime)){
				InsUnderwrite insUnderwrite = insUnderwriteService.selectById(Long.parseLong(underwritingOid));
				insUnderwrite.setAcceptance_time(com.bcxin.ins.util.toolbox.DateUtil.parse(acceptanceTime,"yyyy/MM/dd"));
				insUnderwriteService.updateById(insUnderwrite);
			}
			updatePayNumber(orderFormVo.getOid(), orderFormVo.getPay_order_number(), out_of_pocket, orderVo.getProduct_code());
			insInsuranceSlipService.updateOrderUnderwriting(orderFormVo);
			if(StrUtil.isBlank(signOperate)){
				return new AjaxResult(true, "已保存承保信息!");
			}

			String oStatus = ConstProp.DIGIT_SIX;
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.BZX_SSBQ.equals(orderVo.getProduct_code())){ //诉讼核保完到支付
				oStatus = ConstProp.DIGIT_SIX;
			}
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(orderVo.getProduct_code())){//小微承保后直接为已承保
				oStatus = ConstProp.DIGIT_SIX;
			}
			if(StringUtils.isEmpty(orderVo.getProduct_code()) ? false : ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){//企业短期承保后直接为已承保
				oStatus = "16";
			}
			orderVo.setPolicy_status(oStatus);
			if(StrUtil.isNotBlank(updateOrderFormStatus(orderVo))){
				creatLog(request,"订单管理->承保-修改",null,sup_id);
				return new AjaxResult(true, "承保信息更新成功!");
			}else{
				return new AjaxResult(false, "承保状态更新失败!");
			}
		}catch (Exception e){
			log.error("承保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "承保信息更新出现异常!");
		}
	}

	/**
	 * 更新线下交易产生的交易记录信息，自平台调用
	 * @param payOrderNumbers
	 * @param order_id
	 * @return
	 */
	@Override
	public AjaxResult updateTransactionPayOrderNumber(String[] payOrderNumbers, String order_id){
		try {
			if(payOrderNumbers.length<=ConstProp.INT_NUMBER_ZERO || StrUtil.isBlank(order_id)){
				return new AjaxResult(false, "承保失败!");
			}
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(Long.parseLong(order_id));
			if(orderVo == null){
				return new AjaxResult(false, "数据丢失!");
			}
			for(String str : payOrderNumbers){
				String[] arr = str.split(ConstProp.SEMICOLON);
				if(StrUtil.isBlank(arr[ConstProp.INT_NUMBER_ONE])){
					return new AjaxResult(false, "支付凭证号不能为空!");
				}
				InsTransaction insTransaction = insTransactionService.selectById(arr[ConstProp.INT_NUMBER_ZERO]);
				if(insTransaction == null){
					continue;
				}
				insTransaction.setPay_order_number(arr[ConstProp.INT_NUMBER_ONE]);
				insTransaction.setOut_of_pocket(new BigDecimal(arr[ConstProp.INT_NUMBER_TWO]));
				insTransaction.setTransaction_status(DictConst.PAY_STATUS_YZF);
				insTransaction.setEnd_time(DateUtil.getTimestamp());
				insTransactionService.updateById(insTransaction);
				if(StringUtils.isEmpty(orderVo.getProduct_code())){
					continue;
				}
				if(!ConstProp.XYX_DQCK.equals(orderVo.getProduct_code()) && !orderVo.getProduct_code().contains(ConstProp.GZZRX_PAC)){
					continue;
				}
				updateOrderStatusByTrans(orderVo);
				//线下交易传给支撑
				InsInsuranceSlip insPolicy = insInsuranceSlipService.selectById(orderVo.getOid());
				OrderSupportUtil.receiveTrancetionData(insPolicy,insTransaction);
			}
			return new AjaxResult(true, "已保存支付凭证信息!");

		}catch (Exception e){
			log.error("承保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "承保信息更新出现异常!");
		}
	}

	/**
	 * <b> 根据交易记录的分期类型修改订单状态 </b>
	 * @author ZXF
	 * @create 2020/09/14 0014 11:19
	 * @version
	 * @注意事项 </b>
	 */
	private void updateOrderStatusByTrans(OrderFormVo orderVo) {
		OrderFormVo ovo = null;
		if(ConstProp.DIGIT_ONE.equals(orderVo.getPay_methods())||orderVo.getProduct_code().contains(ConstProp.GZZRX_PAC)){
            //如果一次性就变更状态
            ovo = new OrderFormVo();
        }else if(ConstProp.DIGIT_TWO.equals(orderVo.getPay_methods())){
            //如果分期就满条件后变更状态
            List<InsTransaction> transactionList = accordingToOrderIDToGetInsTransaction(Long.parseLong(orderVo.getOid()));
            BigDecimal totalAm = BigDecimal.ZERO;
            for(InsTransaction tra : transactionList){
                totalAm = totalAm.add(tra.getOut_of_pocket());
            }
            BigDecimal _a = totalAm.setScale(ConstProp.INT_NUMBER_TWO,BigDecimal.ROUND_HALF_DOWN);//实收
            BigDecimal _b = (new BigDecimal(orderVo.getGross_premium())).setScale(ConstProp.INT_NUMBER_TWO,BigDecimal.ROUND_HALF_DOWN);//总保费
            if((transactionList.size() < 6) && !((_a.compareTo(_b) <0))){
                ovo = new OrderFormVo();
            }
        }
		if(ovo != null){
            ovo.setOid(orderVo.getOid());
            ovo.setPolicy_status(ConstProp.DIGIT_SIX);
            ovo.setProduct_code(orderVo.getProduct_code());
            updateOrderFormStatus(ovo);
        }
	}

	/**
	 * <b> 修改保单投保人的联系人信息 </b>
	 * @author ZXF
	 * @create 2020/01/17 0017 19:58
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult updateInsRolePolicyLink(ParamVo paramVo){
		try {
			if(StringUtils.isEmpty(paramVo.getOid())
					||StringUtils.isEmpty(paramVo.getTel())
					||StringUtils.isEmpty(paramVo.getEmail())){
				return new AjaxResult(false, "联系人信息不完整!");
			}
			int count = insRoleInpolicyDao.updateInsRolePolicyLink(paramVo.getOid(), paramVo.getName(), paramVo.getTel(), paramVo.getEmail());
			if(count>0){
				return new AjaxResult(true, "修改联系人信息成功!");
			}
			return new AjaxResult(false, "未完成联系人信息修改!");
		}catch (Exception e){
			log.error("修改联系人信息过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "修改联系人信息出现异常!");
		}
	}

	/**
	 * 更新线下交易产生的交易记录信息，外平台调用
	 * @param payOrderNumbers
	 * @param order_id
	 * @return
	 */
	@Override
	public AjaxResult updateTransactionPayOrderNumber_API(HttpServletRequest request, String sup_id, String[] payOrderNumbers, String order_id){
		try {
			if(payOrderNumbers.length<=ConstProp.INT_NUMBER_ZERO || StrUtil.isBlank(order_id)){
				return new AjaxResult(false, "承保失败!");
			}
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(Long.parseLong(order_id));
			if(orderVo == null){
				return new AjaxResult(false, "数据丢失!");
			}
			for(String str : payOrderNumbers){
				String[] arr = str.split(ConstProp.SEMICOLON);
				if(StrUtil.isBlank(arr[ConstProp.INT_NUMBER_ONE])){
					return new AjaxResult(false, "支付凭证号不能为空!");
				}
				InsTransaction insTransaction = insTransactionService.selectById(arr[ConstProp.INT_NUMBER_ZERO]);
				if(insTransaction == null){
					continue;
				}
				insTransaction.setPay_order_number(arr[ConstProp.INT_NUMBER_ONE]);
				insTransaction.setOut_of_pocket(new BigDecimal(arr[ConstProp.INT_NUMBER_TWO]));
				insTransaction.setTransaction_status(DictConst.PAY_STATUS_YZF);
				insTransaction.setEnd_time(DateUtil.getTimestamp());
				insTransactionService.updateById(insTransaction);
				if(StringUtils.isEmpty(orderVo.getProduct_code())){
					continue;
				}
				if(!ConstProp.XYX_DQCK.equals(orderVo.getProduct_code()) && !orderVo.getProduct_code().contains(ConstProp.GZZRX_PAC)){
					continue;
				}
				updateOrderStatusByTrans(orderVo);
				//线下交易传给支撑
				InsInsuranceSlip insPolicy = insInsuranceSlipService.selectById(orderVo.getOid());
				OrderSupportUtil.receiveTrancetionData(insPolicy,insTransaction);
			}
			creatLog(request,"订单管理->支付确认",null,sup_id);
			return new AjaxResult(true, "已保存支付凭证信息!");
		}catch (Exception e){
			log.error("承保信息更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "承保信息更新出现异常!");
		}
	}


























/********************************** 以上信息由控制层业务代码抽取后创建的业务方法****************************************************/

	/**
	 * <b>初始化订单相关表 </b> 
	 * 
	 * @param poductID
	 * @param user_id
	 * @author ZXF 
	 * @date 2017年1月9日 下午2:00:35
	 * @注意事项 </b>
	 * <b>
	 */
	public InsInsuranceSlip initOrderCorrelation(Long poductID, Long user_id){
		InsInsuranceSlip insOrderForm = insInsuranceSlipService.initOrderForm(poductID, user_id);
		return insOrderForm;
	}
	
	/**
	 * <b>小微企业接收页面传回的值  SET METHOD </b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void setMicroExportByMicroExportVo(MicroExportVo vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
		vo.setOrder_status(insInsuranceSlip.getOrder_status());
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getExport_amount()), insInsuranceSlip);
	}
	
	/**
	 * <b>根据订单id查询小微短期信息设置到MicroExportVo   GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public MicroExportVo getMicroExportVoByOrderID(Long orderID){
		MicroExportVo vo = new MicroExportVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
		}
		if(insInsuranceSlip.getInsured_amount() != null){
			vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_1）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void setCommonExportByCommonExportVo_1(CommonExportVo_1 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
		/*vo.setTradeSerialNumber(insOrderForm.getTradeSerialNumber());
		vo.setOrderStatus(insOrderForm.getOrderStatus());*/
		insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
		insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
		insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getRoleSubjectList().get(0).getTurnover_export()), insInsuranceSlip);
	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_2）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void setCommonExportByCommonExportVo_2(CommonExportVo_2 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
	}
	
	/**
	 * <b>企业短期出口特殊字段信息表接收页面传回的值（CommonExportVo_3）   SET METHOD</b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void setCommonExportByCommonExportVo_3(CommonExportVo_3 vo){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
		insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
		insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
	}
	
	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_1  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public CommonExportVo_1 getCommonExportVo_1ByOrderID(Long orderID){
		CommonExportVo_1 vo = new CommonExportVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}
	
	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_2  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public CommonExportVo_2 getCommonExportVo_2ByOrderID(Long orderID){
		CommonExportVo_2 vo = new CommonExportVo_2();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询企业短期出口特殊字段信息设置到CommonExportVo_3  GET METHOD</b> 
	 * 
	 * @param orderID 订单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public CommonExportVo_3 getCommonExportVo_3ByOrderID(Long orderID) {
		CommonExportVo_3 vo = new CommonExportVo_3();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}
	
	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b> 
	 * 
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF 
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page){
		return insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo( user_id, status, page);
	}
	
	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b> 
	 * 
	 * @param user_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id){
		return insInsuranceSlipService.selectOrderStatusCountVoByUserID(user_id);
	}
	
	/**
	 * <b>查询所有产品 </b> 
	 * 
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:45:30
	 * @注意事项 </b>
	 * <b>
	 */
	public List<ProductVo> selectProductVoList(ProPrimary insProduct){
		return insProductService.selectProductVoList(insProduct);
	}
	
	/**
	 * <b>根据产品id查询并封装到ProductVo </b>
	 * 
	 * @param insProductID
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID){
		return insProductService.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
	}
	
	/**
	 * <b>根据订单id查询并封装到OrderFormVo </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	public OrderFormVo accordingToOrderIDToGetOrderFormVo(Long order_id){
		/*InsOrderForm order = insInsuranceSlipService.packagingInsOrderForm(order_id);
		return insInsuranceSlipService.willInsOrderFormSetUpOrderFormVo(order);*/
		return insInsuranceSlipService.findOrderFormVoByID(order_id);
	}

	/**
	 * <b>根据订单id查询并封装到AdviceNoteVo </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id){
		InsInsuranceSlip order = insInsuranceSlipService.packagingInsOrderForm(order_id);
		return insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
	}
	
	/**
	 * <b>修改订单状态 </b> 
	 * 
	 * @param vo
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	public String updateOrderFormStatus(OrderFormVo vo){
		if((ConstProp.DIGIT_SIX.equals(vo.getPolicy_status())&&(!ConstProp.XYX_DQCK.equals(vo.getProduct_code()))) || "16".equals(vo.getPolicy_status())){
			orderSyncZC(vo.getOid());
		}
		return insInsuranceSlipService.updateOrderFormStatus(vo);
	}

	/**
	 * <b>查询所有有效订单并同步到支撑</b>
	 *
	 * @author ZXF
	 * @date 2017年7月5日 上午16:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	public AjaxResult orderUnSyncDispose(){
		try {
			List<OrderFormVo> voList = insInsuranceSlipService.findInsOrderFormByUnSync();
			for(OrderFormVo vo : voList){
				orderSyncZC(vo.getOid());
			}
			return new AjaxResult(true, "订单同步操作成功!");
		}catch (Exception e){
			log.error("订单同步操作过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "订单同步操作出现异常!");
		}
	}

	@Override
	public AjaxResult orderUnSyncDispose_API(HttpServletRequest request){
		try {
			List<OrderFormVo> voList = insInsuranceSlipService.findInsOrderFormByUnSync();
			for(OrderFormVo vo : voList){
				orderSyncZC(vo.getOid());
			}
			creatLog(request,"订单管理->订单同步",null,request.getParameter("sup_id"));
			return new AjaxResult(true, "订单同步操作成功!");
		}catch (Exception e){
			creatLog(request,"订单管理->订单同步",e,request.getParameter("sup_id"));
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return new AjaxResult(false, "订单同步操作出现异常!");
		}
	}

	/**
	 * 日志记录，主要应用于对接第三方平台，解决不存在用户时的日志记录
	 * @param request
	 * @param title
	 * @param ex
	 * @param com_id
	 */
	public void creatLog(HttpServletRequest request, String title, Exception ex, String com_id){
		try {
			SysLog log = new SysLog();
			log.setTitle(title);
			log.setType(ex == null ? SysLog.TYPE_ACCESS : SysLog.TYPE_EXCEPTION);
			log.setRemoteAddr(StrUtil.getRemoteAddr(request));
			log.setUserAgent(request.getHeader("user-agent"));
			log.setRequestUri(request.getRequestURI());
			log.setParams(request.getParameterMap());
			log.setMethod(request.getMethod());
			log.setCompany_id(com_id);
			if(ex != null){
				log.setException(Exceptions.getStackTraceAsString(ex));
			}
			log.preInsert();
			myAsyncExecutor.execute(()->{
				logService.insert(log);
			});
		} catch(Exception e) {
			log.error("日志更新过程事务发现异常，回滚数据",e);
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
	}

	/**
	 * <b>有效订单同步到支撑</b>
	 *
	 * @param oid 投保订单id（insInsuranceSlip.id）
	 * @author ZXF
	 * @date 2017年7月5日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void orderSyncZC(String oid){
		if(StringUtils.isEmpty(oid)){
			return;
		}
		//承保订单传给支撑
		InsInsuranceSlip policy = insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
		if(policy.getOrder_zc_id() == null){
			OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(policy.getIns_insurance_slip_id());
			InsTransaction it = null;
			if(policy.getInsTransaction()!=null && !policy.getInsTransaction().isEmpty()){
				it = policy.getInsTransaction().get(0);
			}
			MySysClientUser user=mySysClientUserService.selectById(policy.getRegister_user_id());
			String insName = ConstProp.BLANK_CHAR;
			if(ConstProp.GZX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[0])){
				SpecialPublicDutyVo vo = getSpecialPublicDutyVoByOrderID(Long.parseLong(orderVo.getOid()));
				insName = vo.getReport_name();
			}
			if(ConstProp.ZZX.equals(orderVo.getProduct_code().split(ConstProp.MINUS)[0])){
				LOTEPolicyVo vo = getLOTEPolicyVoByOrderID(Long.parseLong(orderVo.getOid()));
				insName = vo.getSpecialExhibitionVo().getName();
			}
			String sup_order_id = OrderSupportUtil.receiveOrderFormData(String.valueOf(user.getBusiness_support_id()), orderVo,policy,it,insName);
			if(StringUtils.isNotEmpty(sup_order_id)){
				policy.setOrder_zc_id(Long.parseLong(sup_order_id));
				insInsuranceSlipService.updateById(policy);
			}
		}
		if(policy.getInsTransaction()!=null && !policy.getInsTransaction().isEmpty()){//同步订单对应的所有交易记录
			for(InsTransaction tr : policy.getInsTransaction()){
				OrderSupportUtil.receiveTrancetionData(policy,tr);
			}
		}
	}
	
	/**
	 * <b>页面获取上传支付信息等插入到分销</b> 
	 * 
	 * @param path_url 支付凭证上传路径
	 * @param order_id 订单id
	 * @param path_sign 支付阶段标识
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.getInsOrderForm(Long.parseLong(order_id));
		if(insInsuranceSlip != null){
			insTransactionService.uploadPayMentFileToTranction(path_url, insInsuranceSlip, path_sign);
			return String.valueOf(insInsuranceSlip.getIns_insurance_slip_id());
		}
		return ConstProp.BLANK_CHAR;
	}

	/**
	 * <b>根据订单ID获取支付期标识</b> 
	 * 
	 * @param order_id 
	 * @author ZXF 
	 * @date 2016年12月28日 上午11:03:32
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String accordingToOrderIDGainPathSign(String order_id) {
		return insTransactionService.accordingToOrderIDGainPathSign(order_id);
	}
	
	/**
	 * <b>根据前台获取的买家列表查询相应安全等级再获取产品配的安全等级进行筛选只要跟产品存在的安全等级匹配就创建一条InsRiskDuty数据 </b> 
	 * 
	 * @param order_id
	 * @author ZXF 
	 * @date 2017年1月19日 上午11:03:47
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id){
		insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(order_id);
	}
	
	/**
	 * <b>生成投保单并保存 </b> 
	 * 
	 * @param order_id
	 * @author ZXF 
	 * @date 2017年1月19日 下午10:03:00
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToOrderIDCreatePolicySerialNumber(Long order_id){
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsOrderForm(order_id);
		insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
	}

	/**
	 * <b>根据订单id查询InsTransaction </b>
	 *
	 * @param order_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月10日 下午2:46:16
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsTransaction> accordingToOrderIDToGetInsTransaction(Long order_id){
		return insTransactionService.selectInsTransactionByInsOrderForm(order_id);
	}



	/****************************BUILD*******************************/



	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialBidVo getSpecialBidVoByOrderID(Long orderID){
		SpecialBidVo vo = new SpecialBidVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getBid_time())){
			vo.setBid_time(vo.getBid_time().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_1  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialPerformanceVo_1 getSpecialPerformanceVo_1ByOrderID(Long orderID){
		SpecialPerformanceVo_1 vo = new SpecialPerformanceVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_2  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialPerformanceVo_2 getSpecialPerformanceVo_2ByOrderID(Long orderID){
		SpecialPerformanceVo_2 vo = new SpecialPerformanceVo_2();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询履约特殊字段信息设置到SpecialPerformanceVo_3  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialPerformanceVo_3 getSpecialPerformanceVo_3ByOrderID(Long orderID) {
		SpecialPerformanceVo_3 vo = new SpecialPerformanceVo_3();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}


	/****************************LAWSUIT*******************************/


	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_1  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialLitigationVo_1 getSpecialLitigationVo_1ByOrderID(Long orderID){
		SpecialLitigationVo_1 vo = new SpecialLitigationVo_1();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}

	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_2  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialLitigationVo_2 getSpecialLitigationVo_2ByOrderID(Long orderID){
		SpecialLitigationVo_2 vo = new SpecialLitigationVo_2();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		MailPolicyVo voMP = new MailPolicyVo();
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		if(StringUtils.isNotEmpty(vo.getInception_date())){
			vo.setInception_date(vo.getInception_date().replace(ConstProp.DAY_00,""));
		}
		if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
			vo.setPlanned_end_date(vo.getPlanned_end_date().replace(ConstProp.DAY_23,""));
		}
		return vo;
	}

	/**
	 * <b>根据订单id查询诉讼特殊字段信息设置到SpecialLitigationVo_3  GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialLitigationVo_3 getSpecialLitigationVo_3ByOrderID(Long orderID) {
		SpecialLitigationVo_3 vo = new SpecialLitigationVo_3();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
		return vo;
	}


	/****************************GMR*******************************/

	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public GMRPolicyVo getGMRPolicyVoByOrderID(Long orderID){
		GMRPolicyVo vo = new GMRPolicyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
		vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		if(insInsuranceSlip.getSpecial_id() != null){
			SpecialExhibitionVo seVo = new SpecialExhibitionVo();
			specialExhibitionService.getSpecialExhibitionVoByPolicyID2(seVo, insInsuranceSlip.getSpecial_id());
			vo.setSpecialExhibitionVo(seVo);
		}
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************GZZRX*******************************/

	/**
	 * <b>根据订单id查询雇主责任险信息设置到SpecialHirelingVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public SpecialHirelingVo getSpecialHirelingVoByOrderID(Long orderID){
		SpecialHirelingVo vo = new SpecialHirelingVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setDispute(insInsuranceSlip.getDispute());
		vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
		vo.setPremium(String.valueOf(insInsuranceSlip.getPremium()));
		vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		hirelingService.getSpecialHirelingVoByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}


	/**
	 * <b> 如果有固化保障用固化保障，没有就取产品当前保障 (保单详情查询都得携带固化保障信息) </b>
	 * @author ZXF
	 * @create 2023/12/29 0029 16:13
	 * @version
	 * @注意事项 </b>
	 */
	private List<ResponsibilityVo> findResponsibilityVoList(String product_id,Long order_id) {
		InsAgreement insAgreement = insAgreementService.selectInsAgreementByInsInsuranceSlip(order_id);
		String responsibility_ids = "";
		if(insAgreement != null){
			responsibility_ids = insAgreement.getResponsibility_ids();
		}
		return insProductResponsibilityService.findResponsibilityVoListByResponsibilityIds(product_id,responsibility_ids);

	}

	/****************************AFR*******************************/

	/**
	 * <b>根据订单id查询公责险信息设置到SpecialPublicDutyVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public SpecialPublicDutyVo getSpecialPublicDutyVoByOrderID(Long orderID){
		SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
//		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
		vo.setMailPolicyVo(voMP);
		return vo;
	}

	/****************************ZZX*******************************/

	/**
	 * <b>根据订单id查询展责险信息设置到LOTEPolicyVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	public LOTEPolicyVo getLOTEPolicyVoByOrderID(Long orderID){
		LOTEPolicyVo vo = new LOTEPolicyVo();
		MailPolicyVo voMP = new MailPolicyVo();
		SpecialExhibitionVo seVo = new SpecialExhibitionVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
		}
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));

		vo.setResponsibilityVoList(findResponsibilityVoList(vo.getProduct_id(),orderID));

		specialExhibitionService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
		vo.setSpecialExhibitionVo(seVo);
		if(insInsuranceSlip.getMailPolicy() != null){
			InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
			insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
			vo.setMailPolicyVo(voMP);
		}
		return vo;
	}

	/****************************GMR*******************************/

	/**
	 * <b>根据订单id查询投标信息设置到SpecialBidVo   GET METHOD</b>
	 *
	 * @param orderID 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:49:03
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public GYXPolicyVo getGYXPolicyVoByOrderID(Long orderID){
		GYXPolicyVo vo = new GYXPolicyVo();
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.convertDateToString(insInsuranceSlip.getInception_date(),DateUtil.FORMAT2));
			vo.setPlanned_end_date(DateUtil.convertDateToString(insInsuranceSlip.getPlanned_end_date(),DateUtil.FORMAT2));
		}
		vo.setDispute(insInsuranceSlip.getDispute());
		vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
		vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
		vo.setRoleSubjectList(insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		return vo;
	}

	@Override
	public List<Map<String,String>> findPersonByTYX(Long orderID){
		return insRoleInpolicyDao.findPerson(orderID);
	}

	@Override
	public List<Map<String,String>> findPersonByGZZRX(Long orderID){
		return hirelingDao.findPerson(orderID);
	}

	/**
	 * <b> 订单复制，只有待支付才有此功能 </b>
	 * @author ZXF
	 * @create 2019/08/14 0014 11:33
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult copyPolicy(Long orderID){
		OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(orderID);
		if(orderVo == null || StringUtils.isEmpty(orderVo.getProduct_code())){
			return new AjaxResult(false, "订单不存在!");
		}
		if(ConstProp.XYX_DQCK.equals(orderVo.getProduct_code())){
			return new AjaxResult(false, "短期出口险不支持复制功能!");
		}
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		//订单编号
		Long tNumber = idWorker.nextId();
		//订单id
		Long pId = idWorker.nextId();
		//特殊字段id
		Long sId = idWorker.nextId();
		//发票id
		Long mId = idWorker.nextId();
		//公共
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.selectById(orderID);
		InsMailPolicy insMailPolicy = insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		Long oldSpecial_id = insInsuranceSlip.getSpecial_id();

		insMailPolicy.setIns_mail_policy_id(mId);
		insInsuranceSlip.setIns_insurance_slip_id(pId);
		insInsuranceSlip.setTrade_serial_number(String.valueOf(tNumber));
		insInsuranceSlip.setMailPolicy(insMailPolicy);
		insInsuranceSlip.setUnderwrite(null);
		insInsuranceSlip.setPolicy_serial_number(ConstProp.BLANK_CHAR);
		insInsuranceSlip.setSigned_date(new Date());
		insInsuranceSlip.setCreate_time(new Date());
		insInsuranceSlip.setStart_time(new Date());
		//投保中
		insInsuranceSlip.setOrder_status(DictConst.ORDER_STATUS_TBZ);

		Map<String,Object> columnMap = Maps.newHashMap();
		columnMap.put("insurance_slip_id", orderID);
		List<InsRoleInpolicy> roleList = insRoleInpolicyService.selectByMap(columnMap);
		for(InsRoleInpolicy role : roleList){
			role.setIns_role_inpolicy_id(idWorker.nextId());
			role.setInsurance_slip(insInsuranceSlip);
		}
		insMailPolicyService.insert(insMailPolicy);
		insRoleInpolicyService.insertBatch(roleList);
		if(orderVo.getProduct_code().contains(ConstProp.GZZRX)){
			//雇主
			columnMap = Maps.newHashMap();
			columnMap.put("ins_insurance_slip_id", orderID);
			List<Hireling> hirelingList = hirelingService.selectByMap(columnMap);
			for(Hireling hireling : hirelingList){
				hireling.setHireling_id(idWorker.nextId());
				hireling.setIns_insurance_slip_id(pId);
			}
			hirelingService.insertBatch(hirelingList);
		}else if(orderVo.getProduct_code().contains(ConstProp.ZZX)){
			insInsuranceSlip.setSpecial_id(sId);
			//展责
			SpecialExhibition specialExhibition = specialExhibitionService.selectById(oldSpecial_id);
			specialExhibition.setSpecial_exhibition_id(sId);
			specialExhibitionService.insert(specialExhibition);
		}else if(orderVo.getProduct_code().contains(ConstProp.GZX)){
			insInsuranceSlip.setSpecial_id(sId);
			//公责
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.selectById(oldSpecial_id);
			specialPublicDuty.setSpecial_public_duty_id(sId);
			specialPublicDutyService.insert(specialPublicDuty);
		}else if(orderVo.getProduct_code().contains(ConstProp.GCLY)){
			insInsuranceSlip.setSpecial_id(sId);
			//履约
			SpecialPerformance insSpecialPerformance = insSpecialPerformanceService.selectById(oldSpecial_id);
			insSpecialPerformance.setSpecial_performance_id(sId);
			insSpecialPerformanceService.insert(insSpecialPerformance);
		}else if(orderVo.getProduct_code().contains(ConstProp.GCTB)){
			insInsuranceSlip.setSpecial_id(sId);
			//投标
			SpecialBid insSpecialBid = insSpecialBidService.selectById(oldSpecial_id);
			insSpecialBid.setSpecial_bid_id(sId);
			insSpecialBidService.insert(insSpecialBid);
		}else if(orderVo.getProduct_code().contains(ConstProp.XYX_XWCK)){
			insInsuranceSlip.setSpecial_id(sId);
			//小微
			SpecialCreditMicro insMicroExport = insMicroExportService.selectById(oldSpecial_id);
			insMicroExport.setSpecial_credit_micro_id(sId);
			insMicroExportService.insert(insMicroExport);
		}else if(orderVo.getProduct_code().contains(ConstProp.BZX_SSBQ)){
			insInsuranceSlip.setSpecial_id(sId);
			//诉讼
			SpecialLitigation specialLitigation = specialLitigationService.selectById(oldSpecial_id);
			columnMap = Maps.newHashMap();
			columnMap.put("special_litigation_id", specialLitigation.getSpecial_litigation_id());
			List<LnAccused> lnAccusedList = lnAccusedService.selectByMap(columnMap);
			specialLitigation.setSpecial_litigation_id(sId);
			for(LnAccused lnAccused : lnAccusedList){
				lnAccused.setLn_accused_id(idWorker.nextId());
				lnAccused.setSpecial_litigation(specialLitigation);
			}
			specialLitigationService.insert(specialLitigation);
			lnAccusedService.insertBatch(lnAccusedList);
		}
		insInsuranceSlipService.insert(insInsuranceSlip);
		return new AjaxResult(true, "订单复制成功!订单编号："+tNumber);
	}

	/**
	 * <b> 保单退保 </b>
	 * @author ZXF
	 * @create 2020/01/10 0010 10:14
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public AjaxResult surrender(SurrenderVo surrenderVo, HttpServletRequest request){
		OrderFormVo orderVo = accordingToOrderIDToGetOrderFormVo(Long.parseLong(surrenderVo.getOid()));
		if(orderVo == null){
			return new AjaxResult(false, "订单不符合退保条件!");
		}
		//状态=4时，直接改订单为废弃
		if(ConstProp.DIGIT_FOUR.equals(orderVo.getPolicy_status())){
			//1.订单状态设置成13（废弃）
			OrderFormVo vo = new OrderFormVo();
			vo.setOid(orderVo.getOid());
			vo.setPolicy_status(ConstProp.DIGIT_THIRTEEN);
			updateOrderFormStatus(vo);
			return new AjaxResult(true, "退保操作成功!");
		}
		if(StringUtils.isEmpty(surrenderVo.getInception_date())||StringUtils.isEmpty(surrenderVo.getPremium())){
			return new AjaxResult(false, "必要参数不能为空!");
		}
		//状态=6/13时只支持雇主或团险的订单
		if((orderVo.getProduct_code().contains(ConstProp.TYX)||orderVo.getProduct_code().contains(ConstProp.GZZRX))
				&&(ConstProp.DIGIT_SIX.equals(orderVo.getPolicy_status())||ConstProp.DIGIT_SIXTEEN.equals(orderVo.getPolicy_status()))){
			//1.订单状态设置成13（废弃）
			OrderFormVo vo = new OrderFormVo();
			vo.setOid(orderVo.getOid());
			vo.setPolicy_status(ConstProp.DIGIT_THIRTEEN);
			updateOrderFormStatus(vo);
			//2.退保操作时删除保全相关数据包括在保人员
//			preseverApplyService.deletePresever(Long.parseLong(orderVo.getOid()));
			preseverApplyService.saveSurrenderRecord(surrenderVo,orderVo,request);
			if(!"BLB".equals(orderVo.getWeb_type())){
				//3.请求第三方查找对应保单号的保单标记删除，清楚该保单已关联的在保人员记录
				comTaskResidualService.saveComTaskResidual("deletePolicyPush","请求第三方废弃保单","com.bcxin.ins.service.order.PolicyService",1,"String",orderVo.getOid());
			}
			return new AjaxResult(true, "退保操作成功!");
		}
		return new AjaxResult(false, "订单不符合退保条件!");
	}
}
