package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StRecentYearsSell;
import com.bcxin.ins.models.order.policy.dao.InsRecentYearsSellDao;
import com.bcxin.ins.models.order.policy.service.InsRecentYearsSellService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.RecentYearsSellVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsRecentYearsSellServiceImpl extends ServiceImpl<InsRecentYearsSellDao, StRecentYearsSell> implements InsRecentYearsSellService {

	@Autowired
	private InsRecentYearsSellDao dao;
	/**
	 * <b>通过销售额id查询所有最近三年销售记录 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:07:40
	 * @注意事项 </b>
	 * <b>
	 */
	public List<StRecentYearsSell> selectInsRecentYearsSellByTurnover(Long oid){
		return dao.selectInsRecentYearsSellByTurnover(oid);
	}
	
	/**
	 * <b>接收页面传回的最近三年销售记录交互辅助类信息列表进行更新 </b> 
	 * 
	 * @param voList 最近三年销售记录交互辅助类信息列表
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setRecentYearsSellByRecentYearsSellVo(List<RecentYearsSellVo> voList, Long turnover_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			for(RecentYearsSellVo vo : voList){
				accordingToTheRecentYearsSellVoSetUpInsRecentYearsSell(vo,turnover_id);
			}
		}
	}
	
	/**
	 * <b>根据Vo及销售额表ID更新InsRecentYearsSell数据 </b> 
	 * 
	 * @param vo
	 * @param turnover_id 销售额表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheRecentYearsSellVoSetUpInsRecentYearsSell(RecentYearsSellVo vo,Long turnover_id){
		StRecentYearsSell insRecentYearsSell = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insRecentYearsSell = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insRecentYearsSell = new StRecentYearsSell();
			insRecentYearsSell.getSt_turnover().setSt_turnover_id(turnover_id);
			dao.insert(insRecentYearsSell);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insRecentYearsSell);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insRecentYearsSell);
	}
	
	/**
	 * <b>根据List<InsRecentYearsSell>封装到 List<RecentYearsSellVo>中</b> 
	 * 
	 * @param iryList
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:18:47
	 * @注意事项 </b>
	 * <b>
	 */
	public List<RecentYearsSellVo> packagingRecentYearsSellVoListByInsRecentYearsSellList(List<StRecentYearsSell> iryList){
		List<RecentYearsSellVo> voList = new ArrayList<RecentYearsSellVo>();
		for(StRecentYearsSell iry : iryList){
			voList.add(accordingToInsRecentYearsSellIntoRecentYearsSellVo(iry));
		}
		return voList;
	}
	
	/**
	 * <b>根据最近三年销售记录表信息转换成 RecentYearsSellVo </b> 
	 * 
	 * @param insRecentYearsSell
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	public RecentYearsSellVo accordingToInsRecentYearsSellIntoRecentYearsSellVo(StRecentYearsSell insRecentYearsSell){
		RecentYearsSellVo vo = new RecentYearsSellVo();
		vo.setOid(String.valueOf(insRecentYearsSell.getSt_recent_years_sell_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insRecentYearsSell), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
}
