package com.bcxin.ins.models.order.policy.service.impl;


import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.models.order.policy.dao.InsMicroExportDao;
import com.bcxin.ins.models.order.policy.service.InsMicroExportService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



/**
 * <b>小微企业特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsMicroExportServiceImpl extends ServiceImpl<InsMicroExportDao, SpecialCreditMicro> implements InsMicroExportService {

	@Autowired
	private InsMicroExportDao dao;

	public SpecialCreditMicro initInsMicroExport(){
		SpecialCreditMicro insMicroExport = new SpecialCreditMicro();//
		dao.insert(insMicroExport);
		return insMicroExport;
	}
	
	/**
	 * <b>根据Vo及小微出口ID更新InsMicroExport数据 </b> 
	 * 
	 * @param vo
	 * @param microID 小微出口id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheMicroExportVoSetUpInsMicroExport(MicroExportVo vo, Long microID){
		SpecialCreditMicro insMicroExport = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insMicroExport);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insMicroExport);
	}
	
	/**
	 * <b>获取MicroExportVo根据小微出口id查询小微出口信息插入到MicroExportVo </b> 
	 * 
	 * @param vo 小微出口辅助表
	 * @param microID 小微出口id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getMicroExportVoByPolicyID(MicroExportVo vo, Long microID){
		SpecialCreditMicro insMicroExport = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insMicroExport), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
