package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.models.order.policy.dao.InsMailPolicyDao;
import com.bcxin.ins.models.order.policy.service.InsMailPolicyService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



@Service
@Transactional
public class InsMailPolicyServiceImpl extends ServiceImpl<InsMailPolicyDao, InsMailPolicy> implements InsMailPolicyService {


	@Autowired
	private InsMailPolicyDao dao;

	@Override
	public InsMailPolicy initInsMailPolicy() {
		InsMailPolicy insMailPolicy = new InsMailPolicy();
		dao.insert(insMailPolicy);
		return insMailPolicy;
	}
	
	/**
	 * <b>根据Vo及保单配送表ID更新InsMailPolicy数据 </b> 
	 * 
	 * @param vo
	 * @param insMailPolicyID 保单配送表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheMailPolicyVoSetUpInsMailPolicy(MailPolicyVo vo, Long insMailPolicyID){
		InsMailPolicy insMailPolicy = dao.selectById(insMailPolicyID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insMailPolicy);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insMailPolicy);
	}

	/**
	 * <b>根据保单配送表信息转换成 MailPolicyVo </b> 
	 * 
	 * @param insMailPolicy
	 * @param vo
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToInsMailPolicyIntoMailPolicyVo(MailPolicyVo vo, InsMailPolicy insMailPolicy){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insMailPolicy), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * <b>通过InsInsuranceSlipg获取InsMailPolicy设置到InsInsuranceSlipg </b> 
	 * through the InsInsuranceSlipg for InsMailPolicy set up InsInsuranceSlipg
	 * @param iis
	 * @return
	 * @author ZXF 
	 * @date 2017年1月7日 上午11:01:19
	 * @注意事项 </b>
	 * <b>
	 */
	public void throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(InsInsuranceSlip iis){
		if(iis.getMailPolicy() != null){
			iis.setMailPolicy(dao.selectById(iis.getMailPolicy().getIns_mail_policy_id()));
		}
	}

	public void dbSave(InsMailPolicy insMailPolicy){
		dao.insert(insMailPolicy);
	}

	/**
	 * <b> 根据订单id查询发票信息 </b>
	 * @author ZXF
	 * @create 2019/12/16 0016 16:09
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsMailPolicy getInsMailPolicyByOrderId(Long order_id){
		return dao.getInsMailPolicyByOrderId(order_id);
	}
}
