package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.entity.policy_special.*;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.models.order.policy.dao.InsInsuranceSlipDao;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.toolbox.DateUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.excel.PolicyExcelVo;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.xiaoleilu.hutool.thread.ThreadUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * <b>投保单子表业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsInsuranceSlipServiceImpl extends ServiceImpl<InsInsuranceSlipDao, InsInsuranceSlip> implements InsInsuranceSlipService {

	private Logger log =  LoggerFactory.getLogger(InsInsuranceSlipServiceImpl.class);

	@Autowired
	private InsCommonExportService insCommonExportService;
	
	@Autowired
	private InsMicroExportService insMicroExportService;
	
	@Autowired
	private InsRoleInpolicyService insRoleInpolicyService;
	
	@Autowired
	private InsProductService insProductService;
	
	@Autowired
	private InsUnderwriteService insUnderwriteService;
	
	@Autowired
	private InsMailPolicyService insMailPolicyService;

	@Autowired
	private InsProductResponsibilityService insProductResponsibilityService;

	@Autowired
	private InsInsuranceSlipDao dao;

	@Autowired
	private InsTransactionService insTransactionService;
	@Autowired
	private ComDeployConfigService configService;

	@Autowired
	private InsAgreementService insAgreementService;

	@Autowired
	private InsRiskDutyService insRiskDutyService;

	@Autowired
	private SysUserService sysUserService;
	@Autowired
	private SpecialLitigationService specialLitigationService;
	@Autowired
	private SpecialBidService specialBidService;
	@Autowired
	private SpecialPerformanceService specialPerformanceService;
	@Autowired
	private SpecialPublicDutyService specialPublicDutyService;

	/**
	 * <b>投保单子表绑定主表，如果主表为空那么方法强制返回null </b> 
	 * getInsInsuranceSlipgExtendsParent
	 * @param oid 投保单id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip selectById(Long oid){
		InsInsuranceSlip insInsuranceSlip = dao.selectById(oid);
		if(insInsuranceSlip != null){
			insMailPolicyService.throughTheInsInsuranceSlipForInsMailPolicySetUpInsInsuranceSlip(insInsuranceSlip);
			insUnderwriteService.throughTheInsInsuranceSlipForInsUnderwriteSetUpInsInsuranceSlip(insInsuranceSlip);
			insInsuranceSlip.setInsTransaction(insTransactionService.selectInsTransactionByInsOrderForm(insInsuranceSlip.getIns_insurance_slip_id()));
		}
		return insInsuranceSlip;
	}
	
	/**
	 * <b>根据投保单id查询投保单信息，然后根据类型判断查询特殊字段相关信息封装到投保单中 </b> 
	 * 
	 * @param oid 投保单id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip packagingInsInsuranceSlip(Long oid){
		InsInsuranceSlip insInsuranceSlip = selectById(oid);
		if(insInsuranceSlip == null){
			return insInsuranceSlip;
		}
		insInsuranceSlip.setRoles(insRoleInpolicyService.selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id()));
		ProPrimary insProduct = insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
		insInsuranceSlip.setPro_primary(insProduct);
		if(StringUtils.isEmpty(insProduct.getProduct_code())){
			return insInsuranceSlip;
		}
		if(ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro insMicroExport = insMicroExportService.selectById(insInsuranceSlip.getSpecial_id());
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insMicroExport);
			insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
		}else if(ConstProp.XYX_DQCK.equals(insProduct.getProduct_code())){
			SpecialCreditSt insCommonExport = insCommonExportService.getInsCommonExportBusiness(insInsuranceSlip.getSpecial_id());
			if (insCommonExport != null && insCommonExport.getSpecial_credit_st_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), insCommonExport);
				insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
			}
		}else if(ConstProp.BZX_TB_GCTB.equals(insProduct.getProduct_code())){
			SpecialBid specialBid = specialBidService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
				insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
			}
		}else if(ConstProp.BZX_YG_GCTB.equals(insProduct.getProduct_code())){
			SpecialBid specialBid = specialBidService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialBid != null && specialBid.getSpecial_bid_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialBid);
				insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
			}
		}
		else if(ConstProp.BZX_GCLY.equals(insProduct.getProduct_code())){
			SpecialPerformance specialPerformance = specialPerformanceService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialPerformance != null && specialPerformance.getSpecial_performance_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPerformance);
				insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
			}
		}else if(ConstProp.BZX_SSBQ.equals(insProduct.getProduct_code())){
			SpecialLitigation specialLitigation = specialLitigationService.getSpecialLitigationBusiness(insInsuranceSlip.getSpecial_id());
			if (specialLitigation != null && specialLitigation.getSpecial_litigation_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialLitigation);
				insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
			}
		}else if(ConstProp.GZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.selectById(insInsuranceSlip.getSpecial_id());
			if (specialPublicDuty != null && specialPublicDuty.getSpecial_public_duty_id() != null) {
				insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()), specialPublicDuty);
				insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
			}
		}
		return insInsuranceSlip;
	}

	/**
	 * <b>投保单初始化，联级表初始化创建new InsInsuranceSlipg() </b> 
	 * 
	 * @param poductID 产品id
	 * @param user_id 用户id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip initOrderForm(Long poductID,Long user_id){
		InsInsuranceSlip insInsuranceSlip = new InsInsuranceSlip();
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		insInsuranceSlip.setTrade_serial_number(String.valueOf(idWorker.nextId()));
		insInsuranceSlip.setStart_time(DateUtil.getTimestamp());
		insInsuranceSlip.setRegister_user_id(user_id);
		insInsuranceSlip.setUnderwrite(insUnderwriteService.initInsUnderwrite());
		insInsuranceSlip.setMailPolicy(insMailPolicyService.initInsMailPolicy());
		ProPrimary insProduct = insProductService.selectById(poductID);
		insInsuranceSlip.setPro_primary(insProduct);
		if(StringUtils.isEmpty(insProduct.getProduct_code())){
			dao.insert(insInsuranceSlip);
			return insInsuranceSlip;
		}
		if(ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro insMicroExport = insMicroExportService.initInsMicroExport();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insMicroExport);
			insInsuranceSlip.setSpecial_id(insMicroExport.getSpecial_credit_micro_id());
		}else if(ConstProp.XYX_DQCK.equals(insProduct.getProduct_code())){
			SpecialCreditSt insCommonExport = insCommonExportService.initInsCommonExport();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),insCommonExport);
			insInsuranceSlip.setSpecial_id(insCommonExport.getSpecial_credit_st_id());
		}else if(ConstProp.BZX_TB_GCTB.equals(insProduct.getProduct_code())){
			SpecialBid specialBid = specialBidService.initInsSpecialBid();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialBid);
			insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
		}else if(ConstProp.BZX_YG_GCTB.equals(insProduct.getProduct_code())){
			SpecialBid specialBid = specialBidService.initInsSpecialBid();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialBid);
			insInsuranceSlip.setSpecial_id(specialBid.getSpecial_bid_id());
		}
		else if(ConstProp.BZX_GCLY.equals(insProduct.getProduct_code())){
			SpecialPerformance specialPerformance = specialPerformanceService.initInsSpecialPerformance();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialPerformance);
			insInsuranceSlip.setSpecial_id(specialPerformance.getSpecial_performance_id());
		}else if(ConstProp.BZX_SSBQ.equals(insProduct.getProduct_code())){
			SpecialLitigation specialLitigation = specialLitigationService.initSpecialLitigation();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialLitigation);
			insInsuranceSlip.setSpecial_id(specialLitigation.getSpecial_litigation_id());
		}else if(ConstProp.GZX.equals(insProduct.getProduct_code().split(ConstProp.MINUS)[0])){
			SpecialPublicDuty specialPublicDuty = specialPublicDutyService.initSpecialPublicDuty();
			insInsuranceSlip.getMapSpecial().put(String.valueOf(insProduct.getPro_primary_id()),specialPublicDuty);
			insInsuranceSlip.setSpecial_id(specialPublicDuty.getSpecial_public_duty_id());
		}
		dao.insert(insInsuranceSlip);
		return insInsuranceSlip;
	}
	

	/**
	 * <b>将投保单转换成 InsurePolicyVo</b> 
	 * 
	 * @param insInsuranceSlip_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月14日 上午11:28:46
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsurePolicyVo willInsInsuranceSlipChangeIntoInsurePolicyVo(Long insInsuranceSlip_id){
		InsurePolicyVo vo = new InsurePolicyVo();
		InsInsuranceSlip insInsuranceSlip = packagingInsInsuranceSlip(insInsuranceSlip_id);
		if(insInsuranceSlip == null){
			return vo;
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setMailPolicy_id(String.valueOf(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id()));
		if(insInsuranceSlip.getUnderwrite() != null){
			vo.setUnderwrite_id(String.valueOf(insInsuranceSlip.getUnderwrite().getUnderwrite_id()));
		}
		vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		return vo;
	}

	/**
	 * <b>设置保险金额度到投保单父表 </b>
	 *
	 * @param insuredAmount
	 * @param iis
	 * @author ZXF
	 * @date 2017年1月18日 下午5:37:43
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsuredAmountSetToInsInsuranceSlip(BigDecimal insuredAmount, InsInsuranceSlip iis){
		iis.setInsured_amount(insuredAmount);
		dao.updateById(iis);
	}

	/**
	 * <b>生成投保单 </b>
	 *
	 * @param insInsuranceSlip
	 * @author ZXF
	 * @date 2017年1月19日 下午10:10:01
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToOrderIDCreatePolicySerialNumber(InsInsuranceSlip insInsuranceSlip){
		IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
		insInsuranceSlip.setPolicy_serial_number("BCX-"+String.valueOf(idWorker.nextId())+"A");
		dao.updateById(insInsuranceSlip);
	}

	@Override
	public void dbSave(InsInsuranceSlip insInsuranceSlip){
		dao.insert(insInsuranceSlip);
	}








	/**
	 * <b>根据订单id查询订单信息及交易详情 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:41:34
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip getInsOrderForm(Long oid){
		InsInsuranceSlip insInsuranceSlip = selectById(oid);
		if(insInsuranceSlip != null){
			ProPrimary insProduct = insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
			insInsuranceSlip.setPro_primary(insProduct);
		}
		return insInsuranceSlip;
	}

	/**
	 * <b>根据订单交易流水号查询订单信息及交易详情 </b>
	 *
	 * @param tradeSerialNumber
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:41:34
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip getInsOrderForm(String tradeSerialNumber){
		InsInsuranceSlip insOrderForm = dao.selectByTradeSerialNumber(tradeSerialNumber);
		if(insOrderForm != null){
			insOrderForm.setInsTransaction(insTransactionService.selectInsTransactionByInsOrderForm(insOrderForm.getIns_insurance_slip_id()));
		}
		return insOrderForm;
	}

	/**
	 * <b>根据订单id查询并封装交易详情及投保单信息 </b>
	 *
	 * @param oid
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午1:42:10
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public InsInsuranceSlip packagingInsOrderForm(Long oid){
		return packagingInsInsuranceSlip(oid);
	}

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b>
	 *
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Long user_id, String status, DwzPage page){
		Page<InsInsuranceSlip> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
		List<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
		List<InsInsuranceSlip> insOrderFormList = dao.selectInsOrderFormByUserIDAndStatus(pageHelper,user_id, status);
		for(InsInsuranceSlip order : insOrderFormList){
			list.add(packagingInsOrderForm(order.getIns_insurance_slip_id()));
		}
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

	/**
	 * <b>根据前台用户id跟订单状态列表查询订单并进行分页 </b>
	 *
	 * @param user_id
	 * @param statusList
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Long user_id, List<String> statusList, DwzPage page){
		Page<InsInsuranceSlip> pageHelper = new Page(page.getPageNum(), page.getNumPerPage());
		List<InsInsuranceSlip> list = new ArrayList<InsInsuranceSlip>();
		List<InsInsuranceSlip> insOrderFormList = dao.selectInsOrderFormByUserIDAndStatusList(pageHelper,user_id, statusList);
		for(InsInsuranceSlip order : insOrderFormList){
			list.add(packagingInsOrderForm(order.getIns_insurance_slip_id()));
		}
		page.setTotalCount(new Long(pageHelper.getTotal()).intValue());
		return list;
	}

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页封装到OrderFormVo </b>
	 *
	 * @param user_id
	 * @param status
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page){
		List<OrderFormVo> voList = new ArrayList<OrderFormVo>();
		List<InsInsuranceSlip> orderList = selectInsOrderFormByUserIDAndStatus(user_id, status, page);
		for(InsInsuranceSlip order : orderList){
			voList.add(willInsOrderFormSetUpOrderFormVo(order));
		}
		return voList;
	}

	@Override
	public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusListSetUpOrderFormVo(Long user_id, List<String> statusList, DwzPage page) {
		List<OrderFormVo> voList = new ArrayList<OrderFormVo>();
		List<InsInsuranceSlip> orderList = selectInsOrderFormByUserIDAndStatusList(user_id, statusList, page);
		for(InsInsuranceSlip insInsuranceSlip : orderList){
			voList.add(willInsOrderFormSetUpOrderFormVo(insInsuranceSlip));
		}
		return voList;
	}

	/**
	 * <b>将 InsOrderForm 封装到 OrderFormVo</b>
	 *
	 * @param insInsuranceSlip
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo willInsOrderFormSetUpOrderFormVo(InsInsuranceSlip insInsuranceSlip){
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
		SysUser user = sysUserService.selectById(insInsuranceSlip.getRegister_user_id());
		if(user != null){
			vo.setLogin_name(user.getLoginName());
		}
		if(insInsuranceSlip.getStart_time() != null){
			vo.setStart_time(DateUtil.formatDate(insInsuranceSlip.getStart_time()));
		}
		if(!DictConst.ORDER_STATUS_TBZ.equals(insInsuranceSlip.getOrder_status())
				&& !DictConst.ORDER_STATUS_DSH.equals(insInsuranceSlip.getOrder_status())
				&& !DictConst.ORDER_STATUS_YSH.equals(insInsuranceSlip.getOrder_status())){
			InsAgreement insAgreement = insAgreementService.selectInsAgreementByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
			vo.setExternal_reference(insAgreement != null?insAgreement.getExternal_reference():ConstProp.BLANK_CHAR);
		}
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
			vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
		}
		if(insInsuranceSlip.getPro_primary() != null){
			vo.setProduct_oid(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
		}
		if(insInsuranceSlip.getInception_date() != null){
			vo.setInception_date(DateUtil.formatDate(insInsuranceSlip.getInception_date()));
		}
		if(insInsuranceSlip.getPlanned_end_date() != null){
			vo.setPlanned_end_date(DateUtil.formatDate(insInsuranceSlip.getPlanned_end_date()));
		}
		if(StrUtil.isNotBlank(insInsuranceSlip.getPolicy_serial_number())){
			vo.setPolicy_serial_number(insInsuranceSlip.getPolicy_serial_number());
		}
		if(StrUtil.isNotBlank(insInsuranceSlip.getOrder_status())){
			vo.setPolicy_status(insInsuranceSlip.getOrder_status());
		}
		insProductService.accordingToProductIDToGetInsProductSetUpOrderFormVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());

		insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
		if(insInsuranceSlip.getStart_time() != null){
			vo.setStart_time(DateUtil.formatDateTime(insInsuranceSlip.getStart_time()));
		}
		List<InsRoleInpolicy> applicantRoles = insInsuranceSlip.getRolesOfKind(ConstProp.DIGIT_ONE);
		if(applicantRoles != null){
			vo.setApplicant_name(applicantRoles.get(0).getName_cn());
		}
		List<InsRoleInpolicy> insurenceRoles = insInsuranceSlip.getRolesOfKind(ConstProp.DIGIT_TWO);
		if(insurenceRoles != null){
			vo.setInsured_role(insurenceRoles.get(0).getName_cn());
			vo.setBusiness_scope(insurenceRoles.get(0).getBusiness_nature());
			vo.setPolicy_currency(SysDictUtils.getDictLabel(insurenceRoles.get(0).getCurrency_required(), "currencyRequired", ConstProp.BLANK_CHAR));
		}
		ProPrimary insProduct = insProductService.selectById(insInsuranceSlip.getPro_primary().getPro_primary_id());
		if(insProduct != null && ConstProp.XYX_XWCK.equals(insProduct.getProduct_code())){
			SpecialCreditMicro micro = (SpecialCreditMicro) insInsuranceSlip.getMapSpecial().get(String.valueOf(insProduct.getPro_primary_id()));
			vo.setPolicy_currency(SysDictUtils.getDictLabel(micro.getAnnual_currency(), "annualCurrency", ConstProp.BLANK_CHAR));
		}
		return vo;
	}

	/**
	 * <b>将 InsOrderForm 封装到 AdviceNoteVo</b>
	 *
	 * @param insInsuranceSlip
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public AdviceNoteVo willInsOrderFormSetUpAdviceNoteVo(InsInsuranceSlip insInsuranceSlip){
		AdviceNoteVo vo = new AdviceNoteVo();
		vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
		InsUnderwrite underwrite = insInsuranceSlip.getUnderwrite();
		if(underwrite != null){
			vo.setTotal_rate(String.valueOf(underwrite.getTotal_rate()));
			vo.setYear_premium(String.valueOf(underwrite.getYear_premium()));
			vo.setInitial_premium(String.valueOf(underwrite.getInitial_premium()));
		}
		if(insInsuranceSlip.getPremium() != null){
			vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
		}
		insProductService.accordingToProductIDToGetInsProductSetUpAdviceNoteVo(vo, insInsuranceSlip.getPro_primary().getPro_primary_id());
		return vo;
	}

	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b>
	 *
	 * @param user_id
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id) {
		return dao.selectOrderStatusCountVoByUserID(user_id);
	}

	/**
	 * <b>修改订单状态 </b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public String updateOrderFormStatus(OrderFormVo vo){
		InsInsuranceSlip insInsuranceSlip = dao.selectById(Long.parseLong(vo.getOid()));
		insInsuranceSlip.setOrder_status(vo.getPolicy_status());
		dao.updateById(insInsuranceSlip);
		if(DictConst.ORDER_STATUS_YCB.equals(vo.getPolicy_status())){
			//判断是否发送纸质保单、纸质发票的邮件通知
			ThreadUtil.excAsync(()->{
				sendZZPolicyEmail(vo.getOid());
			},false);
		}
		return insInsuranceSlip.getIns_insurance_slip_id().toString();
	}

	/**
	 * <b> 判断是否发送纸质保单、纸质发票的邮件通知 </b>
	 * @author ZXF
	 * @create 2019/12/16 0016 15:55
	 * @version
	 * @注意事项 </b>
	 */
	public void sendZZPolicyEmail(String order_id){
		ThreadUtil.sleep(2*60*1000);
		InsMailPolicy insMailPolicy = insMailPolicyService.getInsMailPolicyByOrderId(Long.parseLong(order_id));
		if(insMailPolicy == null){
			return;
		}
		OrderFormVo vo = findOrderFormVoByID(Long.parseLong(order_id));
		String content = htmlContentByZZPolicyEmail(vo,insMailPolicy);
		if(StringUtils.isNotEmpty(content)){
			String pcode = StringUtils.isNotEmpty(vo.getProduct_code())&&vo.getProduct_code().contains("PAC")?vo.getProduct_code():"";
			sendZZMsgEmail(pcode,content);
		}
	}

	public void sendZZMsgEmail(String product_code,String htmlContent ) {
		log.info("寄送邮件发送（内容htmlContent）:"+htmlContent);
		//exmail格式：123@qq.com;333@qq.com:GZZRX-RB;413@qq.com:GZZRX-ZH
		String[] arrs = configService.getValueByKey("TBFP_EMAIL").split(ConstProp.SEMICOLON);
		EmailModel emailModel = new EmailModel("保单、发票寄送通知", htmlContent);
		List<String> emailList = new ArrayList<String>();
		String em = ConstProp.BLANK_CHAR;
		for(int i=0;i<arrs.length;i++){
			if(StringUtils.isEmpty(arrs[i])){
				continue;
			}
			if(!arrs[i].contains(ConstProp.COLON)){
				em = arrs[i].trim();
				emailList.add(em); // 发送地址
				log.info("寄送邮件发送（收件人Email-"+(i+1)+"）:"+em);
				continue;
			}
			//邮箱加产品代码 3804@qq.com:GZZRX-ZH
			String[] sigs = arrs[i].split(ConstProp.COLON);
			if(StringUtils.isNotEmpty(product_code) && product_code.contains(sigs[1])){
				em = sigs[0].trim();
				emailList.add(em); // 发送地址
				log.info("寄送邮件发送（收件人Email-"+(i+1)+"）:"+em);
			}
		}
		if(emailList.size()>0){
			emailModel.setTo(emailList);
			SendEmailAndMsgUtil.sendEmail(emailModel);
		}
	}

	private String htmlContentByZZPolicyEmail(OrderFormVo orderVo,InsMailPolicy insMailPolicy){
		StringBuffer htmlContent= new StringBuffer();
		try {
			if(orderVo == null){
				return ConstProp.BLANK_CHAR;
			}
			if(insMailPolicy.getNeed_insur_bill() == 0 && insMailPolicy.getNeed_receipt() == 0){
				return ConstProp.BLANK_CHAR;
			}
			htmlContent.append("<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"UTF-8\"><title>纸质保单、发票寄送信息</title><style type=\"text/css\">.wrap{width:500px;margin:30px auto}.wrap h1{text-align:center}.shenqing-con p strong,.shenqing-con p span{display:block;font-size:14px;line-height:24px}.shenqing-con p strong{float:left;margin-right:8px}.shenqing-con div{float:left}.shenqing-con p.mg-r{width:200px;margin-left:78px}table{width:680px}table th,table td{padding:5px}</style></head><body><div class=\"wrap\"><h1>纸质保单、发票寄送信息</h1><div class=\"shenqing-con\">");
			htmlContent.append("<p><strong>订单号：</strong><span>"+orderVo.getTrade_serial_number()+"</span></p>");
			htmlContent.append("<p><strong>保险公司：</strong><span>"+orderVo.getInsurance_name()+"</span></p>" +
					"<p><strong>保单号：</strong><span>"+orderVo.getExternal_reference()+"</span></p>" +
					"<p><strong>投保时间：</strong><span>"+orderVo.getStart_time()+"</span></p>" +
					"<p><strong>投保人：</strong><span>"+orderVo.getApplicant_name()+"</span></p>" +
					"<p><strong>保险产品：</strong><span>[产品名称："+orderVo.getProduct_name()+"]</span></p>");
			if(insMailPolicy.getNeed_insur_bill() == 1){
				htmlContent.append("<h2>纸质保单寄送信息：</h2>");
				htmlContent.append("<p><strong>收件人名称：</strong><span>"+insMailPolicy.getReceiver_name()+"</span></p>");
				htmlContent.append("<p><strong>收件人手机：</strong><span>"+insMailPolicy.getReceiver_mobile()+"</span></p>");
				htmlContent.append("<p><strong>收件人地址：</strong><span>"+insMailPolicy.getReceiver_address_detail()+"</span></p>");
			}
			if(insMailPolicy.getNeed_receipt() == 1){
				boolean isInv = ConstProp.DIGIT_ONE.equals(insMailPolicy.getInvoice_type());
				String inv = isInv?"增值税专用发票":"增值税普通发票";
				htmlContent.append("<h2>纸质"+inv+"寄送信息：</h2>");
				htmlContent.append("<p><strong>单位名称：</strong><span>"+insMailPolicy.getReceipt_head()+"</span></p>");
				htmlContent.append("<p><strong>纳税人识别号：</strong><span>"+insMailPolicy.getTaxpayer_number_invoice()+"</span></p>");
				htmlContent.append("<p><strong>收票人姓名：</strong><span>"+insMailPolicy.getTaker_name()+"</span></p>");
				htmlContent.append("<p><strong>收票人手机：</strong><span>"+insMailPolicy.getTaker_mobile()+"</span></p>");
				htmlContent.append("<p><strong>收票人地址：</strong><span>"+insMailPolicy.getTaker_address_detail()+"</span></p>");
				if(isInv){
					htmlContent.append("<p><strong>开户银行：</strong><span>"+insMailPolicy.getBank_invoice()+"</span></p>");
					htmlContent.append("<p><strong>银行账号：</strong><span>"+insMailPolicy.getBank_account_invoice()+"</span></p>");
					htmlContent.append("<p><strong>开户地址：</strong><span>"+RegionUtils.getRegionNameByALLCode(insMailPolicy.getBank_province(),insMailPolicy.getBank_city(),ConstProp.BLANK_CHAR)+"</span></p>");
				}
			}
			htmlContent.append("</div></div></body></html>");

		} catch (Exception e) {
			log.error("纸质保单、发票待寄送通知内容组装异常：",e);
			e.printStackTrace();
		}
		return htmlContent.toString();
	}

	@Override
	public List<InsInsuranceSlip> findAllInsOrderList(String sql) {

		return dao.findAllInsOrderList(sql);
	}

	/**
	 * <b>根据前台获取的买家列表查询相应安全等级再获取产品配的安全等级进行筛选只要跟产品存在的安全等级匹配就创建一条InsRiskDuty数据 </b>
	 *
	 * @param order_id
	 * @author ZXF
	 * @date 2017年1月19日 上午11:03:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id){
		InsInsuranceSlip insInsuranceSlip = packagingInsOrderForm(order_id);
		Long pid = insInsuranceSlip.getPro_primary().getPro_primary_id();
		ProPrimary product = insProductService.getProduct(pid);
		if(product == null ? false : ConstProp.XYX_DQCK.equals(product.getProduct_code())){
			SpecialCreditSt insCommonExport = (SpecialCreditSt) insInsuranceSlip.getMapSpecial().get(String.valueOf(pid));
			List<StTopBuyers> tbList = insCommonExport.getTopBuyers();
			Long underwrite_id = insInsuranceSlip.getUnderwrite().getUnderwrite_id();
			insRiskDutyService.accordingToInsTopBuyersListGainInsRiskDuty(tbList, underwrite_id, pid);
		}
	}

	/**
	 * <b>承保数据更新</b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月12日 上午9:43:07
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void updateOrderUnderwriting(OrderFormVo vo){
		InsInsuranceSlip insInsuranceSlip = packagingInsOrderForm(Long.parseLong(vo.getOid()));
		SimpleDateFormat DATE_FORMAT_6 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		int sign = 0;
		try {
			if(StringUtils.isNotEmpty(vo.getInception_date())){
				if(vo.getInception_date().indexOf(ConstProp.DAY_00)!=-1){
					insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date()));
				}else{
					insInsuranceSlip.setInception_date(DATE_FORMAT_6.parse(vo.getInception_date()+ConstProp.DAY_00));
				}
			}else{
				sign = 1;
			}
			if(StringUtils.isNotEmpty(vo.getPlanned_end_date())){
				if(vo.getInception_date().indexOf(ConstProp.DAY_23)!=-1){
					insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date()));
				}else{
					insInsuranceSlip.setPlanned_end_date(DATE_FORMAT_6.parse(vo.getPlanned_end_date()+ConstProp.DAY_23));
				}
			}else{
				sign = 1;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		insInsuranceSlip.setUnit_count(1);
		if(StringUtils.isNotEmpty(vo.getGross_premium())){
			insInsuranceSlip.setPremium(new BigDecimal(vo.getGross_premium()));
		}else{
			sign = 1;
		}
		if(StringUtils.isEmpty(vo.getExternal_reference())){
			sign = 1;
		}
		insInsuranceSlip.setEnd_time(new Date());
		dao.updateById(insInsuranceSlip);
		if(sign == 0){
			insAgreementService.willInsurePolicyVoChangeIntoInsAgreement(insInsuranceSlip.getIns_insurance_slip_id(), vo.getExternal_reference());
		}
	}

	@Override
	public List<OrderFormVo> findInsOrderForm(InsInsuranceSlip insInsuranceSlip) {
		List<OrderFormVo> voList = dao.findInsOrderForm();
		return voList;
	}

	/**
	 * <b>查询所有有效但未同步到支撑的订单 </b>
	 *
	 * @param
	 * @return
	 * @author zxf
	 * @date 2017年7月5日 下午16:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<OrderFormVo> findInsOrderFormByUnSync() {
		List<OrderFormVo> voList = dao.findInsOrderFormByUnSync();
		return voList;
	}

	@Override
	public PageResult findInsOrderFormByKeyword(Map<Object,Object> p) {
		return new PageResult(dao.findInsOrderFormByKeywordCnt(p),dao.findInsOrderFormByKeyword(p));
	}

	@Override
	public List<OrderFormVo> findInsOrderFormBySup(String sup_id) {
		List<OrderFormVo> voList = dao.findInsOrderFormBySup(sup_id);
		return voList;
	}


	@Override
	public List<OrderFormVo> getLawsuitList() {
		return dao.getLawsuitList();
	}

	/**
	 * <b>根据订单id查找对应OrderFormVo信息 </b>
	 *
	 * @param orderId
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public OrderFormVo findOrderFormVoByID(Long orderId){
		OrderFormVo vo = dao.getOrderFormVoByID(orderId);
		if(vo!=null){
			replenishOrderFormVo(vo);
			return vo;
		}
		return null;
	}

	/**
	 * <b>补充 OrderFormVo 数据</b>
	 *
	 * @param vo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:42:22
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void replenishOrderFormVo(OrderFormVo vo){
		insTransactionService.setOrderFormVoOfShowUrlByOrderID(vo, Long.parseLong(vo.getOid()));
		InsInsuranceSlip policy = dao.selectById(Long.parseLong(vo.getOid()));
		if(StringUtils.isEmpty(vo.getProduct_code()) ? false : ConstProp.XYX_XWCK.equals(vo.getProduct_code())){
			SpecialCreditMicro micro = insMicroExportService.selectById(policy.getSpecial_id());
			vo.setPolicy_currency(micro.getAnnual_currency()/*SysDictUtils.getDictLabel(, "annualCurrency", ConstProp.BLANK_CHAR)*/);
		}
        if(StringUtils.isNotEmpty(vo.getProduct_oid())){
            List<ResponsibilityVo> irpVoList = insProductResponsibilityService.findResponsibilityVoList(vo.getProduct_oid());
            vo.setResponsibilityVoList(irpVoList);
        }
	}

	/**
	 * <b> 导出所有在保保单信息 </b>
	 * @author ZXF
	 * @create 2020/09/18 0018 10:02
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void downAllPolicy(HttpServletResponse response){
		String fileName = "百联保在保保单-"+DateUtil.getCurrentDateTime("yyyyMMdd")+".xls";
		try {
			fileName = new String(fileName.getBytes("gb2312"), "ISO8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		com.bcxin.ins.util.excel.ExcelUtil<PolicyExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(PolicyExcelVo.class);
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-Disposition",
				"attachment;fileName=" + fileName);
		try(OutputStream os = response.getOutputStream();) {
			List<PolicyExcelVo> listMap = dao.downAllPolicy();
			util.exportExcel(listMap, "百联保在保保单", 65535, os);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
