package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_special.StForecastedDetail;
import com.bcxin.ins.models.order.policy.dao.InsForecastedDetailDao;
import com.bcxin.ins.models.order.policy.service.InsForecastedDetailService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ForecastedDetailVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;


@Service
@Transactional
public class InsForecastedDetailServiceImpl extends ServiceImpl<InsForecastedDetailDao, StForecastedDetail> implements InsForecastedDetailService {

	@Autowired
	private InsForecastedDetailDao dao;
	
	/**
	 * <b>根据InsTurnoverid查询  InsForecastedDetail列表</b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:46:29
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public List<StForecastedDetail> selectInsForecastedDetailByTurnover(Long oid) {
		return dao.selectInsForecastedDetailByTurnover(oid);
	}

	/**
	 * <b>根据Vo及短期出口ID更新InsForecastedDetail数据 </b> 
	 * 
	 * @param vo
	 * @param turnover_id 销售额表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	/*public void accordingToTheForecastedDetailVoSetUpInsForecastedDetail(ForecastedDetailVo vo,Long turnover_id){
		InsForecastedDetail insForecastedDetail = null;
		if(StringUtil.isNotEmpty(vo.getOid())){
			insForecastedDetail = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insForecastedDetail = new InsForecastedDetail();
			insForecastedDetail.getInsTurnover().setId(turnover_id);
			dao.insert(insForecastedDetail);
		}
		insForecastedDetail.setCountry(vo.getCountry());
		insForecastedDetail.setAnnualSales(vo.getAnnualSales());
		insForecastedDetail.setHca(vo.getHca());
		insForecastedDetail.setBuyersNum(vo.getBuyersNum());
		insForecastedDetail.setPaymentTerms(vo.getPaymentTerms());
		dao.updateById(insForecastedDetail);
	}*/
	
	/**
	 * <b>接收页面传回的未来一年内所须投保的信用销售总额信息列表进行更新 </b> 
	 * 
	 * @param voList 未来一年内所须投保的信用销售总额信息列表
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setForecastedDetailByForecastedDetailVo(List<ForecastedDetailVo> voList, Long turnover_id){
		if(voList != null && voList.size()> ConstProp.INT_NUMBER_ZERO){
			ruleOutDoesNotExist(voList, turnover_id);
			for(ForecastedDetailVo vo : voList){
				accordingToTheForecastedDetailVoSetUpInsForecastedDetail(vo,turnover_id);
			}
		}
	}

	/**
	 * <b>排除数据库存在的但页面被删除的条目信息，获取这些条目并删除 </b> 
	 * 
	 * @param voList
	 * @param turnover_id
	 * @author ZXF 
	 * @date 2017年1月13日 上午10:59:02
	 * @注意事项 </b>
	 * <b>
	 */
	private void ruleOutDoesNotExist(List<ForecastedDetailVo> voList,
			Long turnover_id) {
		List<StForecastedDetail> fdList = selectInsForecastedDetailByTurnover(turnover_id);
		for(StForecastedDetail ifd : fdList){
			int i = ConstProp.INT_NUMBER_ZERO;
			for(ForecastedDetailVo vo : voList){
				if(StrUtil.isNotBlank(vo.getOid())){
					if(ifd.getSt_forecasted_detail_id() == Long.parseLong(vo.getOid())){
						i = ConstProp.INT_NUMBER_ONE;
					}
				}
			}
			if(i == ConstProp.INT_NUMBER_ZERO){
				dao.deleteById(ifd.getSt_forecasted_detail_id());
			}
		}
	}
	
	/**
	 * <b>根据未来一年内所须投保的信用销售总额交互辅助类更新InsForecastedDetail数据 </b> 
	 * 
	 * @param vo
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheForecastedDetailVoSetUpInsForecastedDetail(ForecastedDetailVo vo, Long turnover_id){
		StForecastedDetail insForecastedDetail = null;
		if(StrUtil.isNotBlank(vo.getOid())){
			insForecastedDetail = dao.selectById(Long.parseLong(vo.getOid()));
		}else{
			insForecastedDetail = new StForecastedDetail();
			insForecastedDetail.getTurnover().setSt_turnover_id(turnover_id);
			dao.insert(insForecastedDetail);
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insForecastedDetail);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insForecastedDetail);
	}
	
	/**
	 * <b>根据List<InsForecastedDetail>封装到 List<ForecastedDetailVo>中</b> 
	 * 
	 * @param fdList
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:18:47
	 * @注意事项 </b>
	 * <b>
	 */
	public List<ForecastedDetailVo> packagingForecastedDetailVoListByInsForecastedDetailList(List<StForecastedDetail> fdList){
		List<ForecastedDetailVo> voList = new ArrayList<ForecastedDetailVo>();
		for(StForecastedDetail ifd : fdList){
			voList.add(accordingToInsForecastedDetailIntoForecastedDetailVo(ifd));
		}
		return voList;
	}
	
	/**
	 * <b>根据未来一年内所须投保的信用销售总额表信息转换成 ForecastedDetailVo </b> 
	 * 
	 * @param insForecastedDetail
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	public ForecastedDetailVo accordingToInsForecastedDetailIntoForecastedDetailVo(StForecastedDetail insForecastedDetail){
		ForecastedDetailVo vo = new ForecastedDetailVo();
		vo.setOid(String.valueOf(insForecastedDetail.getSt_forecasted_detail_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insForecastedDetail), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}
}
