package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_special.StBadDebt;
import com.bcxin.ins.models.order.policy.dao.InsBadDebtDao;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



@Service
@Transactional
public class InsBadDebtServiceImpl extends ServiceImpl<InsBadDebtDao, StBadDebt> implements InsBadDebtService {

	@Autowired
	private InsDebtAgesService insDebtAgesService;
	
	@Autowired
	private InsOverdueDetailService insOverdueDetailService;
	
	@Autowired
	private InsPastBadDetailService insPastBadDetailService;
	
	@Autowired
	private InsBadAnalysisService insBadAnalysisService;
	@Autowired
	private InsBadDebtDao dao;

	/**
	 * <b>根据id查询 InsBadDebt 及关联表封装</b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:46:29
	 * @注意事项 </b>
	 * <b>
	 */
	public StBadDebt packagingInsBadDebt(Long oid){
		StBadDebt insBadDebt = dao.selectById(oid);
		if(insBadDebt != null){
			insBadDebt.setInsBadAnalysis(insBadAnalysisService.selectInsBadAnalysisByInsBadDebt(insBadDebt.getSt_bad_debt_id()));
			insBadDebt.setInsDebtAges(insDebtAgesService.selectInsDebtAgesByInsBadDebt(insBadDebt.getSt_bad_debt_id()));
			insBadDebt.setInsOverdueDetail(insOverdueDetailService.selectInsOverdueDetailByInsBadDebt(insBadDebt.getSt_bad_debt_id()));
			insBadDebt.setInsPastBadDetail(insPastBadDetailService.selectInsPastBadDetailByInsBadDebt(insBadDebt.getSt_bad_debt_id()));
		}
		return insBadDebt;
	}

	@Override
	public StBadDebt initInsBadDebt() {
		StBadDebt insBadDebt = new StBadDebt();
		dao.insert(insBadDebt);
		return insBadDebt;
	}
	
	/**
	 * <b>根据Vo及账龄及坏账分析表 ID更新InsBadDebt数据 </b> 
	 * 
	 * @param vo
	 * @param badDebtID 账龄及坏账分析表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheCommonExportVo_2SetUpInsBadDebt(CommonExportVo_2 vo, Long badDebtID){
		StBadDebt insBadDebt = dao.selectById(badDebtID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insBadDebt);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insBadDebt);
	}
	
	/**
	 * <b>根据账龄及坏账分析表信息转换成 BadDebtVo</b> 
	 * 
	 * @param iad 账龄及坏账分析表
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToInsBadDebtIntoBadDebtVo(CommonExportVo_2 vo, StBadDebt iad){
		if(iad == null){
			return;
		}
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(iad), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
