package com.bcxin.ins.models.order.policy.service.impl;


import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.models.order.policy.dao.HirelingDao;
import com.bcxin.ins.models.order.policy.service.HirelingService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.HirelingVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;


/**
 * <b>雇主责任险雇员特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class HirelingServiceImpl extends ServiceImpl<HirelingDao, Hireling> implements HirelingService {

	@Autowired
	private HirelingDao dao;

	/**
	 * <b>根据Vo及订单ID更新Hireling数据 </b>
	 *
	 * @param vo
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void accordingToTheHirelingVoSetUpHireling(SpecialHirelingVo vo, Long order_id){
		List<HirelingVo> hvoList = vo.getHirelingVoList();
		Hireling hireling = null;
		for(HirelingVo hvo : hvoList){
			if(StringUtils.isNotEmpty(hvo.getOid())){
				hireling = dao.selectById(Long.parseLong(hvo.getOid()));
				try {
					MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), hireling);
				} catch (Exception e) {
					e.printStackTrace();
				}
				dao.updateById(hireling);
			}else{
				hireling = new Hireling();
				try {
					MyConverUtil.map2PO(MyConverUtil.PO2Map(hvo), hireling);
					hireling.setIns_insurance_slip_id(order_id);
				} catch (Exception e) {
					e.printStackTrace();
				}
				dao.insert(hireling);
			}
		}
	}

	/**
	 * <b>获取SpecialHirelingVo根据订单id查询雇员信息信息插入到SpecialHirelingVo </b>
	 *
	 * @param vo 雇主责任险雇员辅助表
	 * @param order_id 订单id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getSpecialHirelingVoByOrderID(SpecialHirelingVo vo, Long order_id){
		List<HirelingVo> list = dao.selectHirelingVoByOrderId(order_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new HirelingVo());
			}
		}
		vo.setHirelingVoList(list);
	}

	/**
	 * 根据id删除雇员
	 * @param oid 雇员id
	 * @return
	 */
	@Override
	public boolean delectHirelingByOid(Long oid){
		try {
			dao.deleteById(oid);
			return true;
		}catch (Exception e){
			return false;
		}
	}

	/**
	 * 根据id删除订单下所有雇员
	 * @param oid 订单id
	 * @return
	 */
	@Override
	public boolean delectAllHireling(Long oid){
		try {
			Map<String, Object> map = Maps.newHashMap();
			map.put("ins_insurance_slip_id",oid);
			dao.deleteByMap(map);
			return true;
		}catch (Exception e){
			return false;
		}
	}
}
