package com.bcxin.ins.models.order.policy.service;

import com.bcxin.ins.core.base.service.BaseService;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.entity.common.ComBuyers;
import com.bcxin.ins.entity.policy_special.StTopBuyers;
import com.bcxin.ins.vo.BuyersVo_two;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import com.bcxin.mybatisplus.service.IService;

import java.math.BigDecimal;
import java.util.List;


public interface InsTopBuyersService extends IService<StTopBuyers> {
	
	public StTopBuyers packagingInsTopBuyers(Long oid);
	
	public List<StTopBuyers> selectInsTopBuyersBySpecialID(Long oid);
	
	public void setTopBuyersByTopBuyersVo(List<TopBuyersVo> voList, Long special_id);
	
	public List<TopBuyersVo> getTopBuyersVoListBySpecialID(Long special_id);
	
	public TopBuyersVo accordingToInsTopBuyersIntoTopBuyersVo(StTopBuyers tb);
	
	public TopBuyersVo accordingToInsBuyersIntoTopBuyersVo(ComBuyers insBuyers);

	public void accordingToTheTopBuyersVoSetUpInsTopBuyers(TopBuyersVo vo, Long special_id);
	
	/**
	 * 根据订单ID获取该订单下所有的买家<br>
	 * @author liumd
	 * @date 2017年1月16日
	 */
	public List<StTopBuyers> getInsTopBuyersByOrderFormId(Long orderFormId, DwzPage page);
	
	public List<BuyersVo_two> getBuyersVoTwoByOrderFormId(Long orderFormId, DwzPage page);

	public boolean updateTopBuyerForDelStatus(Long oid);

	/**
	 * <b>全球买家列表（除外 本订单）</b> 
	 */
	List<StTopBuyers> findTopBuyers(DwzPage page, TopBuyersVo vo);

	public List<TopBuyersVo> findTopBuyersOrder(DwzPage page, SysUser user);

	public TopBuyersVo getBuyersVoById(Long oid);

	/**
	 * <b>十大买家列表   本订单下的 买家</b> 
	 */
	public List<StTopBuyers> selectInsTopBuyersListBySpecialID(DwzPage page, TopBuyersVo topBuyersVo);

	/**
	 * <b>修改可用额度 </b>
	 */
	public boolean updTopFreeAmount(String oid, Long userId, Long status, BigDecimal amount);
	
	/**  根据订单ID,搜索输入的国家，搜索输入的公司获取该订单下所有的买家*/
	public List<BuyersVo_two> findBuyersListByOrderFormIdAndSearch(Long orderFormId, DwzPage page, String countrySearch, String companySearch);


	/**
	 * <b>批复了几条申请</b>
	 */
	public Long getInsTopBuyerPifu(Long userId, Long type);

	/**
	 * <b>未批复申请</b>
	 */
	public Long getInsTopBuyerWPifu(Long userId, Long type);

	/**
	 * <b>批复列表 statusType  0 表示未批复    1表示已批复  </b>
	 * @param page 
	 */
	public List<TopBuyersVo> findPifuList(Long userId, Long type, DwzPage page, String statusType);


}
