package com.bcxin.ins.models.claim.service.impl;

import com.bcxin.ins.entity.policy_report.InsPaymentInfo;
import com.bcxin.ins.models.claim.dao.InsPaymentInfoDao;
import com.bcxin.ins.models.claim.service.InsPaymentInfoService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.report_pac.InsPaymentInfoVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
public class InsPaymentInfoServiceImpl extends ServiceImpl<InsPaymentInfoDao, InsPaymentInfo> implements InsPaymentInfoService {

	@Autowired
	private InsPaymentInfoDao dao;

	/**
	 * <b> 支付信息转vo </b>
	 * @author ZXF
	 * @create 2019/11/20 0020 16:20
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public void convertInsPaymentInfoVo(InsPaymentInfoVo vo, InsPaymentInfo insPaymentInfo){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insPaymentInfo), vo);
			if(vo.getProvince_name()!=null){
				vo.setBank_address(vo.getProvince_name()+" "+vo.getCity_name());
			}
			if(vo.getBank_account_attribute() != null){
				vo.setBank_account_attribute_name(ConstProp.DIGIT_ONE.equals(vo.getBank_account_attribute())?"个人账号":"公司账号");
			}
			if(vo.getClient_certificate_type() != null){
				vo.setClient_certificate_type_name(IdType.convert_value(vo.getClient_certificate_type()).getName());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * <b> 获取支付信息 </b>
	 * @author ZXF
	 * @create 2019/11/20 0020 16:20
	 * @version
	 * @注意事项 </b>
	 */
	@Override
	public InsPaymentInfoVo getInsPaymentInfoVo(Long insPaymentInfoID){
		InsPaymentInfoVo vo = null;
		try {
			InsPaymentInfo insPaymentInfo = dao.selectById(insPaymentInfoID);
			vo = new InsPaymentInfoVo();
			convertInsPaymentInfoVo(vo,insPaymentInfo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return vo;
	}

}
