package com.bcxin.ins.models.claim.service.impl;


import com.bcxin.ins.entity.policy_report.InsCaseSchedule;
import com.bcxin.ins.models.claim.dao.InsCaseScheduleDao;
import com.bcxin.ins.models.claim.service.InsCaseScheduleService;
import com.bcxin.ins.vo.report_pac.InsCaseScheduleVo;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * <b>报案成功案件信息业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsCaseScheduleServiceImpl extends ServiceImpl<InsCaseScheduleDao, InsCaseSchedule> implements InsCaseScheduleService {

	@Autowired
	private InsCaseScheduleDao dao;

	/**
	 * <b>获取InsCommonReportVo根据报案id查询报案成功案件信息插入到InsCommonReportVo </b>
	 *
	 * @param vo 报案辅助表
	 * @param report_id 报案id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@Override
	public void getInsCommonReportVoByReportID(InsCommonReportVo vo, Long report_id){
		List<InsCaseScheduleVo> list = dao.selectInsCaseScheduleVoByReportId(report_id);
		int count = 0;
		if(list != null){
			if(list.size()<3){
				count = list.size();
			}else{
				count = 100;
			}
		}
		if(count == 100){
			for(int i = count;i<3;i++){
				list.add(new InsCaseScheduleVo());
			}
		}
		vo.setCaseScheduleVoList(list);
	}

}
