package com.bcxin.ins.models.claim.dao;

import com.bcxin.ins.entity.policy_report.InsClaimInformation;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.report_pac.InsClaimInformationVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 * <b> 报案附件数据库操作 </b>
 * @author ZXF
 * @create 2019/11/20 0020 16:55
 * @version
 * @注意事项 </b>
 */
@MyBatisDao
public interface InsClaimInformationDao extends BaseMapper<InsClaimInformation> {

    List<InsClaimInformationVo> selectInsClaimInformationVoByReportId(@Param("report_id") Long report_id);

    void batchInsert(@Param("list") List<InsClaimInformation> list);
    void batchUpdate(@Param("list") List<InsClaimInformation> list);

    /**
     * 根据报案Id查找附件状态为0的条目变更状态为1
     * @param report_id 报案id
     * @return
     */
    int updateStatusByReportId(@Param("report_id") Long report_id);
}
