package com.bcxin.ins.models.apply.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.service.ComDeployConfigService;
import com.bcxin.ins.core.service.impl.MySysClientUserServiceImpl;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.entity.common.ComTaskResidual;
import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.models.apply.dao.PreseverApplyDao;
import com.bcxin.ins.models.apply.dao.PreseverApplyDetailDao;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import com.bcxin.ins.models.apply.service.InsPreservationPayService;
import com.bcxin.ins.models.apply.service.InsPreservationResultSetService;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.pub.service.ADModelSendService;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.vo.excel.*;
import com.bcxin.ins.models.order.policy.service.*;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.email.*;
import com.bcxin.ins.util.http.HuaWeiSmsContent;
import com.bcxin.ins.util.http.RequestUtil;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * <b>保全申请业务处理 </b>
 *
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class PresverApplyServiceImpl extends ServiceImpl<PreseverApplyDao, InsPreservationRecord> implements PreseverApplyService {

    private static Logger log = LoggerFactory.getLogger(MySysClientUserServiceImpl.class);

    @Autowired
    private PreseverApplyDao dao;
    @Autowired
    private PreseverApplyDetailDao dao2;
    @Autowired
    private InsRoleInpolicyService insRoleInpolicyService;

    @Autowired
    private InsuranceOperationService insuranceOperationService;

    @Autowired
    private InsPreservationResultSetService insPreservationResultSetService;

    @Autowired
    private InsPreservationPayService insPreservationPayService;
    @Autowired
    private InsPreservationDetailService insPreservationDetailService;
    @Autowired
    private ComDeployConfigService comDeployConfigService;
    @Autowired
    private ComTaskResidualService comTaskResidualService;
    @Autowired
    private ADModelSendService mss;

    @Autowired
    private MyAsyncExecutor myAsyncExecutor;

    /**
     * 文件上传并返回下载地址
     *
     * @param roleFile 上传文件
     * @param savePath 文件要保存的文件夹地址（/policy/）
     * @return /getResource?path=/policy/1231231.jpg
     */
    @Override
    public String uploadFile(MultipartFile roleFile, String savePath) {
        String result = "";
        if (!roleFile.isEmpty()) {
            try {
                String fileName = roleFile.getOriginalFilename();    //上传文件名
                String materialFileType = fileName.split("\\.")[1]; //文件类型
                String files = DateUtil.generatorRadomNumber() + "." + materialFileType;
                result = savePath + files;
                String path = GlobalResources.COM_IMG_RE + savePath;
//                String path = GlobalResources.COM_IMG_RE+savePath;
                File fileP = new File(path);
                if (!fileP.exists()) {
                    fileP.mkdirs();
                }
                File file = new File(path + files);

                roleFile.transferTo(file);
                result = "/getResource?path=" + result;
            } catch (IOException e) {
                e.printStackTrace();
                result = "";
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            }
        }
        return result;
    }

    @Override
    public boolean savePath(Long oid, String path, String upload_Type) {
        boolean flag = true;
        try {
            if ("1".equals(upload_Type)) {
                dao.updateDetailResivePathByID(oid, path);
            } else if ("2".equals(upload_Type)) {
                dao.updatePayPathResivePathByID(oid, path);
            } else if ("3".equals(upload_Type)) {
                InsPreservationPay pay = insPreservationPayService.selectById(oid);
                if(StringUtils.isNotEmpty(pay.getPay_order_path())){
                    path = pay.getPay_order_path()+"||"+path;
                }
                pay.setPay_order_path(path);
                pay.setPay_status(DictConst.RECORD_PAY_STATUS_DSH);
                insPreservationPayService.updateById(pay);
            } else if ("4".equals(upload_Type)) {
                InsPreservationPay pay = insPreservationPayService.selectById(oid);
                pay.setFp_url(path);
                insPreservationPayService.updateById(pay);
            }
        } catch (Exception e) {

            flag = false;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return flag;
    }

    @Override
    public R doUploadFile(String path, String upload_id, String upload_Type) {
        if (StringUtils.isEmpty(upload_id)) {
            return new R(false, "上传数据丢失!");
        }
        //保存路径
        if (StringUtils.isNotEmpty(path)) {
            if (savePath(Long.parseLong(upload_id), path, upload_Type)) {
                return new R(true, path);
            } else {
                return new R(false, "上传更新失败");
            }
        } else {
            return new R(false, "文件保存失败!");
        }

    }

    /**
     * 保全申请分页查询
     */
    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(dao.queryCnt(p), dao.query(p));
    }

    /**
     * 保全详情人员分页查询
     */
    @Override
    public PageResult queryDetail(Map<Object, Object> p) {
//        p.put("exclude", "2");//排除状态等于2的条目(这里是查询页面展示不做过滤，如果是业务需要则统一过滤掉状态为2的数据)
        return new PageResult(dao2.queryDetailCnt(p), dao2.queryDetail(p));
    }

    /**
     * 保全详情原被保险人员分页查询
     */
    @Override
    public PageResult queryOldPerson(Map<Object, Object> p) {
        List<Map<Object,Object>> resultSetList = dao2.queryOldPersonFromResultSet(p);
        for (Map map:resultSetList) {
            String name= String.valueOf(map.get("name_cn"));
            if (!"null".equals(String.valueOf(map.get("name_cn")))) {
                return new PageResult(dao2.queryOldPersonFromResultSetCnt(p), dao2.queryOldPersonFromResultSet(p));//result 里面有值就走这
            } else {
                return new PageResult(dao2.queryOldPersonCnt(p), dao2.queryOldPerson(p));//result 里面没值就走这
            }
        }
        return null;//result 里面没值就走这
    }
    /**
     * 保全缴费分页查询
     */
    @Override
    public PageResult queryPay(Map<Object, Object> p) {
        return new PageResult(dao.queryPayCnt(p), dao.queryPay(p));
    }
    /**
     * 保全汇总账单分页查询
     */
    @Override
    public PageResult queryBillPay(Map<Object, Object> p) {
        return new PageResult(dao.queryBillPayCnt(p), dao.queryBillPay(p));
    }
    /**
     * 保全汇总子账单分页查询
     */
    @Override
    public PageResult queryChildBillPay(Map<Object, Object> p) {
        return new PageResult(dao.queryChildBillPayCnt(p), dao.queryChildBillPay(p));
    }
    /**
     * 保全结算单分页查询
     */
    @Override
    public PageResult querySettlementPay(Map<Object, Object> p) {
        return new PageResult(dao.querySettlementPayCnt(p), dao.querySettlementPay(p));
    }
    /**
     * 保全结算子账单分页查询
     */
    @Override
    public PageResult queryChildSettlementPay(Map<Object, Object> p) {
        return new PageResult(dao.queryChildSettlementPayCnt(p), dao.queryChildSettlementPay(p));
    }


    /**
     * <b> 汇总账单导出 </b>
     * @author ZXF
     * @create 2024/04/28 0028 16:14
     * @version
     * @注意事项 </b>
     */
    public void downBillPay(String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response){
        Map<Object, Object> p = new HashMap<>();
        p.put("pay_status", pay_status);
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = dao.queryBillPay(p);
        com.bcxin.ins.util.excel.ExcelUtil<InsPreservationPayExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(InsPreservationPayExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword+"汇总账单清单.xls").getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            List<InsPreservationPayExcelVo> addMap = Lists.newArrayList();
            for(Map<Object, Object> map : maps){
                addMap.add(new InsPreservationPayExcelVo(map.get("external_reference")!=null?map.get("external_reference").toString():""
                        , map.get("company_name")!=null?map.get("company_name").toString():""
                        , map.get("app_role_name")!=null?map.get("app_role_name").toString():""
                        , map.get("record_count")!=null?map.get("record_count").toString():""
                        , map.get("predict_total_amount")!=null?map.get("predict_total_amount").toString():""
                        , map.get("star_pay_time")!=null?map.get("star_pay_time").toString():""
                        , map.get("end_pay_time")!=null?map.get("end_pay_time").toString():""
                        , map.get("build_data")!=null?map.get("build_data").toString():""
                        , SysDictUtils.getDictLabel(map.get("pay_status")!=null?map.get("pay_status").toString():"","billPayStatus","")
                        , map.get("is_part")!=null&&Integer.parseInt(map.get("is_part").toString())==1?"部分账单":"汇总账单"
                        , map.get("is_fp")!=null&&Integer.parseInt(map.get("is_fp").toString())==1?"是":"否"));
            }
            util.exportExcel(addMap, keyword+"汇总账单清单", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 汇总账单下属子账单导出 </b>
     * @author ZXF
     * @create 2024/04/28 0028 16:14
     * @version
     * @注意事项 </b>
     */
    public void downChildBillPay(Long parentPayId, String pay_status, String start_time, String end_time, String keyword, HttpServletResponse response){
        Map<Object, Object> p = new HashMap<>();
        p.put("pay_status", pay_status);
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("parentPayId", parentPayId);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = dao.queryChildBillPay(p);
        com.bcxin.ins.util.excel.ExcelUtil<InsPreservationPayChildExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword+"子账单清单.xls").getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            List<InsPreservationPayChildExcelVo> addMap = Lists.newArrayList();
            for(Map<Object, Object> map : maps){
                addMap.add(new InsPreservationPayChildExcelVo(map.get("external_reference")!=null?map.get("external_reference").toString():""
                        , map.get("company_name")!=null?map.get("company_name").toString():""
                        , map.get("insurance_name")!=null?map.get("insurance_name").toString():""
                        , map.get("app_role_name")!=null?map.get("app_role_name").toString():""
                        , SysDictUtils.getDictLabel(map.get("pay_status")!=null?map.get("pay_status").toString():"","payStatus","")
                        , map.get("record_count")!=null?map.get("record_count").toString():""
                        , map.get("add_count")!=null?map.get("add_count").toString():""
                        , map.get("minus_count")!=null?map.get("minus_count").toString():""
                        , map.get("replace_count")!=null?map.get("replace_count").toString():""
                        , map.get("predict_total_amount")!=null?map.get("predict_total_amount").toString():""
                        , map.get("fact_total_amount")!=null?map.get("fact_total_amount").toString():""
                        , map.get("star_pay_time")!=null?map.get("star_pay_time").toString():""
                        , map.get("end_pay_time")!=null?map.get("end_pay_time").toString():""));
            }
            util.exportExcel(addMap, keyword+"子账单清单", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 结算单下属子账单导出 </b>
     * @author ZXF
     * @create 2024/04/28 0028 16:14
     * @version
     * @注意事项 </b>
     */
    public void downChildSettlementBillPay(Long parentPayId, String start_time, String end_time, String keyword, HttpServletResponse response){
        Map<Object, Object> p = new HashMap<>();
        p.put("start_time", start_time);
        p.put("end_time", end_time);
        p.put("keyword", keyword);
        p.put("parentPayId", parentPayId);
        p.put("offset", 0);
        p.put("limit", 10000);
        List<Map<Object, Object>> maps = dao.queryChildSettlementPay(p);
        com.bcxin.ins.util.excel.ExcelUtil<InsPreservationPayChildExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(InsPreservationPayChildExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword+"子账单清单.xls").getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            List<InsPreservationPayChildExcelVo> addMap = Lists.newArrayList();
            for(Map<Object, Object> map : maps){
                addMap.add(new InsPreservationPayChildExcelVo(map.get("external_reference")!=null?map.get("external_reference").toString():""
                        , map.get("company_name")!=null?map.get("company_name").toString():""
                        , map.get("insurance_name")!=null?map.get("insurance_name").toString():""
                        , map.get("app_role_name")!=null?map.get("app_role_name").toString():""
                        , SysDictUtils.getDictLabel(map.get("pay_status")!=null?map.get("pay_status").toString():"","payStatus","")
                        , map.get("record_count")!=null?map.get("record_count").toString():""
                        , map.get("add_count")!=null?map.get("add_count").toString():""
                        , map.get("minus_count")!=null?map.get("minus_count").toString():""
                        , map.get("replace_count")!=null?map.get("replace_count").toString():""
                        , map.get("predict_total_amount")!=null?map.get("predict_total_amount").toString():""
                        , map.get("fact_total_amount")!=null?map.get("fact_total_amount").toString():""
                        , map.get("star_pay_time")!=null?map.get("star_pay_time").toString():""
                        , map.get("end_pay_time")!=null?map.get("end_pay_time").toString():""));
            }
            util.exportExcel(addMap, keyword+"子账单清单", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b>根据页面勾选条目生成部分账单 </b>
     * @param isSummaryBill 是否为汇总账单
     * @param payIds 勾选数据列的id集合
     * @author ZXF
     * @create 2024/04/26 0026 11:07
     * @version
     * @注意事项 </b>
     */
    public JSONObject createPartBill(String isSummaryBill, String[] payIds){

        JSONObject json = new JSONObject();
        if(payIds==null || payIds.length<1){
            json.put("status", ConstProp.CODE_FAILURE);
            json.put("msg", "无有效账单");
            return json;
        }
        //TODO 需要判断如果不是汇总账单id归属账单不能只有这单一单，如果是汇总账单id不能只有1个
        if(ConstProp.DIGIT_ONE.equals(isSummaryBill)){
            //汇总账单
            //payIds>1
            if(payIds.length<2){
                json.put("status", ConstProp.CODE_FAILURE);
                json.put("msg", "单条汇总账单可直接完成缴费业务");
                return json;
            }
            //未被标记的子账单数大于1，并且分属多个汇总账单（>1）（子账单都被生成部分账单的，列表控制不能勾选）

        }else{
            //是否账号一致
            int isConsistent = dao.isConsistentAccount(isSummaryBill,payIds);
            if(isConsistent>1){
                json.put("status", ConstProp.CODE_FAILURE);
                json.put("msg", "不是同账号下的账单，无法合并");
                return json;
            }
            //子账单
            //payIds不能包含有被标记的记录
            String partBillSign = dao.isPartBillSign(payIds);
            if(StringUtils.isNotEmpty(partBillSign)){
                json.put("status", ConstProp.CODE_FAILURE);
                json.put("msg", "这些账单编码已生成部分账单，无法重复生成："+partBillSign);
                return json;
            }
            //同个上级账单
            List<Map<String,String>> isConsistentSummaryBill = dao.isConsistentSummaryBill(payIds);
            if(isConsistentSummaryBill.size() == 1){
                Map<String,String> map = isConsistentSummaryBill.get(0);
                if(ConstProp.DIGIT_ONE.equals(map.get("isAll"))){
                    json.put("status", ConstProp.CODE_FAILURE);
                    json.put("msg", "操作对象归属同一账单，无法重复生成："+map.get("external_reference"));
                    return json;
                }
            }
        }

        //是否险种一致
        int isConsistent = dao.isConsistentInsurancePlan(isSummaryBill,payIds);
        if(isConsistent>1){
            json.put("status", ConstProp.CODE_FAILURE);
            json.put("msg", "账单险种不一致，无法合并");
            return json;
        }

        List<InsPreservationPay> billMergeList = dao.consistentBillMerge(isSummaryBill,payIds);
        com.bcxin.ins.util.IdWorker idWorker = new com.bcxin.ins.util.IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
        Long ins_preservation_pay_id;
        String[] pays;
        for (InsPreservationPay ipPay:billMergeList) {
            ins_preservation_pay_id = idWorker.nextId();
            ipPay.setExternal_reference("BFZD"+ins_preservation_pay_id);
            ipPay.setIns_preservation_pay_id(ins_preservation_pay_id);
            ipPay.setParent_part_bill_id(ins_preservation_pay_id);//父部分账单id是自己
            pays = ipPay.getPay_list().split(",");
            insPreservationPayService.insert(ipPay);
            //状态都改成 支付中
            dao.updateParentPartBillId(ins_preservation_pay_id,ConstProp.DIGIT_FIVE,pays);
        }

        json.put("status", ConstProp.CODE_SUCCESS);
        json.put("msg", "部分账单完成合并");
        return json;
    }

    public JSONObject createPartBillByNo(String isSummaryBill, String[] payNos){
        String payIds = dao.findPayIdsByPayNos(payNos);
        return createPartBill(isSummaryBill,payIds.split(","));
    }

    @Override
    public InsPreservationRecordVo accordingToApplyIDToGetpreservationRecordVo(Long record_id) {
        List<InsPreservationRecordVo> listVo = dao.findRecordFormVoByID(record_id);
        if (listVo != null) {
            InsPreservationRecordVo vo = listVo.get(0);

            return vo;
        }
        return null;
    }

    /**
     * 缴费详情分页查询
     */
    @Override
    public PageResult queryPayDetail(Map<Object, Object> p) {
        return new PageResult(dao.queryPayDetailCnt(p), dao.queryPayDetail(p));
    }

    @Override
    public int updatedetailFormStatus(InsPreservationDetailVo vo) {

        int result = dao2.updataDetailFormByKeyword(vo.getOid(), vo.getStatus(), vo.getRemark());
        return result;

    }

    /**
     * <b> 导出时间区间中华雇主[待审核]状态的保全人员列表(仅支持筛选增员、减员类型的保全单) </b>
     * @author ZXF
     * @create 2019/08/29 0029 16:58
     * @version
     * @注意事项 </b>
     */
    @Override
    public void downRecordResultSet(String keyword, String name, String start_time, String end_time, HttpServletResponse response) {
        com.bcxin.ins.util.excel.ExcelUtil<RecordExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(RecordExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("审核保全人员.xls".getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            //DateUtil.thisMonday() 得到这个周的周一
            List<RecordExcelVo> listMap = dao2.downRecordResultSet(keyword, name, start_time, end_time, "GZZRX-ZH");
            List<RecordExcelVo> addMap = Lists.newArrayList();
            RecordExcelVo addVo;
            for(RecordExcelVo vo : listMap){
                if(StringUtils.isNotEmpty(vo.getTjData())){
                    addVo = (RecordExcelVo)MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), new RecordExcelVo());
                    String[] arr = vo.getTjData().split(ConstProp.POUND_SIGN);
                    addVo.setName(arr[0]);
                    addVo.setId_card(arr[1]);
                    addVo.setTel(arr[2]);
                    addVo.setRevise_type("减员");
                    addMap.add(addVo);
                }
            }
            if(addMap.size()>0){
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, "审核保全人员", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 导出指定投保人和已选时间区间【待审核、审批通过】状态的保全申请单明细(仅支持筛选增员、减员类型的保全单) </b>
     * @author ZXF
     * @create 2019/08/29 0029 16:58
     * @version
     * @注意事项 </b>
     */
    @Override
    public void downRecordDetail(String keyword, String name, String start_time, String end_time, HttpServletResponse response) {
        com.bcxin.ins.util.excel.ExcelUtil<RecordDetailExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(RecordDetailExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword+"保全单明细.xls").getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            //DateUtil.thisMonday() 得到这个周的周一
            List<RecordDetailExcelVo> listMap = dao2.downRecordDetail(keyword, name, start_time, end_time);
            List<RecordDetailExcelVo> addMap = Lists.newArrayList();
            RecordDetailExcelVo addVo;
            for(RecordDetailExcelVo vo : listMap){
                if(StringUtils.isNotEmpty(vo.getTjData())){
                    addVo = (RecordDetailExcelVo)MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), new RecordDetailExcelVo());
                    String[] arr = vo.getTjData().split(ConstProp.POUND_SIGN);
                    addVo.setName(arr[0]);
                    addVo.setId_card(arr[1]);
                    addVo.setTel(arr[2]);
                    addVo.setRevise_type("减员");
                    addMap.add(addVo);
                }
            }
            if(addMap.size()>0){
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, keyword+"保全单明细", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 导出在保人员数据及保全金额 </b>
     * @author ZXF
     * @create 2020/02/14 0014 16:11
     * @version
     * @注意事项 </b>
     */
    @Override
    public void downSuccessResultSet(String keyword, String name, String start_time, String end_time,String type,String isGQ, HttpServletResponse response) {
        com.bcxin.ins.util.excel.ExcelUtil<RecordSuccessExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(RecordSuccessExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        try {
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String((keyword+"批单通过人员清单.xls").getBytes("gb2312"), "ISO8859-1"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try(OutputStream os = response.getOutputStream();) {
            List<RecordSuccessExcelVo> listMap;
            if("0".equals(isGQ)){
                listMap = dao2.downSuccessResultSet(keyword, name, start_time, end_time, type);
            }else{
                listMap = dao2.downSuccessResultSetGQ(keyword, start_time, end_time, type);
            }
            List<RecordSuccessExcelVo> addMap = Lists.newArrayList();
            RecordSuccessExcelVo addVo;
            for(RecordSuccessExcelVo vo : listMap){
                if(StringUtils.isNotEmpty(vo.getTjData())){
                    addVo = (RecordSuccessExcelVo)MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), new RecordSuccessExcelVo());
                    String[] arr = vo.getTjData().split(ConstProp.POUND_SIGN);
                    addVo.setName(arr[0]);
                    addVo.setId_card(arr[1]);
                    addVo.setRevise_type("减员");
                    addMap.add(addVo);
                }
            }
            if(addMap.size()>0){
                listMap.addAll(addMap);
            }
            util.exportExcel(listMap, keyword+"批单通过人员清单", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int updateRecordStatus(InsPreservationRecordVo vo) {
        int result = dao.updateRecordStatus(vo);
        log.info(vo.getRevise_path());
        return result;

    }

    @Override
    public int updateReleaseTime(InsPreservationRecordVo vo) {

        int result = dao.updateRelease_time(vo.getOid(), vo.getRevise_status());
        return result;

    }

    public int saveResultSet(InsPreservationRecordVo vo) {

        List<Map<Object, Object>> l = Lists.newArrayList();
        for (Map<Object, Object> m : l) {
            InsPreservationResultSet is = (InsPreservationResultSet) DOM.mtd(m, new InsPreservationResultSet());
            insPreservationResultSetService.insertOrUpdate(is);
        }

        int result = 1;

        return result;

    }

    /**
     * <b> 退保生成批改记录 </b>
     * @author ZXF
     * @create 2023/09/04 0004 11:20
     * @version
     * @注意事项 </b>
     */
    @Override
    public R saveSurrenderRecord(SurrenderVo surrenderVo, OrderFormVo vo, HttpServletRequest request) {
        //初始化退保批改单
        List<InsPreservationDetail> details = dao2.findZBPer(vo.getOid());
        com.bcxin.ins.util.IdWorker idWorker = new com.bcxin.ins.util.IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
        Date t = new Date();
        InsPreservationRecord ipr = new InsPreservationRecord();
        ipr.setInception_date(DateUtil.parseDate(surrenderVo.getInception_date()));
        ipr.setStart_time(t);
        ipr.setIns_insurance_slip_id(Long.parseLong(vo.getOid()));
        ipr.setRevise_serial_number(String.valueOf(idWorker.nextId()));
        ipr.setRevise_status(DictConst.REVISE_STATUS_SPZ);
        ipr.setRevise_type(DictConst.REVISE_TYPE_J);
        ipr.setAdd_count(0);
        ipr.setMinus_count(details.size());
        ipr.setReplace_count(0);
        ipr.setApp_role_name(vo.getApplicant_name());
        ipr.setPlanned_end_date(DateUtil.convertStringToDate(vo.getPlanned_end_date()));
        ipr.setExternal_reference(vo.getExternal_reference());
        ipr.setSys_client_user_id(Long.parseLong(vo.getUser_oid()));
        ipr.setSys_ins_company_id(Long.parseLong(vo.getInsurance_oid()));
        ipr.setTotal_premium(new BigDecimal(surrenderVo.getPremium()));
        ipr.setRemark("退保批减操作");
        dao.insert(ipr);
        for (InsPreservationDetail detail:details) {
            detail.setIns_preservation_record_id(ipr.getIns_preservation_record_id());
            detail.setRevise_time(t);
            detail.setRevise_type(DictConst.REVISE_TYPE_J);
            detail.setBusiness_type(ConstProp.PRESERVE);
            detail.setStatus(0);
            dao2.insert(detail);
        }
        //设置状态
        Map<Object, Object> p = Maps.newHashMap();
        p.put("record_id",ipr.getIns_preservation_record_id());
        p.put("inception_date",ipr.getInception_date());
        p.put("total_premium",ipr.getTotal_premium());
        p.put("revise_status","4");
        p.put("revise_serial_num_ins",ipr.getExternal_reference()+"TB");
        p.put("sup_id","sup_admin");
        return updataReviseStatus(p, request);
    }

    /**
     * <b>
     *     该方法用来替换上个方法（saveResultSetByRecord）
     *     主要改变了结果集的生成：上个方法作用是创建一个新的结果集用来做下次保全的数据源
     *     当前方法是固定同一个结果集，数据只增不减如果碰到减员或替换只是改变状态，前台做保全都是拿这份结果集数据
     * </b>
     * @param record_id 保全单id
     * @param revise_type 保全类型
     * @author ZXF
     * @create 2018/05/31 0031 14:00
     * @version
     * @注意事项 </b>
     */
    @Override
    public R pushResultSetByRecord(Long record_id, String revise_type) {
        try {
            int status = 0;//0 有效人员 1  失效人员
            Date date = new Date();
            Map<Object, Object> params = Maps.newHashMap();
            params.put("id", record_id);
            params.put("exclude", "2");//排除状态等于2的条目
            List<Map<Object, Object>> l = dao2.queryDetail(params);//查询出该保全的保全人员列表
            InsPreservationRecordVo recordVo = dao.findInsPreservationRecordVoById(record_id);
            List<InsPreservationResultSet> l2 = Lists.newArrayList();//要新增的人员
            List<Long> b1 = Lists.newArrayList();//做减员的id
            if("1".equals(revise_type)){
                for (Map<Object, Object> m : l) {//新增的人员
                    InsPreservationResultSet iprs = (InsPreservationResultSet) DOM.mtd(m, new InsPreservationResultSet());
                    iprs.setIns_preservation_result_set_id(IdWorker.getId());
                    iprs.setRevise_time(date);
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(Long.parseLong(recordVo.getIns_insurance_slip_id()));
                    iprs.setBelong_to_type(ConstProp.PRESERVE);//更新Belong类型
                    l2.add(iprs);
                }
            }else if("2".equals(revise_type)){//减员
                for (Map<Object, Object> m : l) {//减员的人员
                    b1.add((Long)m.get("belong_to_id"));
                }
            }else if("3".equals(revise_type)){//替换
                for (Map<Object, Object> m : l) {//替换的人员
                    InsPreservationResultSet iprs = (InsPreservationResultSet) DOM.mtd(m, new InsPreservationResultSet());
                    iprs.setIns_preservation_result_set_id(IdWorker.getId());
                    iprs.setRevise_time(date);
                    iprs.setStatus(status);
                    iprs.setIns_insurance_slip_id(Long.parseLong(recordVo.getIns_insurance_slip_id()));
                    iprs.setBelong_to_type(ConstProp.PRESERVE);//更新Belong类型
                    iprs.setBelong_to_id(null);
                    l2.add(iprs);
                    b1.add((Long)m.get("belong_to_id"));
                }
            }

            if(l2.size()>0) {//增员人员批量插入
                dao.batchInsert(l2);
            }
            if(b1.size()>0) {//减员状态批量变更
                Long[] longs = new Long[b1.size()];
                Long[] _l = b1.toArray(longs);
                int count = dao.batchUpdateStatus(_l, 1,revise_type, DateUtil.getCurrentDate_1());
                if (count==0) {
                    TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                    return new R(false, "不完全保存，请求失败");
                }
            }

            //更新release时间  逻辑先找结果集再更新
            return saveTime(record_id);
        }catch (NullPointerException nup){
            log.error("保全结果集处理，事务发现异常，回滚数据", nup);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "生成结果集失败,空字符");
        } catch(Exception e) {
            log.error("保全结果集处理，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "生成结果集失败");
        }

    }

    /*更新时间*/
    @Override
    public R saveTime(Long record_id){
        Date date = new Date();
        InsPreservationRecordVo recordVo = accordingToApplyIDToGetpreservationRecordVo(record_id);
        SimpleDateFormat sdf = new SimpleDateFormat();
        String strDate = sdf.format(date);
        recordVo.setRelease_time(strDate);
        if (updateReleaseTime(recordVo) <= 0) return new R(false, "更新时间失败");
        return new R(true, "保存成功");
    }

    /**
     * <b> 获取电子批单 </b>
     * @author ZXF
     * @create 2020/11/13 0013 9:30
     * @version
     * @注意事项 </b>
     */
    @Override
    public R getDZPD(Long record_id){
        Map<String,Object> m1 = Maps.newHashMap();
        m1.put("method_name","getDZPD");
        m1.put("param_value_arr",String.valueOf(record_id));
        m1.put("class_name","com.bcxin.ins.service.preservation.InsPreservationRecordAPIService");
        List<ComTaskResidual> list = comTaskResidualService.selectByMap(m1);
        if(list.size()>0){
            return new R(false, "请勿重复提交申请");
        }
        comTaskResidualService.saveComTaskResidual("getDZPD","重新访问平安接口获取电子批单","com.bcxin.ins.service.preservation.InsPreservationRecordAPIService",1,"Long",String.valueOf(record_id));
        return new R(true, "已提交电子批单申请，一小时后完成批单补录");
    }

    /**
     * 将原在保人员从resultSet表更新
     */
    @Override
    public List<InsPreservationResultSet> findResultSetVoByRecordID(Long record_id) {
        return dao.findResultSetVoByRecordID(record_id);
    }


    /**
     * 将原在保人员从slip表加入数据库
     */
//    public R saveOldPerson(List<InsRoleInpolicy> list1, Long record_id, int status, String type,List<Map<Object, Object>> list2) {
//        List<InsPreservationResultSet> list = Lists.newArrayList();
//        InsPreservationResultSet iprs = null;
//        OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(list1.get(0).getInsurance_slip().getIns_insurance_slip_id());
//        Date revise_time = DateUtil.convertStringToDate(orderVo.getInception_date());
//        String type1= type;
//        for (InsRoleInpolicy role : list1) {
//            status=ConstProp.INT_NUMBER_ZERO;
//            type1= "1";
//            if (ConstProp.DIGIT_TWO.equals(role.getKind())) {
//                long id1= role.getIns_role_inpolicy_id();
//                String name =role.getName_cn();
//                if(!ConstProp.DIGIT_ONE.equals(type)) {
//                    for (Map<Object, Object> m : list2) {//找出相同的名字跟ID的直接直接变为1，有删除操作不需要新增，所以只要找到人，然后改之前的resultSet的内容就行
//                        InsPreservationResultSet insPreservationResultSet = (InsPreservationResultSet) DOM.mtd(m, new InsPreservationResultSet());
//                        String name2 = insPreservationResultSet.getName();
//                        long id2 = insPreservationResultSet.getBelong_to_id();
//                        if (id2 > 0) {
//                            if (id1 == id2) {
//                                status = ConstProp.INT_NUMBER_ONE;//将belongid和原保险单的id一样的话 状态变为1.
//                                type1 = type;
//                                revise_time=new Date();
//                            }
//                        }
//                    }
//                }
//                iprs = new InsPreservationResultSet();
//                iprs.setName(role.getName_cn());
//                iprs.setStatus(status);
//                iprs.setIns_preservation_record_id(record_id);
//                iprs.setId_card(role.getOrganization_code());
//                iprs.setId_type(role.getId_type());
//                iprs.setBelong_to_id(role.getIns_role_inpolicy_id());
//                iprs.setBelong_to_type(ConstProp.ROLE);
//                iprs.setBirthday(role.getBirth_date());
//                iprs.setSex(role.getSex());
//                iprs.setTel(role.getMobile());
//                iprs.setRevise_type(type1);
//                iprs.setRevise_time(revise_time);
//                iprs.setCareer(role.getMajor_group());
//                list.add(iprs);
//            }
//        }
//
//        boolean rs = insPreservationResultSetService.insertOrUpdateBatch(list);
//        if (!rs) {
//            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
//            return new R(false, "不完全保存，请求失败");
//        } else {
//
//            return new R(true, "保存成功，请求成功");
//        }
//
//    }

    /*
    * 根据保全详情人员id查询
    * */
    @Override
    public InsPreservationDetailVo accordingToDetailIDToGetpreservationDetailVo(Long detail_id) {
        List<InsPreservationDetailVo> listVo = dao2.findDetailFormVoByID(detail_id);
        if (listVo != null) {
            InsPreservationDetailVo vo = listVo.get(0);

            return vo;
        }
        return null;
    }

    /**
     * <b> 修改批单状态 </b>
     * @param p 包含页面批单变更条件
     * @author ZXF
     * @create 2020/09/11 0011 13:32
     * @version
     * @注意事项 </b>
     */
    @Override
    public R updataReviseStatus(Map<Object, Object> p, HttpServletRequest request) {
        try {
            Long record_id = Long.valueOf(String.valueOf(p.get("record_id")));
            String inception_date = String.valueOf(p.get("inception_date"));
            String  total_premium = String.valueOf(p.get("total_premium"));
            String revise_status = String.valueOf(p.get("revise_status"));
            String revise_serial_num_ins = p.get("revise_serial_num_ins")!=null?String.valueOf(p.get("revise_serial_num_ins")):"";
            String sup_id=String.valueOf(p.get("sup_id"));

            InsPreservationRecordVo recordVo = accordingToApplyIDToGetpreservationRecordVo(record_id);

            if (DictConst.REVISE_STATUS_BTG.equals(revise_status)) {
                reviseStatus3Set(request, revise_status, sup_id, recordVo);
            } else if (DictConst.REVISE_STATUS_TG.equals(revise_status)&&StringUtils.isNotEmpty(total_premium)){
                //如果查出来没有批单号，后台页面有传批单号，就设置到recordVo 对象，下面步骤更新入库
                if(StringUtils.isEmpty(recordVo.getRevise_serial_num_ins())&&StringUtils.isNotEmpty(revise_serial_num_ins)){
                    recordVo.setRevise_serial_num_ins(revise_serial_num_ins);
                }
                reviseStatus4Set(request, inception_date, total_premium, revise_status, sup_id, recordVo);
            }else{
                return reviseStatusOtherReturn(total_premium);
            }
            if (updateRecordStatus(recordVo) <= 0) {
                return new R(false, "更新状态失败");
            }
            if (DictConst.REVISE_STATUS_BTG.equals(recordVo.getRevise_status())) {
                sendEmailAndTelByRecord(record_id,recordVo.getRevise_status());//保全申请审核退回邮件手机发送信息
            }
            if (DictConst.REVISE_STATUS_TG.equals(revise_status)) {//审核成功
                reviseStatus3Update(record_id, revise_status);
            }
            return new R(true, "修改成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "审核操作失败");
        }
    }

    /**
     * <b> 长安批单通过修改批单状态 </b>
     * @author ZXF
     * @create 2020/09/11 0011 13:32
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result updataCAReviseStatus(String recordId, String reviseStatus, String remark, String reviseSerialNumIns, String revisePath, HttpServletRequest request) {
        try {
            if(StringUtils.isEmpty(recordId)||StringUtils.isEmpty(reviseStatus)){
                return Result.fail("批单信息丢失");
            }
            if(!DictConst.REVISE_STATUS_BTG.equals(reviseStatus)&&!DictConst.REVISE_STATUS_TG.equals(reviseStatus)){
                return Result.fail("批单状态无效");
            }
            InsPreservationRecordVo recordVo = accordingToApplyIDToGetpreservationRecordVo(Long.parseLong(recordId));
            if(recordVo == null){
                return Result.fail("未匹配到有效批单");
            }
            String sup_id="CA-Endorsement-Opinion";
            String inception_date = recordVo.getInception_date();
            String  total_premium = recordVo.getTotal_premium();
            if (DictConst.REVISE_STATUS_BTG.equals(reviseStatus)) {
                reviseStatus3Set(request, reviseStatus, sup_id, recordVo);
            } else {
                reviseStatus4Set(request, inception_date, total_premium, reviseStatus, sup_id, recordVo);
            }
            if(StringUtils.isNotEmpty(remark)){
                recordVo.setRemark(remark);
            }
            if(StringUtils.isNotEmpty(reviseSerialNumIns)){
                recordVo.setRevise_serial_num_ins(reviseSerialNumIns);
            }
            if(StringUtils.isNotEmpty(revisePath)){
                recordVo.setRevise_path(revisePath);
            }
            if (updateRecordStatus(recordVo) <= 0) {
                return Result.fail("更新状态失败");
            }
            if (DictConst.REVISE_STATUS_BTG.equals(reviseStatus)) {
                sendEmailAndTelByRecord(Long.parseLong(recordId),reviseStatus);//保全申请审核退回邮件手机发送信息
            }
            if (DictConst.REVISE_STATUS_TG.equals(reviseStatus)) {//审核成功
                reviseStatus4UpdateCA(Long.parseLong(recordId), reviseStatus);
            }

            return Result.success("修改成功");
        } catch (Exception e) {
            log.error("长安批单通过修改批单状态，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return Result.fail("审核操作失败");
        }
    }

    private void reviseStatus4UpdateCA(Long record_id, String revise_status) {
        int paymentPeriod = dao.findPaymentPeriod(record_id);
        InsPreservationRecord record = selectById(record_id);
        //累计支付订单
        Long pay_id=dao.selectHavePayID(record_id);
        if (paymentPeriod != 1 && pay_id !=null) {
            //查找同一个订单有没有payid,有的话查询处理设置到record去
            record.setIns_preservation_pay_id(pay_id);
            setResult(record, paymentPeriod, false);
            updateById(record);
        }else{
            setResult(record, paymentPeriod, true);
        }
        OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(record.getIns_insurance_slip_id());
        if(order!=null && order.getProduct_code().contains(ConstProp.GZZRX_CA)){
            //人员生成结果集业务
            pushResultSetByRecord(record.getIns_preservation_record_id(),record.getRevise_type());
        }
        if(order!=null && !order.getWeb_type().contains("BLB")){
            comTaskResidualService.saveComTaskResidual("pushRecordInfo","保全申请审核通过后推送第三方","com.bcxin.ins.service.order.PolicyService",1,"String",String.valueOf(record_id));
        }
        if(!ConstProp.DIGIT_ONE.equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {//是否关闭批单同步业支 1：是，0：否
            comTaskResidualService.saveComTaskResidual("recordSyncZC", "保全申请审核通过后推送业务支撑", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        sendEmailAndTelByRecord(record_id,revise_status);//保全申请审核通过邮件手机发送信息
    }

    /**
     * <b> 保全详情-> 审核成功 批单数据更新并插入或更新缴费记录 </b>
     * @author ZXF
     * @create 2020/09/11 0011 16:54
     * @version
     * @注意事项 </b>
     */
    private void reviseStatus3Update(Long record_id, String revise_status) {
        int paymentPeriod = dao.findPaymentPeriod(record_id);
        InsPreservationRecord record = selectById(record_id);
        //累计支付订单
        Long pay_id=dao.selectHavePayID(record_id);
        if (paymentPeriod != 1 && pay_id !=null) {
            //查找同一个订单有没有payid,有的话查询处理设置到record去
            record.setIns_preservation_pay_id(pay_id);
            setResult(record, paymentPeriod, false);
            updateById(record);
        }else{
            setResult(record, paymentPeriod, true);
        }
        OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(record.getIns_insurance_slip_id());
//        if(order!=null && order.getProduct_code().contains(ConstProp.GZZRX_CA)){
//            //人员生成结果集业务
//            pushResultSetByRecord(record.getIns_preservation_record_id(),record.getRevise_type());
//        }
        if(order!=null && !order.getWeb_type().contains("BLB")){
            comTaskResidualService.saveComTaskResidual("pushRecordInfo","保全申请审核通过后推送第三方","com.bcxin.ins.service.order.PolicyService",1,"String",String.valueOf(record_id));
        }
        if(!ConstProp.DIGIT_ONE.equals(GlobalResources.IS_CLOSE_RECORD_SYNC)) {//是否关闭批单同步业支 1：是，0：否
            /*new Thread(()->{
                if("1".equals(GlobalResources.map.get("IS_SEND_SHOP"))){
                    //添加推送批单信息给到商城
                    comTaskResidualService.saveComTaskResidual("createSendOrderTask","保险订单推送商城初始化","com.bcxin.ins.service.order.PolicyService",3,"Long,int,String", record_id+",1,");
                }
            }).start();*/
            comTaskResidualService.saveComTaskResidual("recordSyncZC", "保全申请审核通过后推送业务支撑", "com.bcxin.ins.service.order.PolicyService", 1, "String", String.valueOf(record_id));
        }
        sendEmailAndTelByRecord(record_id,revise_status);//保全申请审核通过邮件手机发送信息
    }

    /**
     * <b> 保全详情-> 其它状态情况下直接返回</b>
     * @author ZXF
     * @create 2020/09/11 0011 16:45
     * @version
     * @注意事项 </b>
     */
    private R reviseStatusOtherReturn(String total_premium) {
        if (StringUtils.isEmpty(total_premium)) {
            return new R(false, "审核操作失败,请核对是否填入保全费用");
        }
        return new R(false, "审核操作失败,请核对是否上传处理单");
    }

    /**
     * <b> 保全详情-> 审核成功  业务设置</b>
     * @author ZXF
     * @create 2020/09/11 0011 16:45
     * @version
     * @注意事项 </b>
     */
    private void reviseStatus4Set(HttpServletRequest request, String inception_date, String total_premium, String revise_status, String sup_id, InsPreservationRecordVo recordVo) {
        insuranceOperationService.creatLog(request, "保全详情-> 审核成功" , null, sup_id);
        recordVo.setRevise_status(revise_status);//4.已审核
        recordVo.setInception_date(inception_date);
        recordVo.setTotal_premium(total_premium);
        recordVo.setUpdate_time(DateUtil.getCurrentDateTime());
    }

    /**
     * <b> 保全详情-> 审核退回 业务设置 </b>
     * @author ZXF
     * @create 2020/09/11 0011 16:44
     * @version
     * @注意事项 </b>
     */
    private void reviseStatus3Set(HttpServletRequest request, String revise_status, String sup_id, InsPreservationRecordVo recordVo) {
        insuranceOperationService.creatLog(request, "保全详情-> 审核退回" , null, sup_id);
        recordVo.setRevise_status(revise_status);//3 审核退回
    }

    @Override
    public List<InsPreservationRecordVo> listInsPreservationRecordVoByTranNo(String tran_no){
        return dao.listInsPreservationRecordVoByTranNo(tran_no);
    }

    /**
     * 保全申请-审核退回 发送邮件
     * 发送方：系统（bot）
     * 接收方：投保人
     *
     * @param recordId 保全申请单id
     * @param status 审批状态
     */
    private void sendEmailAndTelByRecord(Long recordId,String status) {
        InsPreservationRecordVo recordVo = dao.findInsPreservationRecordVoById(recordId);
        OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(recordVo.getIns_insurance_slip_id()));
        List<InsRoleInpolicy> iriList = insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(Long.parseLong(recordVo.getIns_insurance_slip_id()), "1");
        String email = ConstProp.BLANK_CHAR;
        String tel = ConstProp.BLANK_CHAR;
        if(iriList.size()>0){
            email = iriList.get(0).getLink_email();
            tel = iriList.get(0).getLink_tel();
        }
        String reviseType = DictConst.REVISE_TYPE_Z.equals(recordVo.getRevise_type())? "增员"
                : DictConst.REVISE_TYPE_J.equals(recordVo.getRevise_type())? "减员"
                : DictConst.REVISE_TYPE_T.equals(recordVo.getRevise_type())? "替换"
                : "";
        String personNum = DictConst.REVISE_TYPE_Z.equals(recordVo.getRevise_type())? recordVo.getAdd_count()
                : DictConst.REVISE_TYPE_J.equals(recordVo.getRevise_type())? recordVo.getMinus_count()
                : DictConst.REVISE_TYPE_T.equals(recordVo.getRevise_type())? recordVo.getReplace_count()
                : "";
        if(StringUtils.isNotBlank(email)){
            recordSendEmail(status, recordVo, orderVo, email, reviseType, personNum);
        }
        if(StringUtils.isNotBlank(tel)){
            recordSendSMS(status, recordVo, tel, reviseType, personNum);
        }
    }

    /**
     * <b> 批单结果发送短信 </b>
     * @author ZXF
     * @create 2020/09/11 0011 17:01
     * @version
     * @注意事项 </b>
     */
    private void recordSendSMS(String status, InsPreservationRecordVo recordVo, String tel, String reviseType, String personNum) {
        String content = ConstProp.BLANK_CHAR;
        if(ConstProp.DIGIT_THREE.equals(status)){//审核退回
            content = new MessageModel(recordVo.getStart_time()
                    ,reviseType
                    ,personNum
                    ,recordVo.getRevise_serial_number()
                    ,ConstProp.BLANK_CHAR
                    , EmailMsgType.BQTH).getContent();
            log.info("保全申请审核退回短信发送（内容htmlContent）:"+content);
            //华为短信发送
            mss.sendHuaWeiSMS(new HuaWeiSmsContent(
                    ConstProp.SMSPLATFORM_BLB,
                    ConstProp.SMSCODE_B7,
                    tel,
                    JSON.toJSONString(new String[]{recordVo.getStart_time()
                            ,reviseType
                            ,personNum
                            ,recordVo.getRevise_serial_number()})));
        }else if(ConstProp.DIGIT_FOUR.equals(status)){//审核通过（由于提交频繁关闭短信业务）
//                content = new MessageModel(recordVo.getStart_time()
//                        ,reviseType
//                        ,personNum
//                        ,recordVo.getRevise_serial_number()
//                        ,recordVo.getInception_date()
//                        , EmailMsgType.BQTG).getContent();
//                log.info("保全申请审核通过短信发送（内容htmlContent）:"+content);
//                //华为短信发送
//                SMSUtil.sendHuaWeiSMS(new HuaWeiSmsContent(
//                        ConstProp.SMSPLATFORM_BLB,
//                        ConstProp.SMSCODE_B8,
//                        tel,
//                        JSON.toJSONString(new String[]{recordVo.getStart_time()
//                                ,reviseType
//                                ,personNum
//                                ,recordVo.getRevise_serial_number()
//                                ,recordVo.getInception_date()})));
        }
        log.info("保全申请短信发送（收件人Modle-1）:"+tel);
//            sendModleMessage("blb", content, tel);
    }

    /**
     * <b> 批单结果发送邮件 </b>
     * @author ZXF
     * @create 2020/09/11 0011 17:00
     * @version
     * @注意事项 </b>
     */
    private void recordSendEmail(String status, InsPreservationRecordVo recordVo, OrderFormVo orderVo, String email, String reviseType, String personNum) {
        EmailMsgRecordType emr = null;
        if(ConstProp.DIGIT_THREE.equals(status)){//审核退回
            emr = EmailMsgRecordType.RECORD_SEND_BACK;
        }else if(ConstProp.DIGIT_FOUR.equals(status)){//审核通过
            emr = EmailMsgRecordType.RECORD_CHECKED;
        }
        EmailModel emailModel = new EmailModel(emr, recordVo.getStart_time(), reviseType, personNum, orderVo.getTrade_serial_number(), orderVo.getExternal_reference(), recordVo.getRevise_serial_number());
        log.info(emr.getName()+"邮件发送（内容htmlContent）:"+emailModel.getContent());
        List<String> emailList = new ArrayList<String>();
        emailList.add(email.trim());
        log.info(emr.getName()+"邮件发送（收件人Email-1）:"+email);
        emailModel.setTo(emailList);
        SendEmailAndMsgUtil.sendEmail(emailModel);
    }

    /**
     * 保全缴费-待处理/代缴费 发送邮件
     * 待处理:
     * 发送方：系统（bot）
     * 接收方：运营人员
     * 代缴费:
     * 发送方：系统（bot）
     * 接收方：投保人
     *
     * @param payId 保全缴费id
     */
    private void sendEmailAndTelByPay(Long payId) {
        InsPreservationPay ipPay = insPreservationPayService.selectById(payId);
        if(ipPay.getIns_insurance_slip_id() != null){
            OrderFormVo orderVo = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(ipPay.getIns_insurance_slip_id());
            String status = ipPay.getPay_status();
            if(DictConst.RECORD_PAY_STATUS_DCL.equals(status)){
                status0Email(ipPay, orderVo);
            }else if(DictConst.RECORD_PAY_STATUS_DZF.equals(status)){
                status1SMS(ipPay, orderVo);
            }
        }
    }

    /**
     * <b> 待支付 短信 投保人 </b>
     * @author ZXF
     * @create 2020/09/11 0011 14:27
     * @version
     * @注意事项 </b>
     */
    private void status1SMS(InsPreservationPay ipPay, OrderFormVo orderVo) {
        List<InsRoleInpolicy> iriList = insRoleInpolicyService.getInsRoleInpolicyListByIDAndKind(ipPay.getIns_insurance_slip_id(), "1");
        String tel = iriList.size()>0?iriList.get(0).getLink_tel():ConstProp.BLANK_CHAR;
        if(StringUtils.isNotBlank(tel)){
            String content = "尊敬的用户，您于["+ DateUtil.convertDateToString(ipPay.getStar_pay_time(),DateUtil.FORMAT2)+"]至["+DateUtil.convertDateToString(ipPay.getEnd_pay_time(),DateUtil.FORMAT2)+"]在保险平台的保全缴费单已生成。保全费用共：["+ipPay.getFact_total_amount()+"]元。请及时处理，以免影响您的后续保障。【百联保】";
            log.info("保全缴费待支付短信发送（内容htmlContent）:"+content);
            log.info("保全缴费待支付短信发送（收件人Modle-1）:"+tel);
            //华为短信发送
            mss.sendHuaWeiSMS(new HuaWeiSmsContent(
                    ConstProp.SMSPLATFORM_BLB,
                    ConstProp.SMSCODE_B9,
                    tel,
                    JSON.toJSONString(new String[]{DateUtil.convertDateToString(ipPay.getStar_pay_time(),DateUtil.FORMAT2)
                            ,DateUtil.convertDateToString(ipPay.getEnd_pay_time(),DateUtil.FORMAT2)
                            ,String.valueOf(ipPay.getFact_total_amount())})));
        }
        //如果是saas过来的用户产生的缴费单就请求saas接口发送消息
        if(StringUtils.isNotEmpty(orderVo.getWeb_id())&&StringUtils.isNotEmpty(orderVo.getWeb_type())&&orderVo.getWeb_type().contains("SAAS")){
            sendPayMessageBySAAS(orderVo.getWeb_type(),orderVo.getWeb_id());
        }
    }

    /**
     * <b> 待处理 邮件，运营人员 </b>
     * @author ZXF
     * @create 2020/09/11 0011 14:23
     * @version
     * @注意事项 </b>
     */
    private void status0Email(InsPreservationPay ipPay, OrderFormVo orderVo) {
        String[] arrs = comDeployConfigService.getValueByKey("exmail").split(ConstProp.SEMICOLON);
        EmailModel emailModel = new EmailModel(EmailMsgRecordType.PAY_PENDING, ipPay.getExternal_reference(), DateUtil.convertDateToString(ipPay.getStar_pay_time(),DateUtil.FORMAT2), DateUtil.convertDateToString(ipPay.getEnd_pay_time(),DateUtil.FORMAT2), orderVo.getInsurance_name());
        log.info("保全缴费待处理邮件发送（内容htmlContent）:"+emailModel.getContent());
        List<String> emailList = new ArrayList<String>();
        for(int i=0;i<arrs.length;i++){
            if(StringUtils.isNotBlank(arrs[i]) && !arrs[i].contains(ConstProp.COLON)){
                // 发送地址
                emailList.add(arrs[i].trim());
                log.info("保全缴费待处理邮件发送（收件人Email-"+(i+1)+"）:"+arrs[i]);
            }
        }
        if(emailList.size()>0){
            emailModel.setTo(emailList);
            SendEmailAndMsgUtil.sendEmail(emailModel);
        }
    }

    /**
     * <b> saas过来的用户产生的缴费单就请求saas接口发送消息 </b>
     * @author ZXF
     * @create 2019/05/21 0021 16:24
     * @version
     * @注意事项 </b>
     */
    private void sendPayMessageBySAAS(String type,String comId) {
        String url = comDeployConfigService.getValueByKey("PATH-"+type)+"/enterprise/blb-api-controller/send-ins-unpaid-msg";
        Map<String, String> data = new HashMap<String, String>();
        data.put("comId", comId);
        myAsyncExecutor.execute(()->{
            try {
                RestUtil.restful(url,data);
            } catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private boolean sendModleMessage(String type, String content, String mobile) {
        String url="http://msg.bcxin.com.cn:9165/sms/sendMessage";
        String  key ="bcxinABCXIN$1012 "; //key
        //PSS  -pss   百宝盾 - ars    百联宝 blb
        String requestId=System.currentTimeMillis()+"";// 开始时间
        JSONObject json= new JSONObject();
        json.put("type",type);
        json.put("content",content);//内容
        json.put("mobile",mobile);//手机号码
        json.put("requestId",requestId);
        json.put("token", MD5Util.string2MD5(requestId+type+key));//秘钥
        try {
            String ret = RequestUtil.initHttp().doPost(url, json.toString(), ConstProp.CT_JSON, ConstProp.ENCODE_UTF8);
            JSONObject  retJson =JSONObject.parseObject(ret);
            if(retJson.get("status").equals(ConstProp.CODE_SUCCESS)){
                return true;
            }
        }catch (Exception ex){

        }
        return false;
    }

    /**
     * 统计多保全申请单人员及统计保险费用，设置到保全缴费单中
     *
     * @param record        保全申请单
     * @param paymentPeriod 缴费
     */
    private R setResult(InsPreservationRecord record, int paymentPeriod, boolean isFrist) {
        try {
            InsPreservationPay ipPay;
            //如果增员在线支付直接生成支付记录
            if(DictConst.REVISE_TYPE_Z.equals(record.getRevise_type())
                    &&DictConst.REVISE_STATUS_TG.equals(record.getRevise_status())
                    &&StringUtils.isNotEmpty(record.getRevise_pay())){
                ipPay = new InsPreservationPay();
                com.bcxin.ins.util.IdWorker idWorker = new com.bcxin.ins.util.IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
                ipPay.setSys_client_user_id(record.getSys_client_user_id());
                ipPay.setSys_ins_company_id(record.getSys_ins_company_id());
                ipPay.setIns_insurance_slip_id(record.getIns_insurance_slip_id());
                ipPay.setExternal_reference(record.getExternal_reference());
                ipPay.setApp_role_name(record.getApp_role_name());
                ipPay.setIns_preservation_pay_id(idWorker.nextId());
                ipPay.setStar_pay_time(record.getStart_time());
                ipPay.setEnd_pay_time(new Date());
                ipPay.setPay_status(DictConst.RECORD_PAY_STATUS_YZF);
                ipPay.setRecord_count(1);
                ipPay.setAdd_count(record.getAdd_count());
                ipPay.setReplace_count(0);
                ipPay.setMinus_count(0);
                ipPay.setPredict_total_amount(record.getTotal_premium());
                ipPay.setPay_url(record.getRevise_pay());
            }else{
                Date star = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getFirstDayOfThisMonth(),DateUtil.FORMAT2)+" 00:00:00");
                Date end = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getLastDayOfThisMonth(),DateUtil.FORMAT2)+" 23:59:59");
                ipPay = insPreservationPayService.getPayExAndMonth(record.getExternal_reference(), star, end);
                int recordCount = 0;
                int addCount = 0;
                int minusCount = 0;
                int replaceCount = 0;
                String payStatus = DictConst.RECORD_PAY_STATUS_ZC;//支付状态先设置为 4 暂存单
                BigDecimal predictTotal = BigDecimal.ZERO;
                BigDecimal premium = record.getTotal_premium();

                if (ipPay == null) {  //第一单需要设置的数据
                    ipPay = new InsPreservationPay();
                    //第一单随机生成payid
                    ipPay.setIns_preservation_pay_id(IdWorker.getId());
                    ipPay.setSys_client_user_id(record.getSys_client_user_id());
                    ipPay.setSys_ins_company_id(record.getSys_ins_company_id());
                    ipPay.setIns_insurance_slip_id(record.getIns_insurance_slip_id());
                    ipPay.setExternal_reference(record.getExternal_reference());
                    ipPay.setApp_role_name(record.getApp_role_name());
                    Date date = new Date();
                    Date starPayTime = null;
                    Date endPayTime = null;
                    if (paymentPeriod == 1) {//逐单缴费
                        payStatus = DictConst.RECORD_PAY_STATUS_DCL;//逐单直接生成的订单为0 待处理
                        starPayTime = date;
                        endPayTime = DateUtil.getDayEnd(date);

                    } else if (paymentPeriod == 2) {//按月缴费
                        starPayTime = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getFirstDayOfThisMonth(),DateUtil.FORMAT2)+" 00:00:00");
                        endPayTime = DateUtil.convertString2Date(DateUtil.convertDateToString(DateUtil.getLastDayOfThisMonth(),DateUtil.FORMAT2)+" 23:59:59");
                    } else if (paymentPeriod == 3) {//按季度缴费
                        starPayTime = DateUtil.getFirstDayOfThisQuarter();
                        endPayTime = DateUtil.getLastDayOfThisQuarter();
                    } else {//按年缴费
                        starPayTime = DateUtil.convertString2Date(DateUtil.getThisYearThisDay()+" 00:00:00");
                        endPayTime=DateUtil.convertString2Date(DateUtil.getThisYearLastDay()+" 23:59:59");
                    }

                    ipPay.setStar_pay_time(starPayTime);
                    ipPay.setEnd_pay_time(endPayTime);
                }else {
                    recordCount= ipPay.getRecord_count();
                    addCount= ipPay.getAdd_count();
                    minusCount= ipPay.getMinus_count();
                    replaceCount += ipPay.getReplace_count();
                    predictTotal=ipPay.getPredict_total_amount();
                }

                predictTotal = predictTotal.add(premium);

                //每一单更新的数据

                //计算，每一单都要
                recordCount++;
                //增员人员统计
                addCount += record.getAdd_count();
                minusCount += record.getMinus_count();//减员人员统计
                replaceCount += record.getReplace_count();//替换人员统计
                //总金额累加
                ipPay.setPay_status(payStatus);
                ipPay.setRecord_count(recordCount);
                ipPay.setAdd_count(addCount);
                ipPay.setReplace_count(replaceCount);
                ipPay.setMinus_count(minusCount);
                ipPay.setPredict_total_amount(predictTotal);
            }
            if (!insPreservationPayService.insertOrUpdate(ipPay)) {
                TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
                return new R(false, "缴费订单操作失败");
            }

            record.setIns_preservation_pay_id(ipPay.getIns_preservation_pay_id());//将随机生成的payid设置到record中去
            //将Ins_preservation_pay_id更新到record中去
            updateById(record);
            if(DictConst.RECORD_PAY_STATUS_DCL.equals(ipPay.getPay_status())){//保全缴费单待处理
                sendEmailAndTelByPay(ipPay.getIns_preservation_pay_id());//保全缴费待处理发送邮件
            }
            return new R(true, "缴费订单操作成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "缴费订单操作失败");
        }
    }

    /*
    *
    * 审核不通过，填写理由，更新数据库内容
    *
    * */
    @Override
    public R statusUpd(Map<Object, Object> p, HttpServletRequest request) {
        try {
            Long detail_id = Long.valueOf(String.valueOf(p.get("detail_id")));
            String remark = String.valueOf(p.get("remark"));
            InsPreservationDetailVo detailVo = accordingToDetailIDToGetpreservationDetailVo(detail_id);
            //将不通过的理由设置进去
            detailVo.setRemark(remark);
            //状态改变，通过变为不通过，不通过变为通过
            detailVo.setStatus(String.valueOf(p.get("status")));
            if (updatedetailFormStatus(detailVo) <= 0) {
                return new R(false, "理由添加失败");
            }
            insuranceOperationService.creatLog(request, "保全详情->增减审核未通过" + detailVo.getName(), null, remark);
            return new R(true, "理由添加成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "理由添加操作失败");
        }
    }

    @Override
    public InsPreservationPayVo accordingToPayIDToGetpreservationPayVo(Long pay_id) {
        List<InsPreservationPayVo> listVo = dao.findPayFormVoByID(pay_id);
        if (listVo != null) {
            InsPreservationPayVo vo = listVo.get(0);

            return vo;
        }
        return null;
    }

    @Override
    public boolean accordingToApplyIDToGetStatus(Long detail_id) {
        int result = 0;
        result = dao2.queryStatus(detail_id);
        if (result == 0) {
            return false;
        } else {
            return true;
        }

    }

    /*
    * 更新支付状态
    * */
    @Override
    public R updataPayStatus(Map<Object, Object> p) {
        try {
            Long pay_id = Long.valueOf(String.valueOf(p.get("pay_id")));
            InsPreservationPayVo payVo = accordingToPayIDToGetpreservationPayVo(pay_id);
            String pay_status = String.valueOf(p.get("pay_status"));
            String pay_order_path = String.valueOf(p.get("pay_order_path"));
            if (DictConst.RECORD_PAY_STATUS_DZF.equals(pay_status)) {
                //if 提交
                String pay_inform_path = String.valueOf(p.get("pay_inform_path"));
                if (StringUtils.isEmpty(pay_inform_path)) {
                    return new R(false, "缴费通知单必须上传");
                }
                if (StringUtils.isNotEmpty(pay_order_path)) {
                    pay_status = DictConst.RECORD_PAY_STATUS_DSH;
                }
            }
            String isSummaryBill = payVo.getIs_part()==1?"0":"1";
            if (DictConst.RECORD_PAY_STATUS_YZF.equals(pay_status)) {
                //if 提交
                if (StringUtils.isEmpty(pay_order_path)) {
                    return new R(false, "缴费凭证必须上传");
                }
                String fact_total_amount = String.valueOf(p.get("fact_total_amount"));
                if (StringUtils.isNotEmpty(fact_total_amount)) {
                    payVo.setFact_total_amount(fact_total_amount);
                }
                if(!payVo.getPredict_total_amount().equals(payVo.getFact_total_amount())){
                    pay_status = DictConst.RECORD_PAY_STATUS_DSH;
                }
                int count = dao.isOtherChildBill(isSummaryBill,Long.parseLong(payVo.getOid()));
                if(count>0){
                    return new R(false, "存在未完成的部分账单请先完成结算");
                }
            }
            //else 确认支付
            payVo.setPay_status(pay_status);
            if (updatePayStatus(payVo) <= 0) {
                return new R(false, "提交失败");
            }
            if(ConstProp.DIGIT_THREE.equals(payVo.getPay_status())){
                //创建结算单
                InsPreservationPay footPay = dao.getFootPayByParentId(isSummaryBill,Long.parseLong(payVo.getOid()));
                com.bcxin.ins.util.IdWorker idWorker = new com.bcxin.ins.util.IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
                footPay.setIns_preservation_pay_id(idWorker.nextId());
                footPay.setFact_total_amount(new BigDecimal(payVo.getFact_total_amount()));
                footPay.setPay_order_path(payVo.getPay_order_path());
                footPay.setPay_inform_path(payVo.getPay_inform_path());
                footPay.setExternal_reference("JSD"+idWorker.nextId());
                insPreservationPayService.insertOrUpdate(footPay);
                //对需要结算的子账单进行标记
                dao.updateParentFootId(footPay.getIns_preservation_pay_id(),payVo.getPay_status(),footPay.getPay_list().split(","));
                //根据传入已结算的账单id更新存在归属关系的保全信息的结算状态为已结算
                dao.setRecordPayStatusByPayId(footPay.getPay_list().split(","));
                if(payVo.getIs_part()==1){
                    //如果市部分账单结算，涉及的子账单归属的原汇总账单需要检查下属子账单是否都已支付，如果都完成支付对应的汇总账单需要更新状态为已缴费，实缴金额为0，不需要生成结算单
                    dao.updateOverParentPay(footPay.getPay_list().split(","));
                }
            }
            if(StringUtils.isNotEmpty(payVo.getIns_insurance_slip_id())){
                OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(payVo.getIns_insurance_slip_id()));
                if(order!=null && order.getProduct_code().contains(ConstProp.GZZRX_CA)&& DictConst.RECORD_PAY_STATUS_YZF.equals(payVo.getPay_status())){
                    //完成月结算后查询电子发票（长安雇主）
                    comTaskResidualService.saveComTaskResidual("getFPTask","长安雇主险批单月结后查询电子发票","com.bcxin.ins.service.preservation.InsPreservationPayAPIService",1,"Long",String.valueOf(pay_id));
                }
                if(order!=null && order.getProduct_code().contains(ConstProp.TYX_CA)&& DictConst.RECORD_PAY_STATUS_YZF.equals(payVo.getPay_status())){
                    //完成月结算后查询电子发票（长安团意）
                    comTaskResidualService.saveComTaskResidual("getFPTask","长安团意险批单月结后查询电子发票","com.bcxin.ins.service.preservation.InsPreservationPayAPIService",1,"Long",String.valueOf(pay_id));
                }
            }
            if(DictConst.RECORD_PAY_STATUS_DZF.equals(payVo.getPay_status())){
                //保全缴费单待缴费
                //保全缴费待缴费发送手机短信
                sendEmailAndTelByPay(Long.parseLong(payVo.getOid()));
            }
            return new R(true, "提交成功");
        } catch (Exception e) {
            log.error("更新缴费状态，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "提交操作失败");
        }
    }

    /**
     * <b> 缴费记录状态变更为已支付，结束缴费流程 </b>
     * 长安雇主生成获取月结电子发票查询任务
     * @author ZXF
     * @create 2021/11/12 0012 14:31
     * @version
     * @注意事项 </b>
     */
    @Override
    public R overPay(Map<Object, Object> p) {
        try {
            Long pay_id = Long.valueOf(String.valueOf(p.get("pay_id")));
            InsPreservationPayVo payVo = accordingToPayIDToGetpreservationPayVo(pay_id);
            payVo.setFact_total_amount(payVo.getPredict_total_amount());
            payVo.setPay_status(DictConst.RECORD_PAY_STATUS_YZF);

            if (updatePayStatus(payVo) <= 0) {
                return new R(false, "提交失败");
            }
            OrderFormVo order = insuranceOperationService.accordingToOrderIDToGetOrderFormVo(Long.parseLong(payVo.getIns_insurance_slip_id()));
            if(order!=null && order.getProduct_code().contains(ConstProp.GZZRX_CA)&& DictConst.RECORD_PAY_STATUS_YZF.equals(payVo.getPay_status())){
                //完成月结算后查询电子发票（长安雇主）
                comTaskResidualService.saveComTaskResidual("getFPTask","长安雇主险批单月结后查询电子发票","com.bcxin.ins.service.preservation.InsPreservationPayAPIService",1,"Long",String.valueOf(pay_id));
            }
            if(order!=null && order.getProduct_code().contains(ConstProp.TYX_CA)&& DictConst.RECORD_PAY_STATUS_YZF.equals(payVo.getPay_status())){
                //完成月结算后查询电子发票（长安团意险）
                comTaskResidualService.saveComTaskResidual("getFPTask","长安团意险批单月结后查询电子发票","com.bcxin.ins.service.preservation.InsPreservationPayAPIService",1,"Long",String.valueOf(pay_id));
            }
            if(DictConst.RECORD_PAY_STATUS_DZF.equals(payVo.getPay_status())){
                //保全缴费单待缴费
                //保全缴费待缴费发送手机短信
                sendEmailAndTelByPay(Long.parseLong(payVo.getOid()));
            }
            return new R(true, "提交成功");
        } catch (Exception e) {
            log.error("新增用户，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "提交操作失败");
        }
    }

    public int updatePayStatus(InsPreservationPayVo vo) {
        int result = dao.updatePayStatus(vo.getOid(), vo.getFact_total_amount(), vo.getPay_status());
        return result;
    }

    @Override
    public R findCheckPendingPreservationRecord(){
        try {
            String date = DateUtil.dateAdd(DateUtil.DATATYPE_DAY,DateUtil.getCurrentDate(),-2);
            List<Map> list = dao.findCheckPendingPreservationRecord(date+" 00:00:00");
            if(list.size() == 0){
                return new R(false, "暂无待办事项");
            }
            return new R(true, list);
        } catch (Exception e) {
            return new R(false, "异常信息："+e.getMessage());
        }
    }

    /**
     * <b> 根据订单id查询在保人员列表 </b>
     * @author ZXF
     * @create 2019/09/29 0029 15:48
     * @version
     * @注意事项 </b>
     */
    @Override
    public PageResult queryResultSet(Map<Object, Object> p) {
        return new PageResult(dao.queryResultSetCnt(p), dao.queryResultSet(p));
    }

    @Override
    public void downResultSet(Map<Object, Object> p, HttpServletResponse response) {
        String fileName = p.get("external_reference")+"-在保人员.xls";
        try {
            fileName = new String((fileName).getBytes("gb2312"), "ISO8859-1");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        com.bcxin.ins.util.excel.ExcelUtil<ResultSetExcelVo> util = new com.bcxin.ins.util.excel.ExcelUtil(ResultSetExcelVo.class);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition",
                "attachment;fileName=" + fileName);
        try(OutputStream os = response.getOutputStream();) {
            List<ResultSetExcelVo> voList = dao.queryResultSetVo(p);
            util.exportExcel(voList, p.get("external_reference")+"在保人员", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * <b> 退保操作时删除保全相关数据包括在保人员(逻辑删除) </b>
     * @author ZXF
     * @create 2020/01/10 0010 14:35
     * @version
     * @注意事项 </b>
     */
    @Override
    public void deletePresever(Long orderID) {
        //2.在保人员状态设置成1（不在保）
        dao.updateResultSetStatus(orderID);
        //3.检查是否存在已审批的保全单，有就设置失效并标记保全缴费记录为删除
        if(dao.recordCount(orderID)>0){
            //保全单设置失效
            dao.deleteRecord(orderID);
            //保全缴费设置失效
            dao.deletePay(orderID);
        }
    }

    /**
     * <b> 设置批单结算状态 </b>
     * @param p 包含页面批单变更条件
     * @author ZXF
     * @create 2020/09/11 0011 13:32
     * @version
     * @注意事项 </b>
     */
    @Override
    public R setPdNo(Map<Object, Object> p, HttpServletRequest request) {
        try {
            String pdNo = String.valueOf(p.get("pdNo"));
            if(StringUtils.isEmpty(pdNo)){
                return new R(false, "批单号不能为空");
            }
            String[] arr = pdNo.split(",");
            if(dao.setPdNo(arr)==0){
                return new R(false, "未匹配到有效记录");
            }
            return new R(true, "结算状态设置成功");
        } catch (Exception e) {
            log.error("设置批单结算状态，事务发现异常，回滚数据", e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(false, "设置批单结算状态操作失败");
        }
    }
}
