package com.bcxin.ins.models.apply.service.impl;

import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.entity.policy_core.InsBusinessPersonnel;
import com.bcxin.ins.models.apply.dao.InsBusinessPersonnelMapper;
import com.bcxin.ins.models.apply.service.InsBusinessPersonnelService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.poi.excel.ExcelReader;
import com.xiaoleilu.hutool.poi.excel.ExcelUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class InsBusinessPersonnelServiceImpl extends ServiceImpl<InsBusinessPersonnelMapper, InsBusinessPersonnel>
        implements InsBusinessPersonnelService {

    @Autowired
    private InsBusinessPersonnelMapper dao;

    @Override
    public R batchUploadInsPer( MultipartFile file) {
        List<Map<String, Object>> excellist;
        try (InputStream in = file.getInputStream()){
            /*读取excel，支持*/
            ExcelReader reader = ExcelUtil.getReader(in);
            reader.isIgnoreEmptyRow();
            /*从第三行开始读取，因为第三行为标题行*/
            excellist = reader.read(1, 2, 2147483647);
        }catch (Exception e){
            return new R(false, "Excel模板文件异常！");
        }
        /* 得到有效数据行并完成key、value的转换,初步校验数据 */
        excellist = screenValidData(excellist);
        if(excellist.size()==0){
            return new R(false, "Excel文件无有效数据！");
        }
        String[] oList = new String[excellist.size()];
        int i=0;
        Map<String,String> iMap = Maps.newHashMap();
        String pNo;
        for (Map<String, Object> map : excellist) {
            pNo = String.valueOf(map.get("policyNo"));
            if(StringUtils.isNotEmpty(iMap.get(pNo))){
                return new R(false, "Excel文件中 保单号："+pNo+" 存在重复记录！");
            }
            oList[i] = String.valueOf(map.get("policyNo"));
            iMap.put(pNo,String.valueOf(map.get("bpName")));
            i++;
        }
        List<Map<String, Object>> elist = Lists.newArrayList();
        if(oList.length>0){
            elist = dao.findOrdderId(oList);
        }
        InsBusinessPersonnel ibp;
        List<InsBusinessPersonnel> ibpList = Lists.newArrayList();
        IdWorker idWorker = new IdWorker(ConstProp.INT_NUMBER_WORKERID, ConstProp.INT_NUMBER_ZERO);
        if(elist.size()>0){
            // 清除已设置的业务人员
            dao.batchUpdateStatus(oList);
            //重新新增
            for (Map<String, Object> map : elist) {
                String orderId = String.valueOf(map.get("orderId"));
                if(StringUtils.isEmpty(orderId)&&"null".equals(orderId)){
                    continue;
                }
                ibp = new InsBusinessPersonnel();
                ibp.setIns_business_personnel_id(idWorker.nextId());
                ibp.setIns_insurance_slip_id(Long.parseLong(orderId));
                ibp.setBusiness_personnel_name(iMap.get(String.valueOf(map.get("policyNo"))));
                ibp.setExternal_reference(String.valueOf(map.get("policyNo")));
                ibp.setStatus(1);
                ibp.setCreate_time(new Date());
                ibpList.add(ibp);
            }
            dao.batchInsert(ibpList);
        }else {
            return new R(false, "无有效数据！");
        }
        return new R(false, "业务人员设置成功！");
    }

    /**
     * <b> 筛选组装有效数据 </b>
     * @author ZXF
     * @create 2020/01/15 0015 20:41
     * @version
     * @注意事项 </b>
     */
    private List<Map<String, Object>> screenValidData(List<Map<String, Object>> excellist){
        String[] keys = {"policyNo","bpName","isSuccess","errorMsg"};
        Map<String, Object> newMap = null;
        List<Map<String, Object>> mlist = Lists.newArrayList();
        int isNull;
        for(Map<String, Object> map : excellist){
            if(StringUtils.isEmpty(String.valueOf(map.get("保单号")))
                    &&StringUtils.isEmpty(String.valueOf(map.get("业务员")))){
                continue;
            }
            newMap = Maps.newHashMap();
            isNull = 0;
            for(Map.Entry<String, Object> entry : map.entrySet()){
                String val = String.valueOf(entry.getValue());
                switch (entry.getKey()) {
                    case "保单号":
                        newMap.put(keys[0],val);
                        break;
                    case "业务员":
                        newMap.put(keys[1],val);
                        break;
                    default:
                        break;
                }
                if(StringUtils.isEmpty(val)&&StringUtils.isNotEmpty(entry.getKey())){
                    isNull = 1;
                }
            }
            if(isNull == 1){
                newMap.put(keys[3],"0");
                newMap.put(keys[4],"存在空值或数据不合法");
            }
            mlist.add(newMap);
        }
        return mlist;
    }
}
