package com.bcxin.bi.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.bi.common.dao.entity.BiView;
import com.bcxin.bi.common.util.ConfigUtil;
import com.bcxin.bi.common.util.JwtUtil;
import com.bcxin.bi.common.util.consts.DictConst;
import com.bcxin.bi.service.ViewService;
import com.google.common.collect.Maps;
import io.jsonwebtoken.Claims;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 视图处理
 */
@Controller
public class BiViewController {

    @Resource
    private ViewService viewService;

    @Value("${spring.profiles.active}")
    private String active;

   /**
     * 首页
     * @return
     */
    @RequestMapping("/")
    public ModelAndView home(HttpServletRequest request)  {
        ModelAndView view = new ModelAndView("/index");
        if("bjstatic01".equals(active)){
            view = new ModelAndView("redirect:/ojt/0");
        }
        return view;
    }

    /**
     * 首页
     * @return
     */
    @RequestMapping("/index")
    public ModelAndView index(HttpServletRequest request)  {
        ModelAndView view = new ModelAndView("/pc/index");
        return view;
    }
    /**
     * 首页
     * @return
     */
    @RequestMapping("/pc/biview/list")
    public ModelAndView biviewlist(HttpServletRequest request)  {
        ModelAndView view = new ModelAndView("/pc/biview/list");
        List<BiView> biViewList = viewService.viewList();
        view.addObject("biViewList", biViewList);
        return view;
    }
    /**
     * 首页
     * @return
     */
    @RequestMapping("/pc/biview/add")
    public ModelAndView biviewadd(HttpServletRequest request)  {
        return new ModelAndView("/pc/biview/add");
    }

    @RequestMapping("/pc/biview/get-v5-token")
    @ResponseBody
    public String getToken(HttpServletRequest request)  {
        String DOMAINID = request.getParameter("DOMAINID");
        String viewCode = request.getParameter("viewCode");
        /* 加密*/
        Map<String,String> param = Maps.newHashMap();
        //模拟参数1 "HN_V5_QYTS"
        param.put("viewCode", viewCode);
        param.put("DOMAINID", "'"+DOMAINID+"'");
        //加密生成token
        String token = JwtUtil.createJWT(param);
        return token;
    }


    /**
     * 接收外部请求，跳转到对应的大屏上
     * @param request
     * @return
     */
    @RequestMapping(value = "/view", method = RequestMethod.GET)
    public ModelAndView view(HttpServletRequest request) {
        String token = request.getParameter("token");
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token);
        } catch (Exception e) {
            return new ModelAndView("/error");
        }
        String subject = claims.getSubject();
        Map<String, String> paramMap = JSON.parseObject(subject, new TypeReference<HashMap<String, String>>(){ });
        if (paramMap.isEmpty()) {
            return new ModelAndView("/error");
        }
        BiView biView = viewService.view(paramMap);
        /* 内网，需要访问私有化部署 */
        if (DictConst.INSIDE_NETWORK.equalsIgnoreCase(ConfigUtil.getValue("nature"))) {
//            String url = ConfigUtil.getValue("web_url") + biView.getPath() + "?webUrl="+ConfigUtil.getValue("web_url")+"&params="+token;
//            ModelAndView modelAndView = new ModelAndView("/bi/redirect");
//            modelAndView.addObject("url",url);
            ModelAndView modelAndView = new ModelAndView("/bi/redirect");
            modelAndView.addObject("url",ConfigUtil.getValue("web_url") + "/online?path="+biView.getPath()+"&params="+token);
            return modelAndView;
        }
        /* 外网，直接访问互联网即可 */
        else {
            ModelAndView modelAndView = new ModelAndView("/bi/redirect");
            modelAndView.addObject("url",ConfigUtil.getValue("web_url") + "/online?path="+biView.getPath()+"&params="+token);
            //modelAndView.addObject("path",biView.getPath());
            //modelAndView.addObject("params",token);
            return modelAndView;
        }
    }


    /**
     * 接收外部请求，跳转到对应的大屏上
     * @param request
     * @return
     */
    @RequestMapping(value = "/online", method = RequestMethod.GET)
    public ModelAndView online(HttpServletRequest request) {
        String path = request.getParameter("path");
        String params = request.getParameter("params");
        ModelAndView modelAndView = new ModelAndView(path);
        modelAndView.addObject("params",params);
        modelAndView.addObject("webUrl",ConfigUtil.getValue("web_url"));
        return modelAndView;
    }

    @RequestMapping(value = "/ojt/{doHtml}", method = RequestMethod.GET)
    public ModelAndView onlineJT(@PathVariable String doHtml) {
        ModelAndView modelAndView = new ModelAndView("/bi/ojt/"+doHtml);
        return modelAndView;
    }

}
