package tk.mybatis.springboot.service;

import org.springframework.stereotype.Service;
import tk.mybatis.springboot.mapper.SMSConfigMapper;
import tk.mybatis.springboot.model.SMSConfig;
import tk.mybatis.springboot.util.ConfigUtil;

import javax.annotation.Resource;
import java.util.List;

@Service
public class ConfigSystemService {

    @Resource
    private SMSConfigMapper smsConfigMapper;

    public void listInCache() {
        List<SMSConfig> configList = smsConfigMapper.selectAll();
        configList.forEach(config->{
            String key = config.getSysKey();
            ConfigUtil.putValue(key.toUpperCase(), config.getSysValue());
        });
    }

}
