package com.bcxin.tenant.apis.translates.impls;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationGetResponse;
import com.bcxin.tenant.apis.translates.OrganizationTranslate;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.readers.dtos.OrganizationDto;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import org.springframework.stereotype.Component;

@Component
public class OrganizationTranslateImpl implements OrganizationTranslate {

    @Override
    public RegisterCompanyCommand translate(CompanyRegistrationRequest request) {
        RegisterCompanyCommand command = RegisterCompanyCommand.create(
                request.getInstitutionalCode(), request.getIndustryCode(),
                request.getUnifySocialCreditCode(), request.getUnifySocialCreditCodeFile(),
                request.getName(),
                translateLocationItem(request.getPlaceOfRegister()),
                translateLocationItem(request.getPlaceOfBusiness()),
                translate2ContactCommandItem(request.getAdministrator()),
                translate2ContactCommandItem(request.getGeneralManager()),
                translate2ContactCommandItem(request.getDeputyGeneralManager())
        );

        return command;
    }

    @Override
    public OrganizationGetResponse translate(OrganizationDto organizationDto) {
        return null;
    }

    private static RegisterCompanyCommand.LocationCommandItem  translateLocationItem(LocationRequest locationRequest) {
        return RegisterCompanyCommand.LocationCommandItem.create(
                translateItemValueItem(locationRequest.getProvince()),
                translateItemValueItem(locationRequest.getCity()),
                translateItemValueItem(locationRequest.getDistrict()),
                locationRequest.getAddress()
        );
    }

    private static RegisterCompanyCommand.ItemValueCommandItem translateItemValueItem(LocationRequest.ItemValueRequest itemValueRequest) {
        return RegisterCompanyCommand.ItemValueCommandItem.create(itemValueRequest.getCode(), itemValueRequest.getName());
    }

    private static RegisterCompanyCommand.ContactCommandItem translate2ContactCommandItem(
            CompanyRegistrationRequest.ContactRequest request) {
        return RegisterCompanyCommand.ContactCommandItem.create(
                request.getName(), request.getTelephone(),
                translate2CredentialType(request.getCredentialType()),
                request.getCredentialNumber());
    }

    private static com.bcxin.Infrastructures.enums.CredentialType translate2CredentialType(CredentialType credentialType) {
        switch (credentialType) {
            case IdCard:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCard;
            case IdCardOfAoMen:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfAoMen;
            case Arms:
                return com.bcxin.Infrastructures.enums.CredentialType.Arms;
            case Passport:
                return com.bcxin.Infrastructures.enums.CredentialType.Passport;
            case IdCardOfTaiwan:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfTaiwan;
            case IdCardOfXiangGang:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfXiangGang;
        }

        throw new NotSupportTenantException(String.format("不支持该证件类型(%s)!", credentialType));
    }

    private static OrganizationGetResponse.LocationResponse translate2LocationResponse(LocationValueType location) {
        return new OrganizationGetResponse.LocationResponse(
                translate2ItemValueType(location.getProvince()),
                translate2ItemValueType(location.getCity()),
                translate2ItemValueType(location.getDistrict()),
                location.getAddress());
    }

    private static OrganizationGetResponse.ItemValueResponse translate2ItemValueType(ItemValueType itemValueType) {
        return new OrganizationGetResponse.ItemValueResponse(itemValueType.getCode(), itemValueType.getName());
    }
}
