package com.bcxin.tenant.apis.impls.chain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MoneyCheck extends CheckPayroll {

	@Override
	void process(Map<String, Object> map) {
		
		Map<String, Object> warn = new HashMap<String, Object>();
		BigDecimal atual = new BigDecimal(map.get("实发金额").toString());
		BigDecimal min = this.config.getMinSalary();
		BigDecimal max = this.config.getMaxSalary();

		if (atual.compareTo(max) > 0) {
			warn.put("原因", "实发金额大于" + max + "上限");
		}
		if (atual.compareTo(min) < 0) {
			warn.put("原因", "实发金额大于" + min + "下限");
		}
	}

}
