package com.bcxin.tenant.apis.impls;

import java.util.Collection;
import java.util.Map;

import org.apache.commons.collections4.map.HashedMap;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

import com.bcxin.Infrastructures.TenantUserContext.UserModel;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.SyncTenantUserLocationRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.SyncWechatLabelRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateBasicTenantUserRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateCredentialRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateTenantPhotoRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.UpdateTenantUserRequest;
import com.bcxin.api.interfaces.tenants.responses.MyOrganizationProfileGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserDetailGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserOrganBasicGetResponse;
import com.bcxin.api.interfaces.tenants.responses.UserProfileGetResponse;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class UserRpcImpl implements UserRpcProvider{
	@Autowired
	private SalaryQueryMapper salaryQueryMapper;
	@Override
	public UserProfileGetResponse get(String id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Collection<MyOrganizationProfileGetResponse> getById(String id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public UserOrganBasicGetResponse getByIdAndOrganId(String organId, String tenantUserId) {
		Map<String, Object>parm = new HashedMap<String, Object>();
		parm.put("organId", organId);
		parm.put("employeeId", tenantUserId);
		Map<String, Object> res = salaryQueryMapper.login(parm);
		if(res==null) {
			return null;
		}
		return UserOrganBasicGetResponse.create(organId, tenantUserId, res.get("name")+"", null,res.get("job_number")+"", null);
	}

	@Override
	public void update(String id, UpdateTenantUserRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void update(String id, SyncTenantUserLocationRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateDeviceId(String id, String cid) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateBasic(String id, UpdateBasicTenantUserRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateCredential(String id, UpdateCredentialRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updatePhoto(String id, UpdateTenantPhotoRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void syncWechatLabel(String id, SyncWechatLabelRequest request) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public UserDetailGetResponse getDetail(String id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void reRealNameAuthenticate(String id) {
		// TODO Auto-generated method stub
		
	}

}
