package com.bcxin.tenant.apis.impls;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections4.map.HashedMap;
import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.alibaba.excel.EasyExcel;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryReportService;
import com.bcxin.api.interfaces.salary.req.HumanDetailHead;
import com.bcxin.api.interfaces.salary.req.HumanDetailReq;
import com.bcxin.api.interfaces.salary.req.HumanFundReq;
import com.bcxin.api.interfaces.salary.req.HumanMergeReq;
import com.bcxin.api.interfaces.salary.req.HumanTotalCountReq;
import com.bcxin.api.interfaces.salary.res.HumanTotalCountRes;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.mongodb.BasicDBObject;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryReportServiceImpl implements ISalaryReportService {
	@Autowired
	private MongoTemplate mongoTemplate;



	@Override
	public List<HumanTotalCountRes> getHumanTotalCount(HumanTotalCountReq req) {

		List<HumanTotalCountRes> result = new ArrayList<HumanTotalCountRes>();
		List<String> depts = req.getDepts();
		for (String dept : depts) {
			HumanTotalCountRes data  = new HumanTotalCountRes();
			data.setCreateTime(DateUtil.format(new Date(), DatePattern.NORM_DATE_PATTERN));
			Query query = new Query(Criteria.where("部门").is(dept).and("当前计薪月").is(req.getMonth()));
			List<Document>docs=mongoTemplate.find(query, Document.class, SalaryConstant.SALARY_CURRENT);
			for (Document dcu : docs) {
				BigDecimal shoudSalary = new BigDecimal("0");
				BigDecimal actualSalary = new BigDecimal("0");
				List<Document> lst = dcu.getList("groupInfo", Document.class);
				for (Document lstDoc : lst) {
					if(SalaryConstant.STATISTIC.equals(lstDoc.getString(SalaryConstant.NAME))) {
						List<Document> items = lstDoc.getList("salaryItems", Document.class);
						for (Document item : items) {
							if(SalaryConstant.SHOULD_PAY.equals(item.getString("item"))) {
								shoudSalary = shoudSalary.add(new BigDecimal(item.getString("value")));
							}
							if(SalaryConstant.ACTUAL_PAY.equals(item.getString("item"))) {
								actualSalary =  actualSalary.add(new BigDecimal(item.getString("value")));
							}

						}
						break;
					}
				}
				data.setActualSalary(actualSalary+"");
				data.setShouldSalary(shoudSalary+"");
				result.add(data);
			}
			//			HumanTotalCountRes total  = new HumanTotalCountRes();
			//			total.setHumanTotal("合计");
			//			total.setHumanTotal(humanTotal);
			//			total.setActualSalary(actualSalary);
			//			result.add(total);
		}
		return result;
	}

	@Override
	public List<HumanDetailHead> listHumanDetail(HumanDetailReq req) {

		List<HumanDetailHead> rsts = new ArrayList<>();

		Aggregation aggregation =
				Aggregation.newAggregation(
						Aggregation.match(Criteria.where("部门").in(req.getDepts())
								.and("当前计薪月").is(req.getMonth())),
						Aggregation.unwind("groupInfo"),
						Aggregation.match(Criteria.where("groupInfo.salaryItems.dataType").is(1))
						,Aggregation.unwind("groupInfo.salaryItems")
						,Aggregation.project("groupInfo.salaryItems.item","groupInfo.salaryItems.value","部门")
						,Aggregation.group("salaryItems.item","部门").sum("salaryItems.value").as("total")
						,Aggregation.group("_id.部门").addToSet("$$ROOT").as("nodes")
						);
		AggregationResults<BasicDBObject> outputType = mongoTemplate.aggregate(aggregation,SalaryConstant.SALARY_CURRENT, BasicDBObject.class);
		List<BasicDBObject>rs=outputType.getMappedResults();
		rs.parallelStream().forEach(node->{
			List<Document>lst =(List<Document>) node.get("nodes");
			HumanDetailHead obj = new HumanDetailHead();
			for (Document basicDBObject : lst) {
				List<String>keys = new ArrayList<>();
				keys.add("_id");
				keys.add("item");
				String head = basicDBObject.getEmbedded(keys, String.class);
				int value = basicDBObject.getInteger("total",0);
				try {
					obj.setValue(head, value+"");
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			rsts.add(obj);
		});


		return rsts;
	}
	@Override
	public List<Map> listHumanFundDetail(HumanFundReq req) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<Map> listHumanMerge(HumanMergeReq req) {
		List<Map> files = new ArrayList<Map>();
		List<String> depts = req.getDepts();
		for (String dept : depts) {
			// 按部门拆分
			Query query = new Query(Criteria.where("部门").is(dept).and("当前计薪月")
					.is(req.getMonth())/* .and("薪资组").in(req.getGroupName()) */);
			List<Document>docs=mongoTemplate.find(query, Document.class, SalaryConstant.SALARY_CURRENT);
			List<List<String>>headers = new ArrayList<>();
			Set<String> mergeHeader = new LinkedHashSet<String>();
			// 找出部门薪资组的所有header
			for (Document dcu : docs) {
				List<Document> lst = dcu.getList("groupInfo", Document.class);
				for (Document lstDoc : lst) {
					List<Document> items = lstDoc.getList("salaryItems", Document.class);
					for (Document item : items) {
						String itemName = item.getString("item");
						if(mergeHeader.contains(itemName)) {
							continue;
						}
						mergeHeader.add(itemName);
						List<String> header = new ArrayList<String>();
						header.add(itemName);
						headers.add(header);
						
					}
				}
			}
			// 找出header 对应的value	
		    List<List<Object>>rs = new ArrayList<>();
		    String file = "D:\\bx\\dynamic\\"+dept+".xlsx";
			Map  fileMap = new HashedMap<>();
			fileMap.put("file", new File(file));
			fileMap.put("filename",dept);
			files.add(fileMap);
			for (Document user : docs) {
				List<Document> lst = user.getList("groupInfo", Document.class);
				Map pair = new HashedMap<>();
				for (Document lstDoc : lst) {
					List<Document> items = lstDoc.getList("salaryItems", Document.class);
					for (Document item : items) {
						String itemName = item.getString("item");
						Object vaule = item.get("value");
						pair.put(itemName, vaule);
					}
				}
				List<Object> dtsingle = new ArrayList<>();
				for (String h : mergeHeader) {
					dtsingle.add(pair.get(h));
				}
				rs.add(dtsingle);
				System.out.println(pair);
		        EasyExcel.write(file)
	            // 这里放入动态头
	            .head(headers).sheet("模板")
	            // 当然这里数据也可以用 List<List<String>> 去传入
	            .doWrite(rs);
			}
			System.out.println(rs);
		}
		return files;
	}





}
