package com.bcxin.tenant.apis.impls;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import org.apache.commons.math3.dfp.DfpField.RoundingMode;
import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.ConvertOperators;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.Pagination;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryPayrollService;
import com.bcxin.api.interfaces.salary.cmd.PayDistributionCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollDetailUpdateCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollEmployeeCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollSendCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrolllUploadCmd;
import com.bcxin.api.interfaces.salary.cmd.SalaryGroupSendPayrollCmd;
import com.bcxin.api.interfaces.salary.cmd.TrendCmd;
import com.bcxin.api.interfaces.salary.req.PayrollConfigReq;
import com.bcxin.api.interfaces.salary.req.PayrollDetailVo;
import com.bcxin.api.interfaces.salary.req.PayrollVo;
import com.bcxin.api.interfaces.salary.req.SalaryDetailHead;
import com.bcxin.api.interfaces.salary.res.PayDistributionRes;
import com.bcxin.api.interfaces.salary.res.TrendRes;
import com.bcxin.api.interfaces.salary.res.TrendRes.MonthRecord;
import com.bcxin.api.interfaces.salary.res.YearAddRes;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.bcxin.tenant.apis.dto.Payroll;
import com.bcxin.tenant.apis.dto.PayrollDetail;
import com.bcxin.tenant.domain.entities.PayrollConfig;
import com.bcxin.tenant.domain.repository.impls.SalaryPayrollConfigRepository;
import com.mongodb.BasicDBObject;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryPayrollServiceImpl implements ISalaryPayrollService{

	@Autowired
	SalaryPayrollConfigRepository salaryPayrollConfigRepository;
	@Autowired
	SalaryQueryMapper salaryQueryMapper;
	@Autowired
	MongoTemplate mongoTemplate;
	@Override
	public Pagination<PayrollVo> pageList(PayrollVo req) {

		Criteria cr = new Criteria();
		cr.and("orgId").is(TenantContext.getOrgId());
		if(StringUtils.hasLength(req.getPayrollName())) {
            Pattern pattern = Pattern.compile("^.*"+req.getPayrollName()+".*$", Pattern.CASE_INSENSITIVE);
			cr.and("payrollName").is(pattern);
		}
		if(StringUtils.hasLength(req.getPayrollDate())) {
			cr.and("payrollDate").is(req.getPayrollDate());
		}
		if(req.getSendStatus()!=null) {
			// 发送状态
			cr.and("sendStatus").is(req.getSendStatus());
		}
		if(req.getApproveStatus()!=null) {
			// 审批状态
			cr.and("approveStatus").is(req.getApproveStatus());
		}
		if(req.getApproverId()!=null) {
			// 审批人
			cr.and("approveId").is(req.getApproverId());
		}
		if(req.getTenantUserId()!=null) {
			// 发起人
			cr.and("tenantUserId").is(req.getTenantUserId());
		}
		Query query = new Query(cr);
		
		long totalCount = mongoTemplate.count(query, Payroll.class);
		query.with(PageRequest.of(req.getPageIndex()-1, req.getPageSize(), Sort.by(Direction.DESC, "id")));
		List<Payroll> payrollList = mongoTemplate.find(query, Payroll.class);
		List<PayrollVo> targ = BeanCopyUtil.copyListProperties(payrollList, PayrollVo::new);
		// 查询确认配置 和开关配置
		PayrollConfig config = salaryPayrollConfigRepository.findAll().get(0);
		Integer feedBackSwitch = config.getFeedBackSwitch();
		int confirmSwitch = (int) JSON.parseObject(config.getConfirmWay()).get("way");
		targ.parallelStream().forEach(vo->{
			vo.setFeedBackSwitch(feedBackSwitch);
			vo.setConfirmSwitch(confirmSwitch);
		});
		
		return Pagination.create(req.getPageIndex(), req.getPageSize(), totalCount,targ);
	}

	@Override
	public Pagination<PayrollVo> payrollDetail(PayrollDetailVo req) {
		Criteria cr = Criteria.where("id").is(req.getId());
//		cr.and("payrollItemId").is(req.getPayrollItemId());
		if(StringUtils.hasLength(req.getName())) {
		
			cr.and("name").regex("^.*"+req.getName()+".*$");
		}
		if(req.getPayroolState()!=null) {
			cr.and("payroolState").is(req.getPayroolState());
		}
		if(StringUtils.hasLength(req.getReadState())) {
			cr.and("readState").is(req.getReadState());
		}
		if(StringUtils.hasLength(req.getConfirmState())) {
			cr.and("confirmState").is(req.getConfirmState());
		}
		Query query = new Query(cr);
		
		long totalCount = mongoTemplate.count(query, Payroll.class);
		query.with(PageRequest.of(req.getPageIndex()-1, req.getPageSize(), Sort.by(Direction.DESC, "id")));
		List<Payroll> lst = mongoTemplate.find(query, Payroll.class);
		List<PayrollVo> targ = new ArrayList<>();
		lst.parallelStream().forEach(u->{
			PayrollVo vo = new PayrollVo();
			BeanCopyUtil.copyProperties(u, vo);
			List<PayrollDetailVo> list = BeanCopyUtil.copyListProperties(u.getDetails(), PayrollDetailVo::new);
			vo.setDetails(list);
			targ.add(vo);
		});
		// 得到工资信息 姓名+员工号+月份
		return Pagination.create(req.getPageIndex(), req.getPageSize(), totalCount,targ);
	}

	@Override
	public PayrollConfigReq payrollQuery() {
		PayrollConfig config =salaryPayrollConfigRepository.findAll().get(0);
		PayrollConfigReq req = new PayrollConfigReq();
		BeanCopyUtil.copyPropertiesIgNore(config, req);
		return req;
	}

	@Override
	public void payrollUpdate(PayrollConfigReq source) {
		PayrollConfig target = salaryPayrollConfigRepository.getById(source.getId());
		BeanCopyUtil.copyPropertiesIgNore(source, target);
		salaryPayrollConfigRepository.save(target);
	}

	@Override
	public void updateDetail(PayrollDetailVo req) {
		PayrollDetail detail = mongoTemplate.findById(req.getId(), PayrollDetail.class);
		detail.setPayroolState(req.getPayroolState());
		mongoTemplate.save(detail);
	}

	@Override
	public void delPayroll(PayrollVo req) {
		Query query = new Query(Criteria.where("id").is(req.getId()));
		mongoTemplate.remove(query, Payroll.class);
	}

	@Override
	public String save(PayrolllUploadCmd parm) {
		Payroll payroll= new Payroll(TenantContext.getOrgId());
		payroll.create(parm);
		Payroll paro= mongoTemplate.save(payroll);
		if(parm.getAppointTime()!=null) {
			// 定时任务
			CronUtil.schedule(DateUtil.format(parm.getAppointTime(),"ss mm HH dd MM ? yyyy" ), new Task() {
				@Override
				public void execute() {
					Update update =new Update();
					update.set("sendStatus", 3);
					update.set("createTime", new Date());
					update.set("details.$.payrollState", 1);
					Query query = Query.query(Criteria.where("id").is(paro.getId()));
					mongoTemplate.updateFirst(query, update, Payroll.class);
				}
			});

			// 支持秒级别定时任务
//			CronUtil.setMatchSecond(true);
			CronUtil.start();
		}
		return paro.getId();
	}

	@Override
	public Object saveDetail(PayrolllUploadCmd parm) {
		// TODO 校验员工的工资卡 或者身份证号
		List<Map<String,Object>> dts = check(parm.getDetails());
		Map<String,Object> rs = new HashMap<>();
		
        boolean flag = false;
		if(dts.size()>0) {
			rs.put("error", dts);
		};
		if(parm.getUpType()==0) {
			flag = true;
		}
        if(flag) {
        	return rs;
        }
		// 校验预警值 
		List<Map<String,Object>> warss = warn(parm.getDetails());
		
		// 如果是智能上传，把预警信息也要加入错误中
		
		if(warss.size()>0) {
			rs.put("warn", warss);
		}
		Payroll payroll = new Payroll(TenantContext.getOrgId());
		payroll.create(parm);
		rs.put("data", payroll);

		return  rs;
	}

	@Override
	public void updatePayrollDetail(PayrollDetailUpdateCmd cmd) {
		Query query = new Query();
		query.addCriteria(Criteria.where("id").is(cmd.getId()));
		query.addCriteria(Criteria.where("details")
				.elemMatch(Criteria.where("payrollItemId").is(cmd.getDetails().get(0).getPayrollItemId())));
		Object detail = JSON.toJSON(cmd.getDetails().get(0));
		Update update = new Update();
		update.set("details.$", detail);
		//		update.filterArray(criteria)
		if(cmd.getDetails().get(0).getPayroolState()==2) {
			// 撤回 撤回员工+1
			update.inc("revokeCount");
		}
		if(cmd.getDetails().get(0).getPayroolState()==1) {
			// 重新发送
			update.inc("revokeCount",-1);
		}
		mongoTemplate.updateFirst(query, update, Payroll.class);
	}
	@Override
	public void delPayrollDetail(String payrollId, List<String>items) {
		Query query = new Query();
		query.addCriteria(Criteria.where("_id").is(payrollId)
				.and("detail.payrollItemId").in(items));
		Update update = new Update();
		update.unset("details.$");
		mongoTemplate.updateFirst(query, update, Payroll.class);
	}

	/**
	 * 校验数据
	 * @param 
	 */
	private List<Map<String,Object>>  check(List<Map<String,Object>>datas) {
		// 校验 姓名 证件类型 证件号 银行卡号 错误原因
		List<Map<String,Object>> errs = new ArrayList<>();

		for (Map<String,Object> map : datas) {
			Map<String, Object> errorMap = new HashMap<>();
			boolean flag =false;
			StringBuffer sb = new StringBuffer();
			if(ObjectUtil.isEmpty(map.get("姓名"))){
				sb.append("姓名*不能为空;");
				flag = true;
			}

			if(ObjectUtil.isEmpty(map.get("证件号码"))&&ObjectUtil.isEmpty(map.get("银行卡号"))){
				sb.append("证件号码和银行卡号不能同时为空;");
				flag = true;
			}

			// 校验身份证 银行卡号 是否和这个人对应
			Map<String,Object>params=new HashMap<>();
			params.put("name", map.get("姓名"));
			params.put("certiNo", map.get("证件号码"));
			params.put("bankNo", map.get("银行卡号"));
			if(salaryQueryMapper.login(params)==null) {
				sb.append("员工信息不正确;");
				flag = true;
			};
			
			// 卡号重复校验
            if(map.get("银行卡号")!=null) {
    			Map<String,List<Map>> cardGroup = datas.stream().
    			        collect(Collectors.groupingBy(e->e.get("银行卡号").toString()));
    			if(cardGroup.get(map.get("银行卡号").toString()).size()>1) {
    				sb.append("银行卡号存在重复;");
    				flag = true;
    			}
            }
			
			// 身份证号码重复校验
            if(map.get("证件号码")!=null) {
    			Map<String,List<Map>> cardGroup = datas.stream().
    			        collect(Collectors.groupingBy(e->e.get("证件号码").toString()));
    			if(cardGroup.get(map.get("证件号码").toString()).size()>1) {
    				sb.append("证件号码存在重复;");
    				flag = true;
    			}
            }
            
			if(flag) {
				errorMap.put("姓名", map.get("姓名"));
				errorMap.put("证件号", map.get("证件号码"));
				errorMap.put("银行卡号", map.get("银行卡号"));
				errorMap.put("错误原因", sb.toString());
				errorMap.put("校验结果", "异常");
				errorMap.put("证件类型", map.get("证件类型"));
				errorMap.put("校验说明", sb.toString());
				errs.add(errorMap);
			}
		}

		return errs;
	}


	private List<Map<String,Object>>  warn(List<Map<String,Object>> datas) {
		// 校验 姓名 证件类型 证件号 银行卡号 错误原因
		PayrollConfig config = salaryPayrollConfigRepository.findAll().get(0);
		List<Map<String,Object>> warns = new ArrayList<>();
		for (Map<String, Object> map : datas) {
			Map<String, Object> warn = new HashMap<>();
			warn.put("姓名", map.get("姓名"));
			warn.put("证件类型", map.get("证件类型"));
			warn.put("证件号", map.get("证件号码"));
			warn.put("银行卡号", map.get("银行卡号"));

			StringBuffer sb = new StringBuffer();
			// 校验金额
			BigDecimal atual = new BigDecimal(map.get("实发金额").toString());
			if(config.getMoneyWarn()==1) {
				BigDecimal min = config.getMinSalary();
				BigDecimal max = config.getMaxSalary();

				if (max!=null && atual.compareTo(max) > 0) {
					sb.append("实发金额大于" + max + "上限");
				}
				if (min!=null && atual.compareTo(min) < 0) {
					sb.append("实发金额大于" + min + "下限");
				}
			}
            // 校验离职状态
			if(config.getLeaveWarn()==1) {
				Map<String,Object>params=new HashMap<>();
				params.put("name", map.get("姓名"));
				params.put("certiNo", map.get("证件号码"));
				params.put("bankNo", map.get("银行卡号"));
				Map<String,Object> user = salaryQueryMapper.login(params);
				if(user.get("leave_time")!=null) {
					sb.append("员工已离职;");
				};
			}
			
			// 校验年龄
			if(config.getAgeWarn()==1) {
				Map<String,Object>params=new HashMap<>();
				params.put("name", map.get("姓名"));
				params.put("certiNo", map.get("证件号码"));
				params.put("bankNo", map.get("银行卡号"));
				Map<String,Object> user = salaryQueryMapper.login(params);
				int age = IdcardUtil.getAgeByIdCard(user.get("certi_no").toString());
				if("1".equals(user.get("sex").toString())
						&& config.getManWarn()!=null && age>=config.getManWarn()) {
					sb.append("男性年龄达到");
					sb.append(config.getManWarn());
					sb.append(";");
				}
				if("2".equals(user.get("sex").toString())
						&& config.getWomanWarn()!=null && age>=config.getWomanWarn()) {
					sb.append("女性年龄达到");
					sb.append(config.getWomanWarn());
					sb.append(";");
				}
			}

			if(sb.length()>0) {
				warn.put("实发金额", map.get("实发金额"));
				warn.put("原因", sb.toString());
				warn.put("校验结果", "预警");
				warn.put("校验说明", sb.toString());
				warns.add(warn);
			}
			
		}
       
		return warns;
	}
	private List<Map<String,Object>>  warn2(List<PayrollDetailVo> datas) {
		// 校验 姓名 证件类型 证件号 银行卡号 错误原因
		PayrollConfig config = salaryPayrollConfigRepository.findAll().get(0);
		List<Map<String,Object>> warns = new ArrayList<>();
		for (PayrollDetailVo detail : datas) {
			Map<String, Object> warn = new HashMap<>();
			warn.put("姓名", detail.getName());
			warn.put("证件类型", detail.getCeityType());
			warn.put("证件号", detail.getCeityNo());
			warn.put("银行卡号", detail.getBankNo());
			
			StringBuffer sb = new StringBuffer();
			// 校验金额
			BigDecimal atual =detail.getActualPay();
			if(config.getMoneyWarn()==1) {
				BigDecimal min = config.getMinSalary();
				BigDecimal max = config.getMaxSalary();
				
				if (max!=null && atual.compareTo(max) > 0) {
					sb.append("实发金额大于" + max + "上限");
				}
				if (min!=null && atual.compareTo(min) < 0) {
					sb.append("实发金额大于" + min + "下限");
				}
			}
			// 校验离职状态
			if(config.getLeaveWarn()==1) {
				Map<String,Object>params=new HashMap<>();
				params.put("name", detail.getName());
				params.put("certiNo", detail.getCeityNo());
				params.put("bankNo",detail.getBankNo());
				params.put("organId",TenantContext.getOrgId());
				Map<String,Object> user = salaryQueryMapper.login(params);
				if(user.get("leave_time")!=null) {
					sb.append("员工已离职;");
				};
			}
			
			// 校验年龄
			if(config.getAgeWarn()==1) {
				Map<String,Object>params=new HashMap<>();
				params.put("name", detail.getName());
				params.put("certiNo", detail.getCeityNo());
				params.put("bankNo",detail.getBankNo());
				params.put("organId",TenantContext.getOrgId());
				Map<String,Object> user = salaryQueryMapper.login(params);
				int age = IdcardUtil.getAgeByIdCard(user.get("certi_no").toString());
				if("1".equals(user.get("sex").toString())
						&& config.getManWarn()!=null && age>=config.getManWarn()) {
					sb.append("男性年龄达到");
					sb.append(config.getManWarn());
					sb.append(";");
				}
				if("2".equals(user.get("sex").toString())
						&& config.getWomanWarn()!=null && age>=config.getWomanWarn()) {
					sb.append("女性年龄达到");
					sb.append(config.getWomanWarn());
					sb.append(";");
				}
			}
			
			if(sb.length()>0) {
				warn.put("实发金额", atual);
				warn.put("原因", sb.toString());
				warn.put("校验结果", "预警");
				warn.put("校验说明", sb.toString());
				warns.add(warn);
			}
			
		}
		
		return warns;
	}

	@Override
	public List<Map<String, Object>> checkPayrollDetails(List<PayrollDetailVo>datas) {
		return warn2(datas);
		
	}

	@Override
	public Map<String, Object> queryPayrollByGorupId(PayrollSendCmd parm) {

		Query query = Query.query(Criteria.where("groupId").is(parm.getGroupId()));
		List<Document> docs = mongoTemplate.find(query, Document.class, SalaryConstant.SALARY_CURRENT);
		List<PayrollDetail>details = new ArrayList<>();
		for (Document doc : docs) {
			// 每个人的信息
			PayrollDetail detail = new PayrollDetail();
			detail.setName(doc.getString("姓名"));
			detail.setReadState(0);
			
			Map<String,Object> params = new HashMap<String, Object>();
			params.put("name", doc.getString("姓名"));
			params.put("employeeNo", doc.getString("员工号"));
			Map<String,Object> user = salaryQueryMapper.login(params);
			detail.setCeityType(user.getOrDefault("certi_type", "身份证").toString());
			detail.setCeityNo(user.getOrDefault("certi_no", "").toString());
			detail.setBankNo(user.getOrDefault("bank_no", "").toString());
			detail.setPhone(user.getOrDefault("phone", "").toString());
			
			List<Document> groupInfo = doc.getList("groupInfo",Document.class );
			Map<String,Object> other = new HashMap<String, Object>();
			for (Document grp : groupInfo) {
				String gname = grp.getString("name");
				List<Document> items = grp.getList("salaryItems", Document.class);
				List<Map<String,Object>> pgrp = new ArrayList<>();
				for (Document item : items) {
					String name = item.getString("item");
					Object value = item.get("value");
					if(name.equals("实发工资")) {
						detail.setActualPay(new BigDecimal(value==null?"0":value+""));
					}
					Map<String,Object> ite = new HashMap<>();
					ite.put(name, value);
					pgrp.add(ite);
				}
				other.put( gname, pgrp);
				detail.setOther(other);
			}
			details.add(detail);
			//			/**状态 1 已发送 2 已撤回*/
			//			private int payroolState;
		}
		Map<String, Object>  rest = new HashMap<String, Object>();
		rest.put("detail", details);
		//持久化 payroll  到数据库
		Payroll pr = new Payroll(TenantContext.getOrgId());
		
		pr.genPayroll(parm);
		pr.setDetails(details);
		mongoTemplate.save(pr);
		
		return rest;
	}

	@Override
	public Map<String, Object> pageEmployeeList(PayrollEmployeeCmd req) {

		Aggregation aggregation =
				Aggregation.newAggregation(
						Aggregation.unwind("details"),
						Aggregation.match(Criteria.where("details.name").is(req.getName())
								.and("createTime").lte(req.getCreateTimeTo()).gte(req.getCreateTimeFrom()))
						,new SkipOperation((req.getPageIndex()-1)*req.getPageSize())
						,Aggregation.limit(req.getPageSize())  
						,Aggregation.project("payrollDate","payrollName","salaryType","details")
						);
		AggregationResults<BasicDBObject> payroll = mongoTemplate.aggregate(aggregation, Payroll.class, BasicDBObject.class);
		Map<String, Object> rst = new HashMap<String, Object>();
		for (BasicDBObject basicDBObject : payroll.getMappedResults()) {
			basicDBObject.put("_id", basicDBObject.get("_id").toString());
		}
		rst.put("payroll", payroll.getMappedResults());
		return rst;
	}

	@Override
	public List<SalaryDetailHead> listEmployee(List<String> _ids) {
		Aggregation aggregation =
				Aggregation.newAggregation(
						Aggregation.unwind("details"),
						Aggregation.match(Criteria.where("details.payrollItemId").in(_ids))
						,Aggregation.project("payrollDate","payrollName","salaryType","details")
						);
		AggregationResults<Document> payroll = mongoTemplate.aggregate(aggregation, Payroll.class, Document.class);
		List<Document> basic = payroll.getMappedResults();
		List<SalaryDetailHead>data = new ArrayList<>();
		for (Document basicDBObject : basic) {
			SalaryDetailHead  head = new SalaryDetailHead();
			head.setPayrollName(basicDBObject.getString("payrollName"));
			head.setPayrollDate(basicDBObject.getString("payrollDate"));
			head.setSalaryType(basicDBObject.getInteger("salaryType")==0?"工资":"");
			head.setName(basicDBObject.getEmbedded(Arrays.asList("details","name"), String.class));
			head.setCeityNo((basicDBObject.getEmbedded(Arrays.asList("details","ceityNo"), String.class)));
			head.setBankNo(basicDBObject.getEmbedded(Arrays.asList("details","bankNo"), String.class));
			head.setPayroolState(basicDBObject.getInteger("payrollState")==null?"已发送":"撤回");
			data.add(head);
		}
		return data;
	}

	@Override
	public TrendRes trend(TrendCmd cmd) {
		// 当前月
		String thisMonth  = DateUtil.format(DateUtil.date(), DatePattern.NORM_MONTH_PATTERN);
		//环比
		String lastMonth = DateUtil.format(DateUtil.lastMonth(), DatePattern.NORM_MONTH_PATTERN);
		// 同比
		String lstYearThisMonth = DateUtil.format(DateUtil.offset(DateUtil.date(), DateField.YEAR, -1), DatePattern.NORM_MONTH_PATTERN);
		List<String> month1 = Arrays.asList(thisMonth,lastMonth,lstYearThisMonth);
		List<String> month2 = getYearMonth(cmd.getYear());

		List<MonthRecord>  rs1 = listRecord(month1,false);
		TrendRes res = new TrendRes();
		if(!rs1.isEmpty()) {
			MonthRecord r1 = rs1.get(0);
			MonthRecord r2 = rs1.get(0);
			MonthRecord r3 = rs1.get(0);

			//环比
			BigDecimal circleRatio = NumberUtil.sub(r1.getActualPay(),r2.getActualPay()).divide(r2.getActualPay(),2,RoundingMode.ROUND_UP.ordinal());
			BigDecimal sameRatio = NumberUtil.sub(r1.getActualPay(),r3.getActualPay()).divide(r3.getActualPay(),2,RoundingMode.ROUND_UP.ordinal());


			BigDecimal circlePersonRatio = NumberUtil.sub(r1.getPersonTotal(),r2.getPersonTotal()).divide(new BigDecimal(r2.getPersonTotal()),2,RoundingMode.ROUND_UP.ordinal());
			BigDecimal samePersonRatio =NumberUtil.sub(r1.getPersonTotal(),r3.getPersonTotal()).divide(new BigDecimal(r3.getPersonTotal()),2,RoundingMode.ROUND_UP.ordinal());

			DecimalFormat format = new DecimalFormat("#0.00%");

			res.setCurMonthTotalSalary(r1.getActualPay());
			res.setCurMonthTotalSameSalary(format.format(sameRatio));
			res.setCurMonthTotalMonthSalary(format.format(circleRatio));

			res.setCurMonthTotalPerson(r1.getPersonTotal());
			res.setCurMonthSamePerson(format.format(samePersonRatio));
			res.setCurMonthMonthPerson(format.format(circlePersonRatio));

			BigDecimal avg1 = r1.getActualPay().divide(new BigDecimal(r1.getPersonTotal()),2,RoundingMode.ROUND_UP.ordinal());
			BigDecimal avg2 = r2.getActualPay().divide(new BigDecimal(r2.getPersonTotal()),2,RoundingMode.ROUND_UP.ordinal());
			BigDecimal avg3 = r3.getActualPay().divide(new BigDecimal(r3.getPersonTotal()),2,RoundingMode.ROUND_UP.ordinal());

			BigDecimal circleAvgRatio = NumberUtil.sub(avg1,avg2).divide(avg2,2,RoundingMode.ROUND_UP.ordinal());
			BigDecimal sameAvgRatio =NumberUtil.sub(avg1,avg3).divide(avg3,2,RoundingMode.ROUND_UP.ordinal());

			res.setCurMonthAvgSalary(avg1);
			res.setCurMonthAvgSameSalary(format.format(sameAvgRatio));
			res.setCurMonthAvgMonthSalary(format.format(circleAvgRatio));
		}


		res.setMonthList(listRecord(month2,true));

		return res;
	}

	private List<MonthRecord> listRecord(List<String> month1,boolean flag) {
		List<MonthRecord> lst = new ArrayList<TrendRes.MonthRecord>();
		Criteria cr = Criteria.where("sendStatus").in(Arrays.asList(2,3));
		cr.and("payrollMonth").in(month1);

		Aggregation aggregation =
				Aggregation.newAggregation(
						Aggregation.match(cr)
						,Aggregation.group("payrollMonth").sum("totalCount").as("totalCount")
						.sum(ConvertOperators.ToDecimal.toDecimal("$totalMoney")).as("totalMoney")
						,Aggregation.sort(Direction.DESC, "payrollMonth")
						);
		AggregationResults<Document> outputType = mongoTemplate.aggregate(aggregation,Payroll.class, Document.class);
        Map<String,MonthRecord> con = new HashMap<>();
		outputType.forEach(doc->{
			MonthRecord record = new MonthRecord();
			String total = doc.get("totalMoney").toString();
			record.setActualPay(new BigDecimal(total));
			record.setPersonTotal(doc.getInteger("totalCount"));
			record.setMonth(doc.getString("_id"));
			con.put(doc.getString("_id"), record);
		});
		
		for (String mt : month1) {
			MonthRecord record = con.get(mt);
			if(record==null&&flag) {
				record = new MonthRecord();
				record.setMonth(mt);
			}
			if(record!=null) {
				lst.add(record);	
			}
			
		}
		return lst;
	}

	private  List<String> getYearMonth(String y) {
		List<String>yearMonth = new ArrayList<>();
		for (int i = 1; i <= 12; i++) {
			StringBuffer year = new StringBuffer(y);
			year.append("-");
			if(i<10) {
				year.append("0");
			}
			year.append(i);
			yearMonth.add(year.toString());
		}
		return yearMonth;
	}

	@Override
	public List<YearAddRes> yearAdd(TrendCmd cmd) {
		List<String> month2 = getYearMonth(cmd.getYear());
		List<MonthRecord> rerods =  listRecord(month2,true);
		Map<String,BigDecimal> month = new HashMap<>();
		for (MonthRecord monthRecord : rerods) {
			month.put(monthRecord.getMonth(), monthRecord.getActualPay());
		}
		
		List<YearAddRes> res = new ArrayList<YearAddRes>();
		
		int k =1;
		for (int i = 1; i <= 12; i++) {
			YearAddRes data = new YearAddRes();
			StringBuffer mon = new StringBuffer(cmd.getYear());
			mon.append("-");
			if(i<10) {
				mon.append("0");
			}
			mon.append(i);
			data.setMonth(mon.toString());
			BigDecimal sumInner=new BigDecimal(0);
			for (int j = 1; j <=k; j++) {
				StringBuffer year = new StringBuffer(cmd.getYear());
				year.append("-");
				if(j<10) {
					year.append("0");
				}
				year.append(j);
				sumInner=sumInner.add(month.getOrDefault(year.toString(), new BigDecimal(0)));
			}
			k++;
			data.setActualPay(sumInner);
			res.add(data);
			System.out.println(sumInner);
		}
		return res;
	}

	@Override
	public List<PayDistributionRes> payDistribution(PayDistributionCmd cmd) {
		
		List<PayDistributionRes> datas = new ArrayList<>();
		List<String> months;
		if(cmd.getChooseType()==0) {
		 // 年份
			 months = getYearMonth(cmd.getYear());
		}else {
			months = Arrays.asList(cmd.getYear());
		}
		int total = 0;
		for (int i = 1; i <= 8; i++) {
		    	PayDistributionRes res = new PayDistributionRes();
		    	List<Integer> data = res.assignRange(i);
				Aggregation aggregation =
						Aggregation.newAggregation(
								Aggregation.unwind("details")
								,Aggregation.project("details.actualPay","payrollMonth","details.name").andExpression("toDecimal(details.actualPay)").as("actualPay")
								,Aggregation.match(Criteria.where("payrollMonth").in(months)
										.and("actualPay").gte(data.get(0)).lt(data.get(1)))
								,Aggregation.group("name")
								);
				AggregationResults<Document> payroll = mongoTemplate.aggregate(aggregation, Payroll.class, Document.class);
				res.setPersonCount(payroll.getMappedResults().size());
				res.setRange(i);
				res.setRangeStr(res.getRangeStr(i));
				total+=res.getPersonCount();
				datas.add(res);
			}
		
		for (PayDistributionRes dt : datas) {
			if(total==0) {
				dt.setRatio("0.00");
			}else {
				dt.setRatio(NumberUtil.div(new BigDecimal(dt.getPersonCount()), new BigDecimal(total),2)+"");
			}
			
		}
		
		return datas;
	}

	@Override
	public Map<String, Object> groupGenPayroll(SalaryGroupSendPayrollCmd parm) {
		Query query = Query.query(Criteria.where("groupId").is(parm.getGroupId()));
		List<Document> docs = mongoTemplate.find(query, Document.class, SalaryConstant.SALARY_CURRENT);
	
		List<PayrollDetail>details = new ArrayList<>();
		for (Document doc : docs) {
			// 每个人的信息
			PayrollDetail detail = new PayrollDetail();
			detail.setName(doc.getString("姓名"));
			detail.setReadState(0);
			detail.setPayroolState(0);
			Map<String,Object> params = new HashMap<String, Object>();
			params.put("name", doc.getString("姓名"));
			params.put("employeeNo", doc.getString("员工号"));
			Map<String,Object> user = salaryQueryMapper.login(params);
			detail.setCeityType(user.getOrDefault("certi_type", "身份证").toString());
			detail.setCeityNo(user.getOrDefault("certi_no", "").toString());
			detail.setBankNo(user.getOrDefault("bank_no", "").toString());
			detail.setPhone(user.getOrDefault("phone", "").toString());
//			detail.setEmail(user.getOrDefault("email", "").toString());
			
			List<Document> groupInfo = doc.getList("groupInfo",Document.class );
			Map<String,Object> other = new HashMap<String, Object>();
			for (Document grp : groupInfo) {
				String gname = grp.getString("name");
				List<Document> items = grp.getList("salaryItems", Document.class);
				List<Map<String,Object>> pgrp = new ArrayList<>();
				for (Document item : items) {
					String name = item.getString("item");
					Object value = item.get("value");
					if(name.equals("实发工资")) {
						detail.setActualPay(new BigDecimal(value==null?"0":value+""));
					}
					Map<String,Object> ite = new HashMap<>();
					ite.put(name, value);
					pgrp.add(ite);
				}
				other.put( gname, pgrp);
				detail.setOther(other);
			}
			details.add(detail);
		}
		Map<String, Object>  rest = new HashMap<String, Object>();
		rest.put("detail", details);
		//持久化 payroll  到数据库
		String month = docs.get(0).getString("当前计薪月");
		String 	payrollName = month.replace("-", "").concat("00电子工资单");
		Payroll pr = new Payroll(TenantContext.getOrgId());
		pr.setUpType(3);
		pr.setSalaryType(0);
		pr.setPayrollName(payrollName);
        pr.setMonth(month);
//		pr.setPayrollDate(DateUtil.format(DateUtil.offsetMonth(DateUtil.parse(month,"yyyy-MM"), 1), "yyyy-MM"));
		pr.setDetails(details);
		pr.setSendStatus(0);
		mongoTemplate.save(pr);

		return BeanUtil.beanToMap(pr);
	}
	public static void main(String[] args) {
		System.out.println(DateUtil.format(DateUtil.offsetMonth(DateUtil.parse("2022-03","yyyy-MM"), 1), "yyyy-MM"));
	}
}
