package com.bcxin.tenant.apis.impls;

import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryItemService;
import com.bcxin.api.interfaces.salary.req.ItemReq;
import com.bcxin.api.interfaces.salary.req.SalaryItemSaveReq;
import com.bcxin.tenant.apis.dto.SalaryTemplate;
import com.bcxin.tenant.domain.entities.SalaryItem;
import com.bcxin.tenant.domain.repository.impls.SalaryConfigRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryItemGroupRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryItemRepository;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryItemServiceImpl implements ISalaryItemService {
	@Autowired
	private SalaryItemRepository salaryItemRepository;
	@Autowired
	private MongoTemplate mongoTemplate;
	
	
	@Autowired
	private SalaryItemGroupRepository salaryItemGroupRepository;
	@Override
	public Object findItem(ItemReq req) {
//		if(req.getType()==0) {
//			return salaryItemGroupRepository.findAll();
//		}
		SalaryTemplate tem = mongoTemplate.findOne(new Query(Criteria.where("type").is(req.getType())), SalaryTemplate.class);
		return tem.getTempValue();
	}
	@Override
	public void save(SalaryItemSaveReq req) {
		SalaryItem item = salaryItemRepository.getById(req.getId());
		BeanCopyUtil.copyPropertiesIgNore(req, item);
		salaryItemRepository.save(item);
	}

}
