package com.bcxin.tenant.apis.impls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotNull;

import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryGroupService;
import com.bcxin.api.interfaces.salary.req.BatchDelGroupUserReq;
import com.bcxin.api.interfaces.salary.req.DeptEmployeeReq;
import com.bcxin.api.interfaces.salary.req.GroupCreateNextReq;
import com.bcxin.api.interfaces.salary.req.GroupLockReq;
import com.bcxin.api.interfaces.salary.req.GroupPageQueryReq;
import com.bcxin.api.interfaces.salary.req.GroupStatisticsReq;
import com.bcxin.api.interfaces.salary.req.ItemGroupReq;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryGroupSaveReq;
import com.bcxin.api.interfaces.salary.req.SalaryOrgReq;
import com.bcxin.api.interfaces.salary.req.SalaryUserCheckPageQuery;
import com.bcxin.api.interfaces.salary.res.EmployeeBasicRes;
import com.bcxin.api.interfaces.salary.res.GroupPageQueryRes;
import com.bcxin.api.interfaces.salary.res.GroupStatisticsRes;
import com.bcxin.api.interfaces.salary.res.SalaryOrgRes;
import com.bcxin.tenant.apis.component.SalaryQueryBean;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.bcxin.tenant.domain.entities.SalaryArchive;
import com.bcxin.tenant.domain.entities.SalaryConfig;
import com.bcxin.tenant.domain.entities.SalaryGroup;
import com.bcxin.tenant.domain.entities.SalaryGroupUser;
import com.bcxin.tenant.domain.entities.SalaryItemGroup;
import com.bcxin.tenant.domain.repository.impls.SalaryArchiveRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryConfigRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryGroupRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryGroupUserRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryItemGroupRepository;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.param.Operator;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryGroupServiceImpl implements ISalaryGroupService {
	@Autowired
	private SalaryGroupRepository salaryGroupRepository;
	@Autowired
	private SalaryGroupUserRepository salaryGroupUserRepository;

	@Autowired
	private SalaryItemGroupRepository salaryItemGroupRepository;
	
	@Autowired
	private SalaryConfigRepository salaryConfigRepository;

	@Autowired
	private MongoTemplate mongoTemplate;


	@Autowired
	private BeanSearcher beanSearcher;

	@Autowired
	private SalaryQueryMapper salaryQueryMapper;
	
	@Autowired
	private SalaryArchiveRepository salaryArchiveRepository;



	@Override
	@Transactional(rollbackFor = Exception.class)
	public Long save(SalaryGroupSaveReq salaryGroup) {
		SalaryGroup entity = new SalaryGroup();
		String 	month = DateUtil.format(new Date(), "yyyy-MM");
		if(salaryGroup.getMonthType()==0) {
			salaryGroup.setMonth(month);
		}else {
			Date dt = DateUtil.offsetMonth(DateUtil.parse(month, "yyyy-MM"),1);
			salaryGroup.setMonth(DateUtil.format(dt, "yyyy-MM"));
		}
		if(salaryGroup.getId()!=null ) {
			entity= salaryGroupRepository.getById(salaryGroup.getId());
			// 先删除
		}else {
			// 验证组名是否存在
			if(salaryGroupRepository.findByGroupName(salaryGroup.getGroupName())!=null) {
				throw new RuntimeException("薪资组名称已经存在，请重新改一个名字");
			};
		}
		BeanCopyUtil.copyPropertiesIgNore(salaryGroup, entity);
		entity.setOrgId(TenantContext.getInstance().getUserContext().get().getOrganId());
		salaryGroupRepository.save(entity);

		DeptEmployeeReq req = new DeptEmployeeReq();
		req.setOrgId(TenantContext.getUserContext().get().getOrganId());
		if(StringUtils.hasLength(entity.getPayEmp())) {
			req.setEmployees(Arrays.asList(entity.getPayEmp().split(",")));
		}

		if(!salaryGroup.getDepts().isEmpty()) {
			req.setDepts(salaryGroup.getDepts());
		}
		String groupName  =  entity.getGroupName();
		Long groupId  =  entity.getId();
		List<EmployeeBasicRes> users = salaryQueryMapper.selectDepartEmployees(req);
		List<SalaryGroupUser> grupusers = new ArrayList<SalaryGroupUser>();
		users.parallelStream().forEach(u->{
			SalaryGroupUser user  = new SalaryGroupUser();
			user.setGroupName(groupName);
			user.setGroupId(groupId);
			user.setEmployeeNo(u.getEmployeeNo());
			// 查找员工的姓名
			user.setName(u.getName());
			user.setDeptId(u.getDepartmentId());
			
			// 查看人员是否有定调薪记录， 没有则提示无定型人员 1000
			SalaryArchive lst = salaryArchiveRepository.findByNameAndEmployeeNo(u.getName(), u.getEmployeeNo());
			if(lst==null) {
				throw new RuntimeException("存在未定薪的人员，请先确保给所选人已经全部定薪");
			}
			grupusers.add(user);
			
			
		});
		salaryQueryMapper.deleteGroupUserByGroupId(groupId);
		// 插入人员 
		salaryGroupUserRepository.saveAll(grupusers);

		// 插入薪资组规则数据
		String  payRule = entity.getPayRule();
		JSONArray josn = JSONUtil.parseArray(payRule);
		for (Object obj : josn) {
			Document json = Document.parse(obj.toString());
			json.append("groupName", salaryGroup.getGroupName());
			json.append("groupId", entity.getId());
			Query query = new Query(Criteria.where("groupId").is(groupId).
					and("name").is(json.get("name")).and("groupName").is(salaryGroup.getGroupName()));
			Document doc =mongoTemplate.findOne(query, Document.class,SalaryConstant.GROUP_RULE);
			if(doc==null) {
				mongoTemplate.insert(json, SalaryConstant.GROUP_RULE);
			}else {
				Update update = Update.fromDocument(json);
				mongoTemplate.updateFirst(query, update, SalaryConstant.GROUP_RULE);
			}
		}
		
//		Query query = new Query(Criteria.where("groupId").is(entity.getId()));
//		List<Document> json= mongoTemplate.find(query, Document.class, SalaryConstant.GROUP_RULE);
//		grupusers.parallelStream().forEach(u-> {
//			for (Document doc : json) {
//				List<Document> items= doc.getList("salaryItems", Document.class);
//				items.forEach(it->{
//					Document rule = it.get("rule",Document.class);
//					String itemName = it.getString("item");
//					if(rule.getString("type").contains("get")) {// 数据源映射
//						// 从数据源获取
//						String value =getSalaryGroupRule(u.getEmployeeNo(),  u.getName(),rule.getString("name"), rule.getString("value"));
//						it.append("value", value);
//					}
//				});
//			}
//			Document doc = new Document();
//			doc.append("姓名", u.getName());
//			doc.append("员工号", u.getEmployeeNo());
//			doc.append("当前计薪月",salaryGroup.getMonth() );
//			doc.append("部门",u.getDeptId());
//			doc.append("薪资组", salaryGroup.getGroupName());
//			doc.append("groupId", groupId);
//			doc.append("orgId", TenantContext.getOrgId());
//			doc.append("groupInfo", json);
//			Query upsertQuery = new Query(Criteria.where("姓名")
//					.is( u.getName())
//					.and("员工号").is(u.getEmployeeNo())
//					.and("部门").is(u.getDeptId())
//					.and("薪资组").is(salaryGroup.getGroupName())
//					.and("groupId").is(groupId)
//					.and("orgId").is(TenantContext.getOrgId())
//					.and("当前计薪月").is(salaryGroup.getMonth()));
//			
//			Update update = Update.fromDocument(doc);
//			mongoTemplate.upsert(upsertQuery, update, SalaryConstant.SALARY_CURRENT);
//		});
		
		return groupId;

	}
	@Override
	public Pagination<GroupPageQueryRes> pageQuery(GroupPageQueryReq req) {
		Map<String, Object> params =  JSONUtil.parseObj(req);
		params.put("groupName"+"-op", Operator.Like);
		params.put("orgId",TenantContext.getOrgId() );
		params.put("page",req.getPageIndex()-1);
		params.put("size",req.getPageSize());
		params.put("state", req.getState());
		SearchResult<SalaryGroup> res = beanSearcher.search(SalaryGroup.class,params);
		List<GroupPageQueryRes> targ = BeanCopyUtil.copyListProperties(res.getDataList(), GroupPageQueryRes::new);

		targ.parallelStream().forEach(u->{
			// 
			SalaryGroupEmployeeVO vo= new SalaryGroupEmployeeVO();
			vo.setGroupId(u.getId());
			List<SalaryGroupEmployeeVO> lst = salaryQueryMapper.selectSalaryGroupEmployeeList(vo);
			List<String>nameLst = new ArrayList<>();
			List<String>noLst = new ArrayList<>();
			lst.parallelStream().forEach(s->{
				nameLst.add(s.getName());
				noLst.add(s.getEmployeeNo());
			});
			u.setPayEmp(StringUtils.collectionToCommaDelimitedString(nameLst));
			u.setPayEmpNo(StringUtils.collectionToCommaDelimitedString(noLst));
			u.setPayEmpSize(noLst.size());
		});
		return Pagination.create(req.getPageIndex()-1, req.getPageSize(), res.getTotalCount().intValue(),targ);
	}
	@Override
	@Transactional 
	public void deleteById(Long id) {
		// 算税中 发薪中 状态不能删除
		//		SalaryGroup entity = salaryGroupRepository.getById(id);
		salaryGroupRepository.deleteById(id);
		// 删除薪资组里面对应的人员
		salaryGroupUserRepository.deleteByGroupId(id);
		Query query = new Query(Criteria.where("groupId").is(id));
		mongoTemplate.remove(query, SalaryConstant.GROUP_RULE);
	}
	@Override
	public void batchDelGroupUser(BatchDelGroupUserReq req) {
		List<String> en = req.getEmployees();
		en.forEach(s->{
			SalaryGroupUser user = new SalaryGroupUser();
			user.setEmployeeNo(s);
			user.setGroupId(req.getGroupId());
			ExampleMatcher matcher = ExampleMatcher.matchingAll();
			Example<SalaryGroupUser> example = Example.of(user, matcher);
			List<SalaryGroupUser> one = salaryGroupUserRepository.findAll(example);
			salaryGroupUserRepository.deleteById(one.get(0).getId());

		});

	}
	@Override
	public List<ItemGroupReq> findItemGroup() {
		List<SalaryItemGroup> ls = salaryItemGroupRepository.findAll();

		return BeanCopyUtil.copyListProperties(ls, ItemGroupReq::new);
	}
	@Override
	public void itemGroupSave(ItemGroupReq req ) {
		SalaryItemGroup gorup = new SalaryItemGroup();
		if(req.getId()!=null) {
			gorup = salaryItemGroupRepository.getById(req.getId());
		}
		BeanCopyUtil.copyProperties(req, gorup);
		salaryItemGroupRepository.save(gorup);
	}
	@Override
	public void itemGroupDel(@NotNull Integer id) {
		salaryItemGroupRepository.deleteById(id);

	}
	@Override
	public Pagination<SalaryGroupEmployeeVO> list(SalaryGroupEmployeeVO req) {
		PageHelper.startPage(req.getPageIndex(), req.getPageSize());
		List<SalaryGroupEmployeeVO> lst = salaryQueryMapper.selectSalaryGroupEmployeeList(req);
		PageInfo<SalaryGroupEmployeeVO> pageInfo = new PageInfo<SalaryGroupEmployeeVO>(lst);
		return Pagination.create(pageInfo.getPageNum(),pageInfo.getPageSize(), pageInfo.getTotal(),pageInfo.getList());
	}
	@Override
	public List<SalaryOrgRes>  selectSalaryOrgList() {
		String orgId = TenantContext.getInstance().getUserContext().get().getOrganId();
		SalaryOrgReq req = new SalaryOrgReq();
		req.setOrgId(orgId);
		// 得到组织结构
		List<SalaryOrgRes> root = salaryQueryMapper.selectDeptTree(req);
		root.forEach(r->r.setChildren(getChildren(r.getId())));
		return root;
	}
	private List<SalaryOrgRes> getChildren(String parentId){
		SalaryOrgReq req = new SalaryOrgReq();
		req.setId(parentId);
		List<SalaryOrgRes> children = salaryQueryMapper.selectDeptTree(req);
		for (SalaryOrgRes salaryOrgRes : children) {
			salaryOrgRes.setChildren(getChildren(salaryOrgRes.getId()));
		}
		return children;
	}
	public List<SalaryOrgRes> getChildenTree(String parentName) {
		//		SalaryOrg po = new SalaryOrg();
		//		po.setParentName(parentName);
		//		List<SalaryOrg> child0 = salaryQueryMapper.selectSalaryOrgList(po);
		//		List<SalaryOrgRes> child= new ArrayList<SalaryOrgRes>();
		//		for (SalaryOrg salaryOrg : child0) {
		//			SalaryOrgRes re = new SalaryOrgRes();
		//			re.setName(salaryOrg.getName());
		//			child.add(re);
		//		}
		//		child.forEach(root -> root.setChildrenName(getChildenTree(root.getName())));
		return null;
	}
	@Override
	public List<EmployeeBasicRes> listDeptEmployee(DeptEmployeeReq req){
		String orgId = TenantContext.getInstance().getUserContext().get().getOrganId();
		req.setOrgId(orgId);
		List<EmployeeBasicRes> data = salaryQueryMapper.selectDepartEmployees(req);
		return data;

	}
	@Override
	public GroupStatisticsRes statistics(GroupStatisticsReq req) {
		SalaryUserCheckPageQuery query = new SalaryUserCheckPageQuery();
		query.setGroupId(req.getGroupId());
		List<SalaryArchive> lst = salaryQueryMapper.findGroupUserArchiveBy(query);
		
		SalaryGroup group = salaryGroupRepository.getById(req.getGroupId());
		query.setCreateTime(DateUtil.parse(group.getMonth(), "yyyy-MM"));
		List<SalaryArchive> lst2 = salaryQueryMapper.findGroupUserArchiveBy(query);
		
		
		
		GroupStatisticsRes res = new GroupStatisticsRes();
		res.setAdd(lst2.size());
		lst.parallelStream().forEach(u->{
	    	Map<String,Object>params= new HashMap<>();
	    	params.put("employeeNo", u.getEmployeeNo());
	    	params.put("name", u.getName());
	    	Map<String,Object> user = salaryQueryMapper.login(params);

	    	if(user.get("leave_time")!=null) {
	    		res.setLeaveCount(res.getLeaveCount()+1);
	    	}
	    	if(u.getChangeState()==null) {
	    		u.setChangeState(0);
	    		res.setUnCount(res.getUnCount()+1);
	    	}
	    	if(u.getChangeState()==2) {
	    		res.setChangeCount(res.getUnCount()+1);
	    	}
	    	
		});
		
		res.setPersonCount(lst.size());
		res.setInCount(res.getPersonCount()-res.getLeaveCount());
		res.setFormalCount(res.getInCount());
		return res;
	}
	@Override
	public void lock(GroupLockReq req) {
		SalaryGroup group = salaryGroupRepository.getById(req.getGroupId());
		group.setLockState(req.getLockState());
		group.setLockTime(new Date());
		salaryGroupRepository.save(group);
	}
	@Override
	public void createNext(GroupCreateNextReq req) {
		SalaryGroup group = salaryGroupRepository.getById(req.getGroupId());
		// 写入历史工资表
		
		group.setMonth(DateUtil.format(DateUtil.offsetMonth(DateUtil.parse(group.getMonth(),"yyyy-MM"), 1), "yyyy-MM"));
		group.setComputeState(0);
		salaryGroupRepository.save(group);
	}
	@Override
	public GroupPageQueryRes getById(Long groupId) {
		GroupPageQueryRes ob = new GroupPageQueryRes();
		SalaryGroup group = salaryGroupRepository.getById(groupId);
		BeanCopyUtil.copyProperties(group, ob);
		return ob;
	}
	private String getSalaryGroupRule(String employeeNo,String name, String source, String colName){

		SalaryConfig rec = new SalaryConfig();
		rec.setName(source);
		rec.setType("rule_source");
		ExampleMatcher matcher = ExampleMatcher.matchingAll();
		Example<SalaryConfig> example = Example.of(rec, matcher);
		List<SalaryConfig> lst = salaryConfigRepository.findAll(example);
		if(lst.isEmpty()) {
			return null;
		}
		SalaryConfig conf = lst.get(0);

		SalaryConfig colrec = new SalaryConfig();
		colrec.setName(colName);
		colrec.setType("rule_column");
		colrec.setExtra(conf.getValue());
		ExampleMatcher matcher2= ExampleMatcher.matchingAll();
		Example<SalaryConfig> example2 = Example.of(colrec, matcher2);
		List<SalaryConfig> lst2 = salaryConfigRepository.findAll(example2);
		SalaryConfig colconf=new SalaryConfig();
		if(!lst2.isEmpty()) {
			colconf = lst2.get(0);
		}

		SalaryQueryBean bean = new SalaryQueryBean();
		bean.setTable(conf.getValue());
		bean.setEmployeeNoCol("employee_no");
		bean.setNameCol("name");
		bean.setTargetCol(colconf.getValue());
		bean.setEmployeeNo(employeeNo);
		bean.setName(name);
		Map<String, Object> data = salaryQueryMapper.getValue(BeanUtil.beanToMap(bean));
		Assert.notNull(data, "参数={}", bean);
		String value = null;
		if(SalaryConstant.DATASOURCE_STATIC.equals(conf.getExtra().trim())) {
			if(data.get(bean.getTargetCol())!=null) {
				value= data.get(bean.getTargetCol()).toString();
			}
		}else {
			if(data.get("other_item")!=null) {
				JSONArray ja = JSONUtil.parseArray(data.get("other_item"));
				for (Object obj : ja) {
					if(JSONUtil.parseObj(obj).getStr("name").equals(colName)) {
						String value1= JSONUtil.parseObj(obj).getStr("vaule");
						value = value1;
					}
				}

			}

		}
		return value;
	}

}
