package com.bcxin.tenant.apis.impls;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.regex.Pattern;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.shaded.org.checkerframework.checker.units.qual.A;
import com.bcxin.Infrastructures.Pagination;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryCurrentService;
import com.bcxin.api.interfaces.salary.req.CurrentSalaryPagQueryReq;
import com.bcxin.api.interfaces.salary.req.CurrentUserAddReq;
import com.bcxin.api.interfaces.salary.req.PreTaxSalaryCommand;
import com.bcxin.api.interfaces.salary.req.SalaryAttendanceHead;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryPayrollHead;
import com.bcxin.api.interfaces.salary.req.SalaryStatisticsHead;
import com.bcxin.api.interfaces.salary.req.SalaryStatisticsPageReq;
import com.bcxin.api.interfaces.salary.req.SalaryTaxHead;
import com.bcxin.api.interfaces.salary.req.SalaryUserCheckPageQuery;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryRes;
import com.bcxin.tenant.apis.component.SalaryQueryBean;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.bcxin.tenant.domain.entities.SalaryArchive;
import com.bcxin.tenant.domain.entities.SalaryAttendance;
import com.bcxin.tenant.domain.entities.SalaryConfig;
import com.bcxin.tenant.domain.entities.SalaryGroup;
import com.bcxin.tenant.domain.entities.SalaryGroupUser;
import com.bcxin.tenant.domain.entities.SalaryImportRecord;
import com.bcxin.tenant.domain.entities.SalaryStatistics;
import com.bcxin.tenant.domain.entities.SalaryTax;
import com.bcxin.tenant.domain.repository.impls.SalaryArchiveRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryAttendanceRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryConfigRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryGroupRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryGroupUserRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryImportRecordRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryStatisticsRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryTaxRepository;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryCurrentServiceImpl implements ISalaryCurrentService{
	@Autowired
	private SalaryConfigRepository salaryConfigRepository;

	@Autowired
	private MongoTemplate mongoTemplate;

	@Autowired
	private SalaryGroupRepository salaryGroupRepository;

	@Autowired
	private SalaryImportRecordRepository salaryImportRecordRepository;

	@Autowired
	private SalaryArchiveRepository salaryArchiveRepository;

	@Autowired
	private SalaryGroupUserRepository salaryGroupUserRepository;

	@Autowired
	private SalaryAttendanceRepository salaryAttendanceRepository;
	@Autowired
	private SalaryTaxRepository salaryTaxRepository;

	@Autowired
	private SalaryStatisticsRepository salaryStatisticsRepository;

	@Autowired
	private SalaryQueryMapper salaryqueryMapper;

	@Override
	public Pagination<Map<String,Object>> pagelist(CurrentSalaryPagQueryReq req) {
		// 找出基本信息
		SalaryGroup group = salaryGroupRepository.getById(req.getGroupId());
		Page<SalaryGroupUser> users= salaryGroupUserRepository.findByGroupId(req.getGroupId(),PageRequest.of(req.getPageIndex()-1, req.getPageSize()));

		if(group.getComputeState()==0) {
			// 未算薪 解析薪资组规则 生成动态表头
			List<Document> datas = new ArrayList<>();
			users.getContent().parallelStream().forEach(u-> {
				Query query = new Query(Criteria.where("groupId").is(req.getGroupId()));
				List<Document> json= mongoTemplate.find(query, Document.class, SalaryConstant.GROUP_RULE);
				for (Document doc : json) {
					List<Document> items= doc.getList("salaryItems", Document.class);
					items.forEach(it->{
						Document rule = it.get("rule",Document.class);
						String itemName = it.getString("item");
						if(rule.getString("type").contains("get")) {// 数据源映射
							// 从数据源获取
							String value =getSalaryGroupRule(u.getEmployeeNo(),  u.getName(),rule.getString("name"), rule.getString("value"));
							it.append("value", value);
						}else if(rule.getString("type").contains("import")) {//手工导入
							// 手工导入
							Query floatQuery = new Query(Criteria.where("员工号").is(u.getEmployeeNo())
									.and("groupId").is(group.getId()).and("month").is(group.getMonth()))
									.with(Sort.by(Direction.DESC, "_id")).limit(1);
							Document floatData = mongoTemplate.findOne(floatQuery, Document.class, SalaryConstant.GROUP_FLOAT);
							if(floatData!=null) {
								it.append("value", floatData.get(itemName));
							}

						}
					});
				}
				Document doc = new Document();
				doc.append("姓名", u.getName());
				doc.append("员工号", u.getEmployeeNo());
				doc.append("当前计薪月",group.getMonth() );
				doc.append("部门",u.getDeptId() );
				doc.append("薪资组", group.getGroupName());
				doc.append("groupId", group.getId());
				doc.append("orgId", group.getOrgId());
				doc.append("groupInfo", json);
				datas.add(doc);
			});
			return Pagination.create(req.getPageIndex(), req.getPageSize(),users.getTotalElements(),datas);
		}

		Criteria criteria = new Criteria();
		String regex= String.format("%s%s%s", "^.*", req.getQueryStr(), ".*$");
		Pattern pattern = Pattern.compile(regex, Pattern.CASE_INSENSITIVE);

		if(StringUtils.hasLength(req.getQueryStr())) {
			criteria.and("姓名").regex(pattern).orOperator(Criteria.where("员工号").regex(pattern));
		}

		criteria.and("groupId").is(req.getGroupId());
		Query query = new Query(criteria);
		int totalCount = (int) mongoTemplate.count(query, Document.class,SalaryConstant.SALARY_CURRENT);
		query.with(PageRequest.of(req.getPageIndex()-1, req.getPageSize(), Sort.by(Direction.DESC, "当前计薪月")));
		List<Document>  lst = mongoTemplate.find(query, Document.class,  SalaryConstant.SALARY_CURRENT);


		//  查找基本信息 
		return Pagination.create(req.getPageIndex(), req.getPageSize(),totalCount,lst);
	}
	@Override
	public List<Map> list(String groupId) {
		SalaryGroup salaryGroup =salaryGroupRepository.getById(Long.valueOf(groupId));
		Criteria criteria = new Criteria();
		criteria.and("薪资组").is(salaryGroup.getGroupName());
		Query query = new Query();
		List<Map>  lst = mongoTemplate.find(query, Map.class,  SalaryConstant.SALARY_CURRENT);
		//  查找基本信息
		return lst;
	}
	@Override
	public void calSalary(Long groupId,int type) {
		/******算工资动态的生产表********/

		// 得到算薪组的算薪人员
		SalaryGroup group = salaryGroupRepository.getById(groupId);
		List<SalaryGroupUser> users = salaryGroupUserRepository.findByGroupId(groupId);

		users.parallelStream().forEach(salaryGroupUser-> {
			Map<String,Object> all = new LinkedHashMap<String, Object>();
			Map<String,Object> formula = new LinkedHashMap<String, Object>();
			Query query = new Query(Criteria.where("groupId").is(groupId));
			Set<String> colnames = new HashSet<String>();
			List<Document> json= mongoTemplate.find(query, Document.class, SalaryConstant.GROUP_RULE);
			for (Document doc : json) {
				List<Document> items= doc.getList("salaryItems", Document.class);
				items.forEach(it->{
					Document rule = it.get("rule",Document.class);
					String itemName = it.getString("item");

					colnames.add(itemName);
					if(rule.getString("type").contains("get")) {// 数据源映射
						// 从数据源获取
						String value =getSalaryGroupRule(salaryGroupUser.getEmployeeNo(),  salaryGroupUser.getName(),rule.getString("name"), rule.getString("value"));
						it.append("value", value);
						all.put(itemName, value==null?"0":value);

					}else if(rule.getString("type").contains("import")) {//手工导入
						// 手工导入
						Query floatQuery = new Query(Criteria.where("员工号").is(salaryGroupUser.getEmployeeNo())
								.and("groupId").is(groupId).and("month").is(group.getMonth()))
								.with(Sort.by(Direction.DESC, "_id")).limit(1);
						Document floatData = mongoTemplate.findOne(floatQuery, Document.class, SalaryConstant.GROUP_FLOAT);
						all.put(itemName,"0");
						if(floatData!=null) {
							it.append("value", floatData.get(itemName));
							all.put(itemName, floatData.get(itemName)==null?"0":floatData.get(itemName));
						}

					}else {
						formula.put(itemName, rule.get("value"));
						it.append("value", rule.get("value"));
					}
					//					
				});
			}


			Set<String> keys = new HashSet<String>();
			Set<String> nokeys = new HashSet<String>();
			Map<String,Object> haveValue = new LinkedHashMap<String, Object>();

			do {
				Iterator<Entry<String, Object> > datas = formula.entrySet().iterator();
				while(datas.hasNext()) {
					{
						Entry<String, Object> data = datas.next();
						//						if (keys.contains(data.getKey()) && keys.size() != formula
						//								.size()/* &&!NumberUtil.isNumber(data.getValue().toString()) */) {
						//							System.out.println("danger！！！");
						//							continue;
						//						}

						//						boolean f = false;
						//						for (String no : nokeys) {
						//							if(data.getValue().toString().contains(no)) {
						//								f=true;
						//								break;
						//							}
						//						}
						//						if(f) {
						//							continue;
						//						}
						// 公式的表达式
						String value=data.getValue().toString();
						// 拆解公式
						if(value.contains("应发合计()")||value.contains("应扣合计()")) {
							StringBuffer shouldPay = new StringBuffer("");
							StringBuffer shouldReduce = new StringBuffer("");
							for (Document doc : json) {
								List<Document> items= doc.getList("salaryItems", Document.class);
								for (Document it : items) {
									if(SalaryConstant.FORMULA_TAX_FRONT_PAY.equals(it.getString("taxFrontBack"))) {
										shouldPay.append(it.getString("value")==null?"0":it.getString("value"));
										shouldPay.append("+");
									}else if (SalaryConstant.FORMULA_TAX_FRONT_REDUCE.equals(it.getString("taxFrontBack"))) {
										shouldReduce.append(it.getString("value")==null?"0":it.getString("value"));
										shouldReduce.append("+");
									}

								}
							}
							value = value.replace("应发合计()", shouldPay.toString().equals("")?"0":shouldPay.toString().substring(0,shouldPay.toString().length()-1 ));
							value = value.replace("应扣合计()", shouldReduce.toString().equals("")?"0":shouldReduce.toString().substring(0,shouldReduce.toString().length()-1));
						}

						for(Entry<String, Object> non:all.entrySet()) {
							// 包含了沒有計算的值就直接過
							String regex ="(?<=op)|(?=op)".replace("op","[-+*/()]");
							String[] values = value.split(regex);
							for (String v : values) {
								if(v.equals(non.getKey())) {
									value=value.replace(v, non.getValue()==null?"0": non.getValue().toString());
								}
							}
							value = value.replace("如果", "if");
							value = value.replace("否则", "else");
							value = value.replace("max", "Math.max");
							value = value.replace("min", "Math.min");

						};
						data.setValue(value);
						// 计算应发工资
						ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
						try {

							// 計算完成賦值

							all.put(data.getKey(),  NumberUtil.round(jse.eval(value).toString(), 2).toString());
							haveValue.put(data.getKey(),  NumberUtil.round(jse.eval(value).toString(), 2).toString());
							System.err.println(formula);
							// 公式的值
							keys.add(data.getKey());
							// 算出就删掉
							datas.remove();
						} catch (ScriptException e) {
							//							System.out.println();
							nokeys.add(data.getKey());
							// 未計算出就删掉

						}
					}
				}
			}while(!formula.isEmpty());

			// 加入自定义公式的值
			for (Document doc : json) {
				List<Document> items= doc.getList("salaryItems", Document.class);
				items.forEach(it->{
					String itemName = it.getString("item");
					if(haveValue.containsKey(itemName)) {
						// 从数据源获取
						it.append("value", haveValue.get(itemName));
					}
				});
			}

			// 更改薪资组的状态:生成税前工资
			group.setState(1);
			group.setComputeState(1);
			if(type==1) {
				group.setComputeState(6);
			}
			salaryGroupRepository.save(group);


			// 持久化薪资项数据
			Document doc = new Document();
			doc.append("姓名", salaryGroupUser.getName());
			doc.append("员工号", salaryGroupUser.getEmployeeNo());
			doc.append("当前计薪月",group.getMonth() );
			doc.append("部门",salaryGroupUser.getDeptId() );
			doc.append("薪资组", group.getGroupName());
			doc.append("groupId", group.getId());
			doc.append("orgId", group.getOrgId());
			doc.append("groupInfo", json);
			Query upsertQuery = new Query(Criteria.where("姓名")
					.is( salaryGroupUser.getName())
					.and("员工号").is(salaryGroupUser.getEmployeeNo())
					.and("部门").is(salaryGroupUser.getDeptId())
					.and("薪资组").is(group.getGroupName())
					.and("groupId").is(group.getId())
					.and("orgId").is(group.getOrgId())
					.and("当前计薪月").is(group.getMonth()));

			Update update = Update.fromDocument(doc);
			mongoTemplate.upsert(upsertQuery, update, SalaryConstant.SALARY_CURRENT);

		});
	}
	@Override
	public void saveImportSalary(SalaryPayrollHead salaryNow) {
		SalaryImportRecord entity = new SalaryImportRecord();
		BeanCopyUtil.copyPropertiesIgNore(salaryNow, entity);
		salaryImportRecordRepository.save(entity);
	}
	@Override
	public Pagination<ArchivePageQueryRes> pageUserlist(SalaryUserCheckPageQuery req) {
		// 找出调薪组中的调薪人员 档案信息
		PageHelper.startPage(req.getPageIndex(), req.getPageSize());
		List<SalaryArchive> lst = salaryqueryMapper.findGroupUserArchiveBy(req);
		PageInfo<SalaryArchive> page = new PageInfo<SalaryArchive>(lst);

		List<ArchivePageQueryRes> targ = BeanCopyUtil.copyListProperties(page.getList(), ArchivePageQueryRes::new);
		targ.parallelStream().forEach(u->{
			Map<String,Object>params= new HashMap<>();
			params.put("employeeNo", u.getEmployeeNo());
			params.put("name", u.getName());
			Map<String,Object> user = salaryqueryMapper.login(params);
			u.setCertiType(user.getOrDefault("certi_type", "0").toString());
			u.setCertiNo(user.getOrDefault("certi_no", "").toString());
			u.setDept(user.getOrDefault("dept", "").toString());
			u.setPost(user.getOrDefault("post", "").toString());
			u.setHireDate((Date)user.getOrDefault("hire_date", null));
			u.setFormalTime((Date)user.getOrDefault("formal_time", null));
			u.setLeaveTime((Date)user.getOrDefault("leave_time", null));
		});
		return Pagination.create(req.getPageIndex(), req.getPageSize(), page.getTotal(),targ);

	}
	@Override
	public List<ArchivePageQueryRes> listPersonArchive(List<Long> ids) {
		// 找出调薪组中的调薪人员 档案信息
		List<SalaryArchive> page = salaryArchiveRepository.findByIdIn(ids);

		List<ArchivePageQueryRes> targ = BeanCopyUtil.copyListProperties(page, ArchivePageQueryRes::new);
		targ.parallelStream().forEach(u->{
			Map<String,Object>params= new HashMap<>();
			params.put("employeeNo", u.getEmployeeNo());
			params.put("name", u.getName());
			Map<String,Object> user = salaryqueryMapper.login(params);
			u.setCertiType(user.getOrDefault("certi_type", "0").toString());
			u.setCertiNo(user.getOrDefault("certi_no", "").toString());
			u.setDept(user.getOrDefault("dept", "").toString());
			u.setPost(user.getOrDefault("post", "").toString());
			u.setHireDate((Date)user.getOrDefault("hire_date", null));
			u.setFormalTime((Date)user.getOrDefault("formal_time", null));
			u.setLeaveTime((Date)user.getOrDefault("leave_time", null));
		});
		return targ;

	}
	@Override
	public void addEmployee(CurrentUserAddReq req) {
		SalaryGroupUser entity = new SalaryGroupUser();
		entity.setGroupId(req.getGroupId());
		SalaryGroup group = salaryGroupRepository.getById(req.getGroupId());
		entity.setGroupName(group.getGroupName());
		req.getPayEmp().forEach(s->{
			entity.setEmployeeNo(s);
			salaryGroupUserRepository.save(entity);
		});

	}
	@Override
	public void del(Long id) {
		SalaryImportRecord entity= salaryImportRecordRepository.getById(id);
		entity.setDeleted(1);
		salaryImportRecordRepository.save(entity);
	}
	@Override
	public void importFloat(List<Map<String,Object>>datas,Long groupId) {
		datas.forEach(params->{
			SalaryGroup group = salaryGroupRepository.getById(groupId);
			params.put("groupName", group.getGroupName());
			params.put("groupId", groupId);
			params.put("month", group.getMonth());
			Query upsertQuery = new Query();
			Criteria ct = new Criteria();
			for (Entry<String, Object> item : params.entrySet()) {
				ct.and(item.getKey()).is(item.getValue());
			}
			upsertQuery.addCriteria(ct);
			Document doc = Document.parse(JSON.toJSONString(params));
			Update update = Update.fromDocument(doc);
			mongoTemplate.upsert(upsertQuery,update, SalaryConstant.GROUP_FLOAT);
		});

	}
	@Override
	public void importAttendance(SalaryAttendanceHead req,Long groupId) {
		SalaryAttendance  entity = new SalaryAttendance();
		BeanCopyUtil.copyPropertiesIgNore(req, entity);
		SalaryGroup group = salaryGroupRepository.getById(groupId);
		entity.setMonth(group.getMonth());
		entity.setOrgId(TenantContext.getOrgId());
		entity.setGroupId(groupId);
		salaryAttendanceRepository.save(entity);
	}
	@Override
	public void importHisStastic(SalaryStatisticsHead item) {
		SalaryStatistics salaryStatistics = new SalaryStatistics();
		BeanCopyUtil.copyPropertiesIgNore(item, salaryStatistics);
		salaryStatisticsRepository.save(salaryStatistics);
	}
	@Override
	public Pagination<SalaryStatisticsHead> listStatistic(SalaryStatisticsPageReq req) {
		Sort sort = Sort.by(Direction.DESC,"createTime");
		Pageable pageable= PageRequest.of(req.getPageIndex()-1,req.getPageSize(),sort);
		Page<SalaryStatistics> page = salaryStatisticsRepository.findByMonth(req.getMonth(),pageable);
		List<SalaryStatisticsHead> lst = BeanCopyUtil.copyListProperties(page.getContent(), SalaryStatisticsHead::new);
		//  查找基本信息 
		return Pagination.create(req.getPageIndex(), req.getPageSize(), page.getTotalElements(),lst);
	}
	@Override
	public void delStastic(Long id) {
		salaryStatisticsRepository.deleteById(id);
	}
	@Override
	public List<SalaryStatisticsHead> listStatisticAll() {
		List<SalaryStatistics>  data = salaryStatisticsRepository.findAll();
		List<SalaryStatisticsHead> result = BeanCopyUtil.copyListProperties(data, SalaryStatisticsHead::new);
		return result;
	}

	private String getSalaryGroupRule(String employeeNo,String name, String source, String colName){

		SalaryConfig rec = new SalaryConfig();
		rec.setName(source);
		rec.setType("rule_source");
		ExampleMatcher matcher = ExampleMatcher.matchingAll();
		Example<SalaryConfig> example = Example.of(rec, matcher);
		List<SalaryConfig> lst = salaryConfigRepository.findAll(example);
		if(lst.isEmpty()) {
			return null;
		}
		SalaryConfig conf = lst.get(0);

		SalaryConfig colrec = new SalaryConfig();
		colrec.setName(colName);
		colrec.setType("rule_column");
		colrec.setExtra(conf.getValue());
		ExampleMatcher matcher2= ExampleMatcher.matchingAll();
		Example<SalaryConfig> example2 = Example.of(colrec, matcher2);
		List<SalaryConfig> lst2 = salaryConfigRepository.findAll(example2);
		SalaryConfig colconf=new SalaryConfig();
		if(!lst2.isEmpty()) {
			colconf = lst2.get(0);
		}

		SalaryQueryBean bean = new SalaryQueryBean();
		bean.setTable(conf.getValue());
		bean.setEmployeeNoCol("employee_no");
		bean.setNameCol("name");
		bean.setTargetCol(colconf.getValue());
		bean.setEmployeeNo(employeeNo);
		bean.setName(name);
		Map<String, Object> data = salaryqueryMapper.getValue(BeanUtil.beanToMap(bean));
		Assert.notNull(data, "参数={}", bean);
		String value = null;
		if(SalaryConstant.DATASOURCE_STATIC.equals(conf.getExtra().trim())) {
			if(data.get(bean.getTargetCol())!=null) {
				value= data.get(bean.getTargetCol()).toString();
			}
		}else {
			if(data.get("other_item")!=null) {
				JSONArray ja = JSONUtil.parseArray(data.get("other_item"));
				for (Object obj : ja) {
					if(JSONUtil.parseObj(obj).getStr("name").equals(colName)) {
						String value1= JSONUtil.parseObj(obj).getStr("vaule");
						value = value1;
					}
				}

			}

		}
		return value;
	}

	@Override
	public Map<String,Object> genFloatTemp(Long gorupId){
		Map<String,Object> rst = new HashMap<>();
		List<String> header = new ArrayList<String>();
		header.add("姓名");
		header.add("员工号");
		header.add("部门");
		Query query = new Query(Criteria.where("groupId").is(gorupId));
		List<Document> docs0 = mongoTemplate.find(query, Document.class, SalaryConstant.GROUP_RULE);
		docs0.forEach(doc0->{
			List<Document>  docs2 = doc0.getList("salaryItems", Document.class);
			docs2.forEach(doc2->{
				String itemName = doc2.getString("item");
				System.out.println(doc2.get("rule", Document.class));
				Document rule =doc2.get("rule", Document.class);
				if(rule.get("type").equals("import")) {
					//自定义导入
					header.add(itemName);
				}
			});
		});
		List<List<String>> dats = new ArrayList<>();
		List<SalaryGroupUser> lst = salaryGroupUserRepository.findByGroupId(gorupId);
		for (SalaryGroupUser salaryGroupUser : lst) {
			List<String> data = new ArrayList<String>();
			data.add(salaryGroupUser.getName());
			data.add(salaryGroupUser.getEmployeeNo());
			Map<String,Object>params= new HashMap<String, Object>();
			params.put("name", salaryGroupUser.getName());
			params.put("employeeNo", salaryGroupUser.getEmployeeNo());
			Map<String,Object> user = salaryqueryMapper.login(params);
			data.add(user.get("dept")==null?"":user.get("dept").toString());
			dats.add(data);
		}
		rst.put("header", header);
		rst.put("data", dats);
		return rst;

	}
	@Override
	public void updateSalaryLst(List<PreTaxSalaryCommand> commands) {
		for (PreTaxSalaryCommand command : commands) {
			Criteria crd = new Criteria();
			crd.and("员工号").is(command.get员工号());
			crd.and("姓名").is(command.get姓名());
			Query query = new Query(crd);
			Document doc = Document.parse(command.getGroupInfo());
			Update update = Update.fromDocument(doc);
			mongoTemplate.updateFirst(query, update, SalaryConstant.SALARY_CURRENT);
		}

	}
	@Override
	public Map<String, Object> checkExcelData(List<Map<String, Object>> datas) {
		List<Map<String, Object>>  rsts = new ArrayList<Map<String,Object>>();
		for (Map<String, Object> map : datas) {
			Map<String, Object> params = new HashMap<String, Object>();

			params.put("name", map.get("姓名"));
			params.put("organId",TenantContext.getOrgId());
			params.put("employeeNo", map.get("员工号"));
			Map<String,Object> user = salaryqueryMapper.login(params);
			if(user==null) {
				Map<String, Object> rst = new HashMap<String, Object>();
				rst.put("name",  map.get("姓名"));
				rst.put("employeeNo", map.get("员工号"));
				rst.put("errMsg", "员工信息匹配有误");
				rsts.add(rst);
			}

		}
		Map<String, Object> dt = new HashMap<String, Object>();
		dt.put("error", rsts);
		dt.put("data", datas);
		return dt;
	}
	@Override
	public List<SalaryGroupEmployeeVO> listGroupUser(Long groupId) {
		SalaryGroupEmployeeVO req = new SalaryGroupEmployeeVO();
		req.setGroupId(groupId);
		List<SalaryGroupEmployeeVO> lst = salaryqueryMapper.selectSalaryGroupEmployeeList(req);
		return lst;
	}
	@Override
	public void importTax(SalaryTaxHead item, Long groupId) {
		SalaryTax  entity = new SalaryTax();
		BeanCopyUtil.copyPropertiesIgNore(item, entity);
		SalaryGroup group = salaryGroupRepository.getById(groupId);
		entity.setMonth(group.getMonth());
		entity.setOrgId(TenantContext.getOrgId());
		entity.setGroupId(groupId);
		// 通过身份证号找到employeeNo
		Map<String,Object>params= new HashMap<>();
		params.put("certiNo", item.getCertiNo());
		params.put("name", item.getName());
		params.put("organId", TenantContext.getOrgId());
		Map<String,Object> user = salaryqueryMapper.login(params);
		if(user==null) {
			throw new RuntimeException("导入的姓名和身份证号不匹配");
		}
		entity.setEmployeeNo(user.get("employee_no").toString());
		salaryTaxRepository.save(entity);
	}
}
