package com.bcxin.tenant.apis.impls;

import java.util.List;
import java.util.Map;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mongodb.core.MongoTemplate;

import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryConfigService;
import com.bcxin.api.interfaces.salary.res.SalaryConfigRes;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.bcxin.tenant.domain.entities.SalaryConfig;
import com.bcxin.tenant.domain.repository.impls.SalaryConfigRepository;
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryConfigServiceImpl implements ISalaryConfigService{
	@Autowired
	private SalaryConfigRepository salaryConfigRepository;
	
	@Autowired
	private MongoTemplate mongoTemplate;
	
	
	
	
	@Override
	public List<SalaryConfigRes> findBy(String  type) {
		List<SalaryConfig> lst = salaryConfigRepository.findByType(type);
		
		List<SalaryConfigRes> targetList = BeanCopyUtil.copyListProperties(lst, SalaryConfigRes::new);
		return targetList;
	}
	
	@Override
	public void save(SalaryConfigRes res) {
		SalaryConfig entity  = salaryConfigRepository.getById(res.getId());
		BeanCopyUtil.copyPropertiesIgNore(res, entity);
		salaryConfigRepository.save(entity);
	}
	
   
	@Override
	public Object findBy(SalaryConfigRes res) {
		SalaryConfig entity  = salaryConfigRepository.getById(res.getId());
		if(SalaryConstant.DATASOURCE_STATIC.equals(entity.getExtra().trim())) {
			SalaryConfig rec = new SalaryConfig();
			rec.setExtra(entity.getValue());
			ExampleMatcher matcher = ExampleMatcher.matchingAll();
			Example<SalaryConfig> example = Example.of(rec, matcher);
			List<SalaryConfig> lst = salaryConfigRepository.findAll(example);
			return lst;
		}else {
			return mongoTemplate.findAll(Document.class, SalaryConstant.ARCHIVE_ITEM);
		}
    
    
	}
	public String test(String i) {
		System.out.println("test"+i);
		return "lihai";
	}
	public static void main(String[] args) throws ScriptException {
		// 测试公式
		String reg = "如果 (实际出勤天数>=应出勤天数)";
		String reg2 = "基本工资";
		reg2=reg2.replace("max", "Math.max");
		reg = reg.replace("如果", "if");
		reg = reg.replace("否则", "else");
		reg = reg.replace("否则 如果", "else if");
		reg = reg.replace("实际出勤天数", "20");
		reg = reg.replace("应出勤天数", "22");
		reg = reg.replace("基本工资", "50000");
		reg = reg.replace("基本工资", "50000");
	    ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
//	    System.out.println(jse.eval("new com.bcxin.tenant.apis.impls.SalaryConfigServiceImpl().test('1')"));
		System.out.println(jse.eval(reg2));
		
	}
}
