package com.bcxin.tenant.apis.impls;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.transaction.Transactional;

import org.apache.commons.collections4.map.HashedMap;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryArchiveService;
import com.bcxin.api.interfaces.rbacs.ISalaryChangeRecordService;
import com.bcxin.api.interfaces.salary.req.ArchiveChangePageQueryReq;
import com.bcxin.api.interfaces.salary.req.SalaryChangeRecordHead;
import com.bcxin.api.interfaces.salary.res.ArchiveChangePageQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchiveItemQueryRes;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
import com.bcxin.tenant.apis.dto.EmployeeChangeRecord;
import com.bcxin.tenant.domain.entities.SalaryArchive;
import com.bcxin.tenant.domain.entities.SalaryChangeRecord;
import com.bcxin.tenant.domain.repository.impls.SalaryArchiveRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryChangeRecordRepository;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.SearchResult;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

/**
 * <p>
 * 薪资档案 服务实现类
 * </p>
 *
 * @author James
 */
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryChangeRecordServiceImpl  implements ISalaryChangeRecordService {
	@Autowired
	private SalaryArchiveRepository salaryArchiveRepository;

	@Autowired
	private SalaryChangeRecordRepository salaryChangeRecordRepository;

	@Autowired
	private BeanSearcher beanSearcher;
	@Autowired
	private SalaryQueryMapper salaryQueryMapper;
	@Autowired
	private ISalaryArchiveService salaryArchiveService;

	@Override
	public Pagination<ArchiveChangePageQueryRes> queryRecordList(ArchiveChangePageQueryReq req ) {


		List<ArchiveItemQueryRes>  items = salaryArchiveService.queryItem();
		List<String>cloums= new ArrayList<>();
		List<List<Object>> datas = new ArrayList<>();
		List<String>dynamicCol = new ArrayList<String>();
		for (int i = 0; i < items.size(); i++) {
			cloums.add(items.get(i).getName());
			dynamicCol.add("调整前"+items.get(i).getName());
			dynamicCol.add("调整后"+items.get(i).getName());
			dynamicCol.add(items.get(i).getName()+"调整比例(%)");
		}
		// 从用户系统里拿到用户数据
		Map<String, Object> params =  JSONUtil.parseObj(req);
		params.put("name", req.getQueryStr());  
		params.put("name-op", "in");  
		params.put("validTime-0", req.getValidTimeFrom());
		params.put("validTime-1", req.getValidTimeTo());
		params.put("validTime-op", "bt");  
		params.put("createTime-0", req.getCreateTimeFrom());
		params.put("createTime-1", req.getCreateTimeTo());
		params.put("createTime-op", "bt");  
		params.put("page", req.getPageIndex()-1);                                      // 第 0 页
		params.put("size", req.getPageSize());  
		params.put("sort", "createTime");                                  // 按年龄字段排序
		params.put("order", "desc"); 
		params.put("orgId", TenantContext.getOrgId()); 
		params.put("validState", req.getValidState()); 
		SearchResult<EmployeeChangeRecord> res = beanSearcher.search(EmployeeChangeRecord.class,params);
		// transfer
		List<ArchiveChangePageQueryRes> lst = BeanCopyUtil.copyListProperties(res.getDataList(), ArchiveChangePageQueryRes::new);
	
		lst.forEach(rec->{
			// latest record
			List<SalaryChangeRecord> records = salaryQueryMapper.findByEmployeeNo(rec.getEmployeeNo(),rec.getId());
			SalaryChangeRecord record0=records.get(0); // 调整前
			JSONArray ar = JSONUtil.parseArray(record0.getOtherItem());
			Map<String,Object> pair = new LinkedHashMap<>();
			ar.forEach(js->{
				JSONObject json =  JSONUtil.parseObj(js);
				pair.put(json.getStr("name"), json.get("vaule"));
			});
			
			Map<String,Object> one = new LinkedHashMap<>();
			Map<String,Object> two = new LinkedHashMap<>();
			BigDecimal de = new BigDecimal("0");
			for (String col : cloums) {
				one.put(col, pair.get(col));
				two.put(col, null);
				if(ObjectUtil.isNotEmpty(pair.get(col))) {
					de = de.add(new BigDecimal(pair.get(col).toString()));
				}
			}
			if(records.size()==1) {
				// only one fixed record
				rec.setUnadjustedSalary(new BigDecimal("0.00"));
				rec.setJustedSalary(de);
			}else {
				if(rec.getType()==2) {
					// change salary
					SalaryChangeRecord record1=records.get(1); // 调整前
					JSONArray ar2 = JSONUtil.parseArray(record1.getOtherItem());
					Map<String,Object> pair2 = new LinkedHashMap<>();
					ar2.forEach(js->{
						JSONObject json =  JSONUtil.parseObj(js);
						pair2.put(json.getStr("name"), json.get("vaule"));
					});
					BigDecimal bfDe = new BigDecimal("0");
					for (String col : cloums) {
						two.put(col, pair2.get(col));
						if(ObjectUtil.isNotEmpty(pair2.get(col))) {
							bfDe = bfDe.add(new BigDecimal(pair2.get(col).toString()));
						}
					}
					rec.setUnadjustedSalary(bfDe);
					rec.setJustedSalary(de);
					rec.setJustedRatio(NumberUtil.decimalFormat("#.##%", NumberUtil.div(de.subtract(bfDe), bfDe, 2, RoundingMode.HALF_UP)));
				}
				
				
			}
			List<Object> single = new ArrayList<>();
			for (String col : cloums) {
				single.add(two.get(col));
				single.add(one.get(col));
				if(two.get(col)!=null) {
					single.add(NumberUtil.decimalFormat("#.##%", NumberUtil.div(new BigDecimal(one.get(col).toString()).subtract(new BigDecimal(two.get(col).toString())), new BigDecimal(one.get(col).toString()), 2, RoundingMode.HALF_UP)));
				}else {
					single.add(null);
				}
			}
			datas.add(single);
		});
		Pagination pg = Pagination.create(req.getPageIndex(), req.getPageSize(), res.getTotalCount().intValue(),lst);
		pg.setDynamicCol(dynamicCol);
		pg.setDynamicData(datas);
		return pg;
	}

	@Override
	@Transactional(rollbackOn = Exception.class)
	public void revokeChange(long id) {
		// get the  record
		SalaryChangeRecord record = salaryChangeRecordRepository.getById(id);

		SalaryArchive  arch  = salaryArchiveRepository.findByNameAndEmployeeNo( record.getName(),record.getEmployeeNo());

		Sort sort = Sort.by(Direction.DESC,"createTime");
		ExampleMatcher matcher = ExampleMatcher.matchingAll();
		SalaryChangeRecord rec = new SalaryChangeRecord();
		rec.setEmployeeNo(record.getEmployeeNo());
		rec.setName(record.getName());
		rec.setState(1);
		Example<SalaryChangeRecord> example = Example.of(rec, matcher);
		List<SalaryChangeRecord> records = salaryChangeRecordRepository.findAll(example,sort);
		SalaryChangeRecord one = records.get(0);
		if(record.getId().longValue()!=one.getId().longValue()) {
			// 如果不是最新的记录
			throw new RuntimeException("该笔定/调薪记录之后还存在别的定/调薪记录，请先撤销之后的定/调薪记录");
		}

		if(records.size()==1) {
			// 未定薪 直接删除记录
			salaryArchiveRepository.deleteById(arch.getId());

		}else {
			// 超过1条 恢复到最近的一条记录
			SalaryChangeRecord restore = records.get(1);

			arch.setOtherItem(restore.getOtherItem());
			arch.setChangeState(restore.getType());
			if(restore.getType()==1) {
			}else {
				arch.setValidState(restore.getValidState());
				arch.setValidTime(restore.getValidTime());
			}

			salaryArchiveRepository.save(arch);
		}

		one.setState(0);
		salaryChangeRecordRepository.save(one);
	}

	@Override
	public void batchRevokeChange(List<Long> ids) {
		for (Long id : ids) {
			this.revokeChange(id);
		}
	}

	@Override
	public Object getDetail(Long id) {
		// 得到最后一次调薪记录
		SalaryArchive salaryArchive = salaryArchiveRepository.getById(id);

		SalaryChangeRecord record = new SalaryChangeRecord();
		record.setEmployeeNo(salaryArchive.getEmployeeNo());
		Sort sort = Sort.by(Direction.DESC,"createTime");
		ExampleMatcher matcher = ExampleMatcher.matchingAll();
		Example<SalaryChangeRecord> example = Example.of(record, matcher);
		List<SalaryChangeRecord> records = salaryChangeRecordRepository.findAll(example,sort);
		// 最新的调薪一条记录
		return records.get(0);
	}


	@Override
	public List<SalaryChangeRecordHead> getExportData(){
		SearchResult<EmployeeChangeRecord> res = beanSearcher.search(EmployeeChangeRecord.class,new HashedMap<String, Object>());

		List<SalaryChangeRecordHead> lst = BeanCopyUtil.copyListProperties(res.getDataList(), SalaryChangeRecordHead::new);
		return lst;
	}



}
