package com.bcxin.tenant.apis.impls;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.dubbo.config.annotation.DubboService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.Pagination;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.rbacs.ISalaryArchiveService;
import com.bcxin.api.interfaces.salary.req.ArchiveChangeReq;
import com.bcxin.api.interfaces.salary.req.ArchiveFixedNameVReq;
import com.bcxin.api.interfaces.salary.req.ArchiveFixedReq;
import com.bcxin.api.interfaces.salary.req.ArchiveItemEditReq;
import com.bcxin.api.interfaces.salary.req.ArchivePageQueryReq;
import com.bcxin.api.interfaces.salary.res.ArchiveItemQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryExport;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchiveTotalQueryRes;
import com.bcxin.tenant.apis.constants.SalaryConstant;
import com.bcxin.tenant.apis.dto.EmployeeArchive;
import com.bcxin.tenant.domain.entities.SalaryArchive;
import com.bcxin.tenant.domain.entities.SalaryChangeRecord;
import com.bcxin.tenant.domain.repository.impls.SalaryArchiveRepository;
import com.bcxin.tenant.domain.repository.impls.SalaryChangeRecordRepository;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.SearchResult;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

/**
 * <p>
 * 薪资档案 服务实现类
 * </p>
 *
 * @author James
 */
@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class SalaryArchiveServiceImpl  implements ISalaryArchiveService {
	@Autowired
	private SalaryArchiveRepository salaryArchiveRepository;
	@Autowired
	private SalaryChangeRecordRepository salaryChangeRecordRepository;

	@Autowired
	private BeanSearcher beanSearcher;

	@Autowired
	private MongoTemplate mongoTemplate;



	@Override
	public Pagination<ArchivePageQueryRes> queryArchlist(ArchivePageQueryReq req ) {
		TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
		// 从用户系统里拿到用户数据
		Map<String, Object> params =  JSONUtil.parseObj(req);
		params.put("name-op", "in");  
		params.put("employeeNo-op", "in");
		params.put("name-op", "in");  
		params.put("hireDate-0", req.getStartTime());
		params.put("hireDate-1", req.getEndTime());
		params.put("hireDate-op", "bt");  
		params.put("formalTime-0", req.getFormalStartTime());
		params.put("formalTime-1", req.getFormalEndTime());
		params.put("formalTime-op", "bt");  
		params.put("leaveTime-op", "bt");  
		params.put("leaveTime-0", req.getLeaveTimeFrom());  
		params.put("leaveTime-1", req.getLeaveTimeTo());  
		params.put("page", req.getPageIndex()-1);                                      // 第 0 页
		params.put("size", req.getPageSize());     
		params.put("sort", "updateTime");                                  // 按年龄字段排序
		params.put("order", "desc"); 
		params.put("orgId", currentUser.getOrganId()); 
		SearchResult<EmployeeArchive> res = beanSearcher.search(EmployeeArchive.class,params);
		List<ArchivePageQueryRes> targetList = BeanCopyUtil.copyListProperties(res.getDataList(), ArchivePageQueryRes::new);

		List<ArchiveItemQueryRes>  items = this.queryItem();
		List<String>cloums= new ArrayList<>();
		List<List<Object>> datas = new ArrayList<>();

		for (int i = 0; i < items.size(); i++) {
			cloums.add(items.get(i).getName());
		}

		targetList.forEach(t->{
			JSONArray ar = JSONUtil.parseArray(t.getOtherItem());
			Map<String,Object> pair = new HashMap<>();
			ar.forEach(js->{
				JSONObject json =  JSONUtil.parseObj(js);
				pair.put(json.getStr("name"), json.get("vaule"));
			});
			List<Object> lst = new ArrayList<>();
			BigDecimal de = new BigDecimal("0");
			for (String col : cloums) {
				lst.add(pair.get(col));
				if(ObjectUtil.isNotEmpty(pair.get(col))) {
					de = de.add(new BigDecimal(pair.get(col).toString()));
				}
			}
			t.setLatestTotalSalary(de);
			datas.add(lst);
		});
		System.out.println(cloums);
		System.out.println(datas);
		Pagination pag = Pagination.create(req.getPageIndex(), req.getPageSize(), res.getTotalCount().intValue(),targetList);
		pag.setDynamicCol(cloums);
		pag.setDynamicData(datas);
		return pag ;
	}

	@Override
	public List<ArchiveItemQueryRes> queryItem() {
		Query query = new Query(Criteria.where("orgId").is(TenantContext.getOrgId()));
		query.with(Sort.by(Direction.ASC, "sort"));

		List<Map> ls1 = mongoTemplate.find(query,Map.class, SalaryConstant.ARCHIVE_ITEM);
		List<ArchiveItemQueryRes> lst = new ArrayList<ArchiveItemQueryRes>();
		ls1.forEach(map->{
			ArchiveItemQueryRes bean = BeanUtil.toBean(map, ArchiveItemQueryRes.class);
			bean.setId(map.get("_id").toString());
			lst.add(bean);
		});
		return  lst;
	}

	@Override
	public void itemedit(List<ArchiveItemEditReq> req) {
		// 如果有id 则编辑  无则更新
		//		BulkOperations operations = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, SalaryConstant.ARCHIVE_ITEM);
		for (ArchiveItemEditReq archiveItemEditReq : req) {
			archiveItemEditReq.setOrgId(TenantContext.getOrgId());
			Document document = Document.parse(JSONUtil.parseObj(archiveItemEditReq).toString());
			if(archiveItemEditReq.getId()==null) {

				mongoTemplate.insert(archiveItemEditReq,SalaryConstant.ARCHIVE_ITEM);
			}else {
				Query query = new Query(Criteria.where("_id").is(archiveItemEditReq.getId()));
				Update update = Update.fromDocument(document);
				mongoTemplate.updateFirst(query, update, SalaryConstant.ARCHIVE_ITEM);
				//				operations.upsert(query, update);
			}

		}
		// 批量执行
		//        operations.execute();


	}

	@Override
	public void itemedel(String id) {
		Query query = new Query(Criteria.where("_id").is(id));
		mongoTemplate.remove(query,  SalaryConstant.ARCHIVE_ITEM);

	}

	@Override
	public ArchiveTotalQueryRes getTotalByBasic(ArchiveFixedReq req) {
		// 查出薪资档案 0 不折算 1 按工作日 2 按工作日包含 节假日  3 按自然日
		ArchiveTotalQueryRes data = new ArchiveTotalQueryRes();
		List<ArchiveFixedNameVReq> items = req.getItem();
		BigDecimal res = new BigDecimal("0");
		for (ArchiveFixedNameVReq archiveFixedNameVReq : items) {
			res = res.add(new BigDecimal(archiveFixedNameVReq.getVaule()));
		}
		data.setTotalalary(res);
		return data;
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public ArchiveTotalQueryRes fixSalary(ArchiveFixedReq req) {

		SalaryArchive arch = salaryArchiveRepository.findByNameAndEmployeeNo(req.getName(), req.getEmployeeNo());
		if(arch==null) {
			// 还没有定调过薪资
			arch = new SalaryArchive();
			arch.setEmployeeNo(req.getEmployeeNo());
			arch.setName(req.getName());

		}
		arch.setOrgId(TenantContext.getOrgId());
		// fixed salary record
		List<ArchiveFixedNameVReq> items = req.getItem();
		String oterItem = JSON.toJSONString(items);
		SalaryChangeRecord record = new SalaryChangeRecord();
		record.setOtherItem(oterItem);
		record.setType(1);
		record.setState(1);
		ArchiveTotalQueryRes res = getTotalByBasic(req);
		record.setHandlerName(TenantContext.getUserContext().get().getName());
		record.setEmployeeNo(req.getEmployeeNo());
		record.setName(req.getName());
		record.setOrgId(TenantContext.getOrgId());
		salaryChangeRecordRepository.save(record);

		arch.setChangeState(1); 
		arch.setOtherItem(oterItem);
		arch.setOrgId(TenantContext.getOrgId());
		salaryArchiveRepository.save(arch);

		return null;
	}

	@Override
	@Transactional(rollbackFor = Exception.class)
	public void changeSalary(ArchiveChangeReq req) {

		// get salary archive
		SalaryArchive arch = salaryArchiveRepository.findByNameAndEmployeeNo(req.getName(), req.getEmployeeNo());


		// get change salary record
		List<ArchiveFixedNameVReq> items = req.getItem();
		String oterItem = JSON.toJSONString(items);
		SalaryChangeRecord record = new SalaryChangeRecord();
		record.setOtherItem(oterItem);
		record.setType(2);
		record.setState(1);
		record.setEmployeeNo(arch.getEmployeeNo());
		record.setOrgId(TenantContext.getOrgId());

		ArchiveTotalQueryRes res = getTotalByBasic(req);
		// 未调薪时的总工资
//		record.setJustedSalary(res.getTotalalary());
		record.setEmployeeNo(arch.getEmployeeNo());
		record.setName(arch.getName());
		record.setHandlerName(TenantContext.getUserContext().get().getName());
		record.setHandler(TenantContext.getUserContext().get().getEmployeeId().toString());
		record.setValidTime(req.getValidTime());
		if(new Date().compareTo(req.getValidTime())>=0) {
			record.setValidState(1);
			arch.setOtherItem(oterItem);
		}

		record.setOtherItem(oterItem);
		record.setRemark(req.getRemark());
		salaryChangeRecordRepository.save(record);

		arch.setChangeState(2); 
		arch.setValidState(record.getValidState());
		arch.setValidTime(record.getValidTime());
		salaryArchiveRepository.save(arch);
	}

	@Override
	public ArchiveTotalQueryRes getFixedDetail(long id) {
		SalaryArchive arc = salaryArchiveRepository.getById(id);
		ArchiveTotalQueryRes res = new ArchiveTotalQueryRes();
		res.setEmployeeNo(arc.getEmployeeNo()+"");
		res.setName(arc.getName());
		List<ArchiveItemQueryRes>  items = this.queryItem();
		List<String>cloums= new ArrayList<>();
		for (int i = 0; i < items.size(); i++) {
			cloums.add(items.get(i).getName());
		}
		JSONArray ar = JSONUtil.parseArray(arc.getOtherItem());
		Map<String,Object> pair = new HashMap<>();
		ar.forEach(js->{
			JSONObject json =  JSONUtil.parseObj(js);
			pair.put(json.getStr("name"), json.get("vaule"));
		});
		BigDecimal de = new BigDecimal("0");
		Map<String,Object>other = new LinkedHashMap<String, Object>();
		for (String col : cloums) {
			if(ObjectUtil.isNotEmpty(pair.get(col))) {
				BigDecimal vl = new BigDecimal(pair.get(col).toString());
				de = de.add(vl);
			}
			other.put(col, pair.get(col));
		}
		res.setTotalalary(de);

		res.setItems(JSONUtil.toJsonStr(other));
		return res;
	}

	@Override
	public void importFixedSalary(Map<String,Object> dto) {
		String state = "转正";
		List<ArchiveFixedNameVReq> archItems = new ArrayList<ArchiveFixedNameVReq>();
		for (Entry<String, Object> entry : dto.entrySet()) {
			if(entry.getKey().trim().equals("汇总金额")) {
				continue;
			}
			if("姓名".equals(entry.getKey().trim())|| "员工号".equals(entry.getKey().trim())) {
				continue;
			}
			if("试用".equals(state)&&entry.getKey().trim().contains("当前")) {
				// 员工状态为使用 则区基本工资,否则取转正后的工资
				ArchiveFixedNameVReq item = new ArchiveFixedNameVReq();
				item.setName(entry.getKey().split("当前")[1]);
				item.setVaule(entry.getValue().toString());
				archItems.add(item);
			}else if("转正".equals(state)&&entry.getKey().trim().contains("转正")) {
				ArchiveFixedNameVReq item = new ArchiveFixedNameVReq();
				item.setName(entry.getKey().split("转正后")[1]);
				item.setVaule(entry.getValue().toString());
				archItems.add(item);
			}

		}

		ArchiveFixedReq req = new ArchiveFixedReq();
		req.setEmployeeNo(dto.get("员工号").toString());
		req.setName(dto.get("姓名").toString());
		req.setItem(archItems);
		this.fixSalary(req);

	}

	@Override
	public void importChangeSalary(Map<String,Object> dto) {

		List<ArchiveFixedNameVReq> archItems = new ArrayList<ArchiveFixedNameVReq>();

		for (Entry<String, Object> entry : dto.entrySet()) {
			if ("姓名".equals(entry.getKey().trim()) || "员工号".equals(entry.getKey().trim())
					|| "生效日期".equals(entry.getKey().trim()) 
					|| "调薪原因".equals(entry.getKey().trim())|| "部门".equals(entry.getKey().trim())) {
				continue;
			}
			ArchiveFixedNameVReq item = new ArchiveFixedNameVReq();
			item.setName(entry.getKey().split("调整后")[1]);
			item.setVaule(entry.getValue().toString());
			archItems.add(item);
		}

		ArchiveChangeReq req = new ArchiveChangeReq();
		req.setEmployeeNo(dto.get("员工号").toString());
		req.setName(dto.get("姓名").toString());
		req.setItem(archItems);
		req.setRemark(dto.get("调薪原因").toString());
		req.setValidTime(DateUtil.parse(dto.get("生效日期").toString()));
		this.changeSalary(req);

	}

	@Override
	public List<ArchivePageQueryExport> export(ArchivePageQueryReq req) {
		// 得到信息
		Map<String, Object> params =  JSONUtil.parseObj(req);
		params.put("name-op", "in");  
		params.put("employeeNo-op", "in");  
		params.put("hireDate-0", req.getStartTime());
		params.put("hireDate-1", req.getEndTime());
		params.put("hireDate-op", "bt");  
		params.put("formalTime-0", req.getFormalStartTime());
		params.put("formalTime-1", req.getFormalEndTime());
		params.put("formalTime-op", "bt");  
		params.put("sort", "updateTime"); 
		params.put("order", "desc"); 
		params.put("changeState-op", "in");
		params.put("changeState-0", 1);
		params.put("changeState-1", req.getChangeState());
		params.put("orgId", TenantContext.getOrgId());
		List<String>employeeNos = req.getEmployeeNos();
		if(!employeeNos.isEmpty()) {
			params.put("employeeNo-op", "mv"); 
			for (int i = 0; i < employeeNos.size(); i++) {
				params.put("employeeNo-"+i, employeeNos.get(i)); 
			}
		}

		List<EmployeeArchive> res = beanSearcher.searchAll(EmployeeArchive.class,params);
		List<ArchivePageQueryExport> targetList = BeanCopyUtil.copyListProperties(res, ArchivePageQueryExport::new);
		return targetList;

	}
}
