package com.bcxin.tenant.apis.dto;

import java.util.Map;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.alibaba.fastjson.JSONObject;

import lombok.Data;

@Data
@Document(collection = "salaryArchiveItem") //指定集合名字
public class SalaryArchiveItemDoc {

    @Id //这个注解标识该字段对应集合里的每一行数据的mongo自定义生成的主键（16进制）
    private String objectId;

    @Field("NAME") //使用该注解可以修改存入到mongo里的字段名
    private String name;

    private Map<String, Object> map;

    private JSONObject aliJson;
}
