package com.bcxin.tenant.apis.dto;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.persistence.Id;

import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.format.annotation.DateTimeFormat;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.BeanCopyUtil;
import com.bcxin.api.interfaces.salary.cmd.PayrollSendCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrolllUploadCmd;
import com.fasterxml.jackson.annotation.JsonFormat;

import cn.hutool.core.lang.ObjectId;
import lombok.Data;

@Data
@Document("salary_payroll")
public class Payroll extends EntityAbstract implements IAggregate{
	private static final long serialVersionUID = 1L;
	@Id
	private String id;
	/**批次*/
	private String batchNo;
	/**薪资类型 0 工资 */
	private int salaryType=0;
	/**工资单名称*/
	private String payrollName;
	/**工资发放日期*/
	private String payrollDate;
	/**工资发放日期*/
	private String payrollMonth;
	/**计薪月*/
	private String month;
	/**总金额*/
	private BigDecimal totalMoney=new BigDecimal("0");
	/**总笔数*/
	private int totalCount;
	/**员工已读数*/
	private int readCount=0;
	/**员工已确认数*/
	private int confirmCount=0;
	/**撤回员工数*/
	private int revokeCount=0;
	/**员工反馈数*/
	private int feedBackCount=0;
	/**发送状态 0 待提交  1 待发送  2 部分发送  3 已发送 */
	private Integer sendStatus=0;
	/**审批状态 */
	private Integer approveStatus;
	/**审批人 */
	private String approver;
	/**审批人ID */
	private String approverId;
	/**备注 */
	private String remark;
	/**币种 0 表示人民币 */
	private int currency=0;
	/**员工识别码 0 证件号码  1 银行卡号 */
	private Integer IdCode;
	/**0 普通上传 1 智能上传  2 薪资组生成*/
	private Integer upType;
	
	/**上传时间(发送时间) */
	private Date createTime;
	
	/**问候语*/
	private String greet;
	/**温馨提示*/
	private String hint;
	/**限时查看*/
	private Integer time;
	/**限时查看单位*/
	private int unit;
	
	/**预约时间*/
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm",timezone="GMT+8")
	private Date appointTime;
	
	/**组织ID*/
	private String orgId;

	List<PayrollDetail> details=new ArrayList<PayrollDetail>();
	public void setDetails(List<PayrollDetail> deails) {
		this.details=deails;
		for (PayrollDetail payrollDetail : deails) {
			this.totalCount=this.totalCount+1;
			this.totalMoney=this.totalMoney.add(payrollDetail.getActualPay());
		}
	}

	public Payroll(String orgId) {
		this.orgId=orgId;
		this.batchNo=new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
		this.createTime=new Date();

	}
	public Payroll create(PayrolllUploadCmd cmd) {

		BeanCopyUtil.copyProperties(cmd, this);
		this.addPayRollDetail(cmd.getDetails(),cmd.isFlag());
		if(this.payrollDate!=null && !"".equals(this.payrollDate) ) {
			this.payrollMonth=this.payrollDate.substring(0,7);
		}
		return this;
	}
     
	public void addPayRollDetail(List<Map<String,Object>>datas,boolean flag) {
		for (Map<String, Object> data : datas) {
			PayrollDetail detail = new PayrollDetail();
			if(this.sendStatus==1) {
				// 待发送
				detail.setPayroolState(0);
			}else if(this.sendStatus==3) {
				// 已发送
				detail.setPayroolState(1);
			}
			detail.setReadState(0);
			detail.setPayrollItemId(ObjectId.next());
			detail.setName(data.get("姓名")==null?data.get("name")+"":data.get("姓名")+"");
			detail.setCeityType(data.get("证件类型")==null?data.get("ceityType")+"":data.get("证件类型")+"");
	    	if(data.get("证件号码")==null&&data.get("银行卡号")==null
	    			&&data.get("ceityNo")==null&&data.get("bankNo")==null) {
	    		throw new RuntimeException(data.get("姓名")+"证件号或者银行卡号为空");
	    	}
	    	detail.setCeityNo(data.get("证件号码")==null?data.get("ceityNo")+"":data.get("证件号码")+"");
	    	detail.setBankNo(data.get("银行卡号")==null?data.get("bankNo")+"":data.get("银行卡号")+"");
	    	detail.setActualPay(new BigDecimal(data.get("实发金额")==null?data.get("actualPay")+"":data.get("实发金额")+""));
//	    	detail.setEmail(data.get("邮箱地址")==null?data.get("email")+"":data.get("邮箱地址")+"");
	    	detail.setPhone(data.get("手机号")==null?data.get("phone")+"":data.get("手机号")+"");
	    	data.remove("姓名");
	    	data.remove("证件类型");
	    	data.remove("银行卡号");
	    	data.remove("证件号码");
	    	data.remove("实发金额");
	    	data.remove("邮箱地址");
	    	data.remove("手机号");
//	    	data.remove("name");
//	    	data.remove("ceityNo");
//	    	data.remove("ceityType");
//	    	data.remove("bankNo");
//	    	data.remove("actualPay");
//	    	data.remove("email");
//	    	data.remove("phone");
	    	detail.setOther(data);
	    	if(flag) {
	        	detail.setOther((Map)data.get("other"));
	    	}
	    	
			details.add(detail);
			
			this.totalCount=this.totalCount+1;
			this.totalMoney=this.totalMoney.add(detail.getActualPay());
		}

	}
	
	public Payroll genPayroll(PayrollSendCmd cmd) {
		BeanCopyUtil.copyProperties(cmd, this);
		this.setSendStatus(0); // 薪资组生成 初始化待提交
		if(this.payrollDate!=null && !"".equals(this.payrollDate) ) {
			this.payrollMonth=this.payrollDate.substring(0,7);
		}
		return this;
	}
	
}
