package com.bcxin.tenant.apis.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.ejlchina.searcher.bean.DbField;
import com.ejlchina.searcher.bean.SearchBean;

import lombok.Data;
@Data
@SearchBean(tables="(  SELECT i.*,  s.basic_salary,s.valid_state,s.valid_time,s.justed_salary,\r\n" + 
		"s.unadjusted_salary, s.`type`,  s.remark ,s.id,s.other_item,s.handler_name,s.create_time,s.justed_ratio  \r\n" + 
		" FROM employee_info i  \r\n" + 
		" JOIN salary_change_record  s ON s.name=i.name AND i.employee_no=s.employee_no and s.state=1 ) t")
public class EmployeeChangeRecord implements Serializable{
	/**记录ID*/
	@DbField("t.id")
	private Long id;
	@DbField("t.basic_salary")
	private BigDecimal basicSalary;
	@DbField("t.justed_salary")
	private BigDecimal justedSalary;
	@DbField("t.unadjusted_salary")
	private BigDecimal unadjustedSalary;
	@DbField("t.type")
	private Integer type;
	@DbField("t.remark")
	private String remark;
    @DbField("t.organization_id")
    private String orgId;
	/**
	 * 生效时间
	 */
	@DbField("t.valid_time")
	private Date validTime;

	/**
	 * 生效状态
	 */
	@DbField("t.valid_state")
	private Integer validState;


	/**
	 * 调整比例
	 */
	@DbField("t.justed_ratio")
	private String justedRatio;
	//    		 NumberUtil.div(unadjustedSalary, unadjustedSalary, 2).multiply(new BigDecimal("100")).toString();

	/**
	 * 经办人
	 */
	@DbField("t.handler_name")
	private String handlerName;

	/**
	 * 创建时间
	 */
	@DbField("t.create_time")
	private Date createTime;


	/**
	 *薪资档案项
	 */
	@DbField("t.other_item")
	private String otherItem;

	// 姓名
	@DbField("t.name")
	private String name;
	// 员工号 jobNumber
	@DbField("t.employee_no")
	private String employeeNo;
	// 证件类型 credentialType
	@DbField("t.certi_type")
	private Integer certiType;
	// 证件号码 credentialNumber
	@DbField("t.certi_no")
	private String certiNo;	
	// 部门 department
	@DbField("t.dept")
	private String dept;
	// 岗位 position
	@DbField("t.post")
	private String post;
	// 员工状态 status
	@DbField("t.employ_state")
	private Integer employState;
	// 员工类型 OccupationType
	@DbField("t.employ_type")
	private Integer employType;
	// 入职时间 hiredDate
	@DbField("t.hire_date")
	private Date hireDate;
	// 转正时间 positiveDate
	@DbField("t.formal_time")
	private Date formalTime;
	// 离职时间 leaveTime
	@DbField("t.leave_time")
	private Date leaveTime;
}
