package com.bcxin.tenant.apis.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.ejlchina.searcher.bean.DbField;
import com.ejlchina.searcher.bean.SearchBean;

import lombok.Data;
@Data
@SearchBean(tables="(SELECT i.*, IFNULL(s.change_state,0) AS change_state, s.basic_salary, s.latest_total_salary,\r\n" + 
		"s.id,s.other_item,s.update_time FROM employee_info i  \r\n" + 
		"  left JOIN salary_archive  s ON s.name=i.name AND i.employee_no=s.employee_no) t")
public class EmployeeArchive implements Serializable{
	 /**记录ID*/
	@DbField("t.id")
    private Long id;
    /**
     *  调薪状态 0 未定薪 1 定薪 2 调薪*/
    @DbField("t.change_state")
    private Integer changeState;
    @DbField("t.basic_salary")
    private BigDecimal basicSalary;
    @DbField("t.latest_total_salary")
    private BigDecimal latestTotalSalary;
    @DbField("t.update_time")
    private Date updateTime;
    
    /**
     *薪资档案项
     */
    @DbField("t.other_item")
    private String otherItem;
    
 // 姓名
    @DbField("t.name")
    private String name;
    // 员工号 jobNumber
    @DbField("t.employee_no")
    private String employeeNo;
    // 证件类型 credentialType
    @DbField("t.certi_type")
    private Integer certiType;
    // 证件号码 credentialNumber
    @DbField("t.certi_no")
    private String certiNo;	
    // 部门 department
    @DbField("t.dept")
    private String dept;
    @DbField("t.organization_id")
    private String orgId;
    // 岗位 position
    @DbField("t.post")
    private String post;
    // 员工状态 status
    @DbField("t.employ_state")
    private Integer employState;
    // 员工类型 OccupationType
    @DbField("t.employ_type")
    private Integer employType;
    // 入职时间 hiredDate
    @DbField("t.hire_date")
    private Date hireDate;
    // 转正时间 positiveDate
    @DbField("t.formal_time")
    private Date formalTime;
    // 离职时间 leaveTime
    @DbField("t.leave_time")
    private Date leaveTime;
    @DbField("t.phone")
    private String phone;
}
