package com.bcxin.tenant.apis.component;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.bcxin.tenant.apis.component.SalaryQueryMapper;
import com.bcxin.tenant.domain.entities.PayrollConfig;
import com.bcxin.tenant.domain.repository.impls.SalaryPayrollConfigRepository;

@Component
public class SalaryTask {

	@Autowired
	SalaryPayrollConfigRepository salaryPayrollConfigRepository;
	@Autowired
	SalaryQueryMapper salaryQueryMapper;
	@Autowired
	MongoTemplate mongoTemplate;
	/**
	 * 每隔一个小时检查
	 */
	@Scheduled(fixedDelay = 60 * 60 * 1000)
	public void checkCouponExpired() {
		PayrollConfig config = salaryPayrollConfigRepository.findAll().get(0);
		int way = JSON.parseObject(config.getConfirmWay()).getInteger("way");
		String value = JSON.parseObject(config.getConfirmWay()).getString("value");
		if(way>0 && value !=null) {
			// 自动确认
			
		}
	}
}
