package com.bcxin.tenant.apis.component;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.bcxin.api.interfaces.salary.req.DeptEmployeeReq;
import com.bcxin.api.interfaces.salary.req.SalaryGroupEmployeeVO;
import com.bcxin.api.interfaces.salary.req.SalaryOrgReq;
import com.bcxin.api.interfaces.salary.req.SalaryUserCheckPageQuery;
import com.bcxin.api.interfaces.salary.res.EmployeeBasicRes;
import com.bcxin.api.interfaces.salary.res.SalaryOrgRes;
import com.bcxin.tenant.domain.entities.SalaryArchive;
import com.bcxin.tenant.domain.entities.SalaryChangeRecord;
@Mapper
public interface SalaryQueryMapper {
	Map<String, Object> getValue(Map<String, Object> params);
	
	List<SalaryGroupEmployeeVO> selectSalaryGroupEmployeeList(SalaryGroupEmployeeVO salaryGroupEmployeeVO);
	
	List<EmployeeBasicRes> selectDepartEmployees (DeptEmployeeReq req);
	
	List<String> selectGroupEmployees (Map<String,Object>params);
	
	List<SalaryOrgRes> selectDeptTree (SalaryOrgReq req);
	
	Map<String,Object> login(Map<String,Object>params);

	List<SalaryArchive> findGroupUserArchiveBy(SalaryUserCheckPageQuery req);
	
	
	void deleteGroupUserByGroupId(Long groupId);
	
	
	List<SalaryChangeRecord> findByEmployeeNo(String emNo,Long id);
	
	
	
}
