package com.bcxin.tenant.apis;

import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.queue.rabbitmqs.RabbitConfig;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import com.bcxin.tenant.domain.TenantDomainConfig;
import com.bcxin.tenant.domain.repository.TenantConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(NacosDataSourceConfig.class)
@Configuration
@EnableDubbo(scanBasePackages = {"com.bcxin.tenant.apis.impls"})
@ComponentScan({"com.bcxin.api.interfaces.identities","com.bcxin.api.interfaces.rbacs","com.bcxin.api.interfaces.buses"})
@Import({TenantDomainConfig.class, TenantConfig.class, InitConfig.class, RabbitConfig.class})
public class StartupConfig {
    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final IdentityRpcProvider identityRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final RbacCategoryRpcProvider rbacCategoryRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final MessageRpcProvider messageRpcProvider;

    public StartupConfig(IdentityRpcProvider identityRpcProvider,
                         RbacCategoryRpcProvider rbacCategoryRpcProvider,
                         MessageRpcProvider messageRpcProvider) {
        this.identityRpcProvider = identityRpcProvider;
        this.rbacCategoryRpcProvider = rbacCategoryRpcProvider;
        this.messageRpcProvider = messageRpcProvider;
    }
}
