package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.excel.EasyExcel;
import com.bcxin.api.interfaces.rbacs.ISalaryReportService;
import com.bcxin.api.interfaces.salary.req.HumanDetailHead;
import com.bcxin.api.interfaces.salary.req.HumanDetailReq;
import com.bcxin.api.interfaces.salary.req.HumanFundReq;
import com.bcxin.api.interfaces.salary.req.HumanMergeReq;
import com.bcxin.api.interfaces.salary.req.HumanTotalCountReq;
import com.bcxin.api.interfaces.salary.req.SeasonHumanTotalCountReq;
import com.bcxin.api.interfaces.salary.res.HumanTotalCountRes;
import com.bcxin.rest.web.apis.constants.RestConstants;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;


@RestController
@RequestMapping("/{organizationId}")
public class SalaryReportController extends ControllerAbstract{


	@Autowired
	private  ISalaryReportService salaryReportService ;

	/**
	 * 各部门人力成本汇总
	 * @param req
	 * @return
	 * @throws IOException 
	 */
	@RequestMapping("/humanTotalCost")
	public ResponseEntity humanTotalCost(@RequestBody HumanTotalCountReq req,HttpServletResponse response ) throws IOException {
		List<HumanTotalCountRes> data = salaryReportService.getHumanTotalCount(req);
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode(req.getMonth()+"各部门人力成本汇总表", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.REPORT_HUMANTOTAL_TEMPLATE);
		EasyExcel.write(response.getOutputStream())
		.withTemplate(inputStream).sheet().doFill(data);
		return this.ok();
	}
	/**
	 * 各部门人力成本明细
	 * @return
	 * @throws IOException 
	 */
	@RequestMapping("/humanDetail")
	public ResponseEntity humanDetail(@RequestBody HumanDetailReq req, HttpServletResponse response) throws IOException {
		List<HumanDetailHead> data = salaryReportService.listHumanDetail(req);
		// response.getOutputStream()  D:\\bx\\dynamic\\hd.xlsx
		EasyExcel.write(response.getOutputStream()).head(HumanDetailHead.class).sheet().doWrite(data);
		return this.ok();
	}
	/**
	 *  部门社保公积金明细
	 * @param req
	 * @return
	 */
	@PostMapping("/humanFund")
	public ResponseEntity itemedit(@RequestBody HumanFundReq req,HttpServletResponse response ) {
		List<Map> data = salaryReportService.listHumanFundDetail(req);
		//    	EasyExcel.write(response.getOutputStream()).head(SalaryExcelUtil.createHead(header)).sheet().doWrite();
		return this.ok();
	}
	/**
	 *  薪资合并表
	 * @param req
	 * @return
	 * @throws IOException 
	 */
	@RequestMapping("/humanMerge")
	public ResponseEntity humanMerge(@RequestBody HumanMergeReq req,HttpServletResponse response) throws IOException {
		List<Map> files = salaryReportService.listHumanMerge(req);
		String zipName = "myfile.zip";
        response.setContentType("APPLICATION/OCTET-STREAM");  
        response.setHeader("Content-Disposition","attachment; filename="+zipName);
        ZipOutputStream out = new ZipOutputStream(response.getOutputStream());
        try {
            for(Iterator<Map> it = files.iterator();it.hasNext();){
            	Map file = it.next();
            	File f= (File)file.get("file");
                response.flushBuffer();
                ZipEntry entry = new ZipEntry(f.getName());
                out.putNextEntry(entry);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally{
            out.close();
        }
		return this.ok();
	}

	/**
	 * 季度报表-各部门人力成本汇总表
	 * @param req
	 * @return
	 * @throws IOException 
	 */
	@RequestMapping("/seasonHumanCost")
	public ResponseEntity seasonHumanCost(@RequestBody SeasonHumanTotalCountReq req,HttpServletResponse response ) throws IOException {
		if(req.getSeason()==1) {
			
		}
//		List<HumanTotalCountRes> data = salaryReportService.getHumanTotalCount(req);
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode(req.getYear()+"各部门人力成本汇总表", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.REPORT_HUMANTOTAL_TEMPLATE);
//		EasyExcel.write(response.getOutputStream())
//		.withTemplate(inputStream).sheet().doFill(data);
		return this.ok();
	}
	/**
	 * 年度报表-员工各月工资汇总表（含平均工资）
	 * @param req
	 * @param response
	 * @return
	 * @throws IOException
	 */ 
	@PostMapping("/yerHumanCost")
	public ResponseEntity yerHumanCost(@RequestBody HumanTotalCountReq req,HttpServletResponse response ) throws IOException {
		List<HumanTotalCountRes> data = salaryReportService.getHumanTotalCount(req);
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode(req.getMonth()+"各部门人力成本汇总表", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.REPORT_HUMANTOTAL_TEMPLATE);
		EasyExcel.write(response.getOutputStream())
		.withTemplate(inputStream).sheet().doFill(data);
		return this.ok();
	}
	/**
	 * 年度报表-各维度（含部门等）人力成本明细表
	 * @param req
	 * @param response
	 * @return
	 * @throws IOException
	 */
	@PostMapping("/yerDeptHumanCost")
	public ResponseEntity yerDeptHumanCost(@RequestBody HumanTotalCountReq req,HttpServletResponse response ) throws IOException {
		List<HumanTotalCountRes> data = salaryReportService.getHumanTotalCount(req);
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode(req.getMonth()+"各部门人力成本汇总表", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.REPORT_HUMANTOTAL_TEMPLATE);
		EasyExcel.write(response.getOutputStream())
		.withTemplate(inputStream).sheet().doFill(data);
		return this.ok();
	}


}
