package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.rbacs.ISalaryPayrollService;
import com.bcxin.api.interfaces.salary.cmd.ApproveFinishCmd;
import com.bcxin.api.interfaces.salary.cmd.ApprovePageCmd;
import com.bcxin.api.interfaces.salary.cmd.DelPayrollDetailsCmd;
import com.bcxin.api.interfaces.salary.cmd.PayDistributionCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollDetailUpdateCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollEmployeeCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrollSendCmd;
import com.bcxin.api.interfaces.salary.cmd.PayrolllUploadCmd;
import com.bcxin.api.interfaces.salary.cmd.SalaryGroupSendPayrollCmd;
import com.bcxin.api.interfaces.salary.cmd.TrendCmd;
import com.bcxin.api.interfaces.salary.req.PayrollConfigReq;
import com.bcxin.api.interfaces.salary.req.PayrollDetailVo;
import com.bcxin.api.interfaces.salary.req.PayrollVo;
import com.bcxin.api.interfaces.salary.req.SalaryDetailHead;
import com.bcxin.api.interfaces.salary.res.PayDistributionRes;
import com.bcxin.api.interfaces.salary.res.TrendRes;
import com.bcxin.api.interfaces.salary.res.YearAddRes;
import com.bcxin.rest.web.apis.constants.RestConstants;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;

import lombok.extern.slf4j.Slf4j;

/**
 * @description 工资单
 */
@Slf4j
@RestController
@RequestMapping("/{organizationId}")
public class SalaryPayrollController extends ControllerAbstract{

	@Autowired
	private ISalaryPayrollService salaryPayrollService;
	private Object result = null;

	/**
	 * 下载工资单模板
	 */
	@RequestMapping("/downloadTemplate")
	public ResponseEntity downloadTemplate(HttpServletResponse response) throws IOException{
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 
		String fileName = URLEncoder.encode("工资单模板", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.PATROLL_TEMPLATE);
		ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream())
				.withTemplate(inputStream).build();

		excelWriter.finish();
		response.flushBuffer();
		return this.ok();
	}

	/**
	 * 上传工资单
	 * @throws IOException 
	 */
	@RequestMapping("/uploadPayroll")
	public ResponseEntity uploadPayroll(HttpServletResponse res,@RequestPart PayrolllUploadCmd parm,@RequestPart MultipartFile file ) throws IOException{
		// 生成工资单
//		String payId = salaryPayrollService.save(parm);
		//解析文件
		EasyExcel.read(file.getInputStream(), new NoModelDataListener(parm)).sheet().headRowNumber(2).doRead();
		return this.ok(this.result);
	}
	
	/**
	 * 发送工资单-智能上传
	 * @throws IOException 
	 */
	@PostMapping("/sendPayroll")
	@Deprecated
	public ResponseEntity sendPayroll(@RequestBody PayrollSendCmd parm) throws IOException{
		// 通过groupId 生成工资单
		return this.ok(salaryPayrollService.queryPayrollByGorupId(parm));
	}
	/**
	 * 算薪发送工资单
	 * @throws IOException 
	 */
	@PostMapping("/groupGenPayroll")
	public ResponseEntity groupGenPayroll(@RequestBody SalaryGroupSendPayrollCmd parm) throws IOException{
		// 通过groupId 生成工资单
		Map<String,Object> data = salaryPayrollService.groupGenPayroll(parm);
		return this.ok(data);
	}
	
	
	
	
	/**
	 * 核对明细-工资单详情修改  或者重新发送
	 * @throws IOException 
	 */
	@PostMapping("/updatePayrollDetail")
	public ResponseEntity updatePayrollDetail(@RequestBody PayrollDetailUpdateCmd cmd) throws IOException{
		salaryPayrollService.updatePayrollDetail(cmd);
		return this.ok();
	}
	/**
	 * 核对明细-工资单详情撤销
	 * @throws IOException 
	 */
	@PostMapping("/revokePayrollDetail")
	public ResponseEntity revokePayrollDetail(@RequestBody PayrollDetailUpdateCmd cmd) throws IOException{
		salaryPayrollService.updatePayrollDetail(cmd);
		return this.ok();
	}
	/**
	 * 核对明细-工资单详情删除
	 * @throws IOException 
	 */
	@PostMapping("/delPayrollDetail")
	public ResponseEntity delPayrollDetail(@RequestBody PayrollDetailUpdateCmd cmd) throws IOException{
		List<String> items =Arrays.asList(cmd.getId()); 
		salaryPayrollService.delPayrollDetail(cmd.getId(),items);
		return this.ok();
	}
	/**
	 * 核对明细-工资单详情批量删除
	 * @throws IOException 
	 */
	@PostMapping("/delPayrollDetails")
	public ResponseEntity delPayrollDetails(@RequestBody DelPayrollDetailsCmd cmd) throws IOException{
		
		salaryPayrollService.delPayrollDetail(cmd.getId(),cmd.getItemIds());
		return this.ok();
	}
	/**
	 * 工资单管理-核对明细-重新校验预警
	 * @throws IOException 
	 */
	@PostMapping("/checkPayrollDetails")
	public ResponseEntity checkPayrollDetails(@RequestBody List<PayrollDetailVo> datas) throws IOException{
		
		return this.ok(salaryPayrollService.checkPayrollDetails(datas));
	}
	/**
	 * 工资单管理-设置并发送-预约发送
	 * @throws IOException 
	 */
	@PostMapping("/subscribe")
	public ResponseEntity subscribeSend(@RequestBody PayrolllUploadCmd parm ) throws IOException{
		
		parm.setFlag(true);
		parm.setSendStatus(1);
		salaryPayrollService.save(parm);
		
		return this.ok();
	}
	/**
	 * 工资单管理-设置并发送-立即发送
	 * @throws IOException 
	 */
	@PostMapping("/send")
	public ResponseEntity send(@RequestBody PayrolllUploadCmd parm) throws IOException{
		parm.setFlag(true);
		parm.setSendStatus(3);
		salaryPayrollService.save(parm);
		
		return this.ok();
	}


	/**
	 * 导出
	 */
	@PostMapping("/payRollExport")
	public ResponseEntity payRollExport(String type){
		return this.ok();
	}
	
	/**
	 * 工资单管理- 查询
	 */
	@PostMapping("/payroll/pageList")
	public ResponseEntity list(@RequestBody PayrollVo req ){
		return this.ok(salaryPayrollService.pageList(req));
	}
	/**
	 * 工资单管理-工资单详情
	 */
	@PostMapping("/payRollDetail")
	public ResponseEntity payRollDetail(@RequestBody PayrollDetailVo req){
		return this.ok(salaryPayrollService.payrollDetail(req));
	}

	/**
	 * 工资单管理-工资单详情-发送或者撤回
	 */
	@PostMapping("/payRollSend")
	public ResponseEntity payRollSend(@RequestBody PayrollDetailVo req){
		salaryPayrollService.updateDetail(req);
		return this.ok();
	}

	/**
	 * 工资单管理-删除工资单
	 */
	@PostMapping("/delPayRoll")
	public ResponseEntity delPayRoll(@RequestBody PayrollVo req){
		salaryPayrollService.delPayroll(req);
		return this.ok();
	}
	
	/**
	 * 工资单审批-待我审批
	 */
	@PostMapping("/approve/waitingQuery")
	public ResponseEntity waitingQuery(@RequestBody ApproveFinishCmd parm){
		PayrollVo req = new PayrollVo();
		req.setApproverId(this.getSelectedEmployeeId());
		req.setPayrollDate(parm.getPayrollDate());
		req.setPayrollName(parm.getPayrollName());
		req.setApproveStatus(0); // 待审批
		req.setPageIndex(parm.getPageIndex());
		req.setPageSize(parm.getPageSize());
		Pagination<PayrollVo> ls = salaryPayrollService.pageList(req);
		return this.ok(ls);	
	}
	/**
	 * 工资单审批-我已审批
	 */
	@PostMapping("/approve/finishQuery")
	public ResponseEntity finishQuery(@RequestBody ApproveFinishCmd parm){
		PayrollVo req = new PayrollVo();
		req.setApproverId(this.getSelectedEmployeeId());
		req.setPayrollDate(parm.getPayrollDate());
		req.setPayrollName(parm.getPayrollName());
		req.setApproveStatus(2); // 已通过
		req.setPageIndex(parm.getPageIndex());
		req.setPageSize(parm.getPageSize());
		Pagination<PayrollVo> ls = salaryPayrollService.pageList(req);
		return this.ok(ls);	
	}
	/**
	 * 工资单审批-我发起的
	 */
	@PostMapping("/approve/pageQuery")
	public ResponseEntity pageQuery(@RequestBody ApprovePageCmd parm){
		PayrollVo req = new PayrollVo();
		req.setPayrollDate(parm.getPayrollDate());
		req.setPayrollName(parm.getPayrollName());
		req.setApproveStatus(parm.getApproveStatus()); // 状态
		req.setTenantUserId(this.getSelectedEmployeeId());
		req.setPageIndex(parm.getPageIndex());
		req.setPageSize(parm.getPageSize());
		Pagination<PayrollVo> ls = salaryPayrollService.pageList(req);
		return this.ok(ls);	
	}
	
	
	
	/**
	 * 员工薪资明细-查询
	 * @throws IOException 
	 */
	@PostMapping("/person/listDetail")
	public ResponseEntity listDetail(@RequestBody PayrollEmployeeCmd req) throws IOException{
		
		Map<String,Object> s= salaryPayrollService.pageEmployeeList(req);
		return this.ok(s);
	}
	/**
	 * 员工薪资明细-批量导出
	 * @throws IOException 
	 */
	@RequestMapping("/person/batchExport")
	public ResponseEntity batchExport(@RequestBody List<String>_ids,HttpServletResponse response) throws IOException{
		
		List<SalaryDetailHead> data = salaryPayrollService.listEmployee(_ids);
		response.setContentType("application/octet-stream");
		response.setCharacterEncoding("utf-8");
		// 这里URLEncoder.encode可以防止中文乱码 当然和easyexcel没有关系
		String fileName = URLEncoder.encode("工资明细", "UTF-8").replaceAll("\\+", "%20");
		response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
		 
		String tst = "D:\\test\\测试.xlsx"; // response.getOutputStream()
		EasyExcel
				.write(response.getOutputStream()).head(SalaryDetailHead.class).sheet().doWrite(data);;
		return this.ok();
	}
	/**
	 * 数据看板- 薪资趋势分析 -当月薪资统计
	 */
	@PostMapping("/dashboard/trend")
	public ResponseEntity trend(@RequestBody TrendCmd cmd){
		TrendRes res =  salaryPayrollService.trend(cmd);
		return this.ok(res);
	}
	/**
	 * 数据看板- 年度实发累计
	 */
	@PostMapping("/dashboard/yearAdd")
	public ResponseEntity yearAdd(@RequestBody TrendCmd cmd){
		List<YearAddRes> res =  salaryPayrollService.yearAdd(cmd);
		return this.ok(res);
	}
	/**
	 * 数据看板- 员工薪资分布
	 */
	@PostMapping("/dashboard/payDistribution")
	public ResponseEntity payDistribution(@RequestBody PayDistributionCmd cmd){
		List<PayDistributionRes> res =  salaryPayrollService.payDistribution(cmd);
		return this.ok(res);
	}

	/**
	 * 工资单设置- 查询
	 */
	@PostMapping("/payroll/query")
	public ResponseEntity payrollQuery(){
		return this.ok(salaryPayrollService.payrollQuery());
	}
	/**
	 * 工资单设置- 修改
	 */
	@PostMapping("/payroll/update")
	public ResponseEntity payrollUpdate(@RequestBody PayrollConfigReq req ){
		salaryPayrollService.payrollUpdate(req);
		return this.ok();
	}

	public class NoModelDataListener extends AnalysisEventListener<Map<Integer, String>> {
		/**
		 * 每隔5条存储数据库，实际使用中可以100条，然后清理list ，方便内存回收
		 */
		private static final int BATCH_COUNT = 1000;
		private List<Map<Integer, String>>headers = new ArrayList<>();
        private PayrolllUploadCmd parm;

		private List<Map<Integer, String>> cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);

		public NoModelDataListener(PayrolllUploadCmd parm) {
			this.parm=parm;
		}

		@Override
		public void invoke(Map<Integer, String> data, AnalysisContext context) {
			cachedDataList.add(data);
//			if (cachedDataList.size() >= BATCH_COUNT) {
//				saveData();
//				cachedDataList = ListUtils.newArrayListWithExpectedSize(BATCH_COUNT);
//			}
		}

		@Override
		public void doAfterAllAnalysed(AnalysisContext context) {
			saveData();
			System.out.println("分析完成");
		}

		@Override
		public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
			headers.add(headMap);
		}
		
		/**
		 * 加上存储数据库
		 */
		private void saveData() {
			Map<String,Set<String>> tgt = new LinkedHashMap<>();
			Map<Integer, String> header0 = headers.get(0);
			Map<Integer, String> header1 = headers.get(1);
			for (Entry<Integer, String> map : header0.entrySet()) {
				if(tgt.containsKey(map.getValue().trim())) {
					tgt.get(map.getValue().trim()).add(header1.get(map.getKey()));
				}else {
					Set<String> set = new LinkedHashSet<String>();
					if(header1.get(map.getKey())!=null) {
						set.add(header1.get(map.getKey()));
					}
				
					tgt.put(map.getValue().trim(), set);
				}
			}
			List<Map<String,Object> > datas = new ArrayList<>();
			cachedDataList.forEach(map0->{
				Map<String,Object> data = new LinkedHashMap<String,Object>();
				int index = 0;
				
				for (Entry<String, Set<String>> map : tgt.entrySet()) {
					System.out.println(map);
					if(map.getValue().isEmpty()) {
						data.put(map.getKey().replace("（*）", "").trim(), map0.get(index));
						index++;
						continue;

					}
					List<Map<String,Object>> values= new ArrayList<>();
					int i=1;
					for (String setV : map.getValue()) {
						Map<String,Object> value= new LinkedHashMap<>();
//						index=index+i;
						
						value.put(setV, map0.get(index));
					
						values.add(value);
						index++;
					}
					data.put(map.getKey().trim(), values);
				}
				System.out.println(JSON.toJSON(data));
				datas.add(data);
				
			});
			parm.setDetails(datas);
			Object o = salaryPayrollService.saveDetail(parm);
			result=o;
			
		}
	}
}
