package com.bcxin.rest.web.apis.controllers.salarycal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.api.interfaces.rbacs.ISalaryConfigService;
import com.bcxin.api.interfaces.rbacs.ISalaryItemService;
import com.bcxin.api.interfaces.salary.req.ItemReq;
import com.bcxin.api.interfaces.salary.req.SalaryItemSaveReq;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;


@RestController
@RequestMapping("/{organizationId}")
public class SalaryItemController extends ControllerAbstract{
	
	


@Autowired
private  ISalaryItemService salaryItemService ;

@Autowired
private ISalaryConfigService salaryConfigService;

    /**
     * 薪资计算-配置薪资规则查询
     * @param req
     * @return
     */
    @PostMapping("/groupitems")
    public ResponseEntity lst(@RequestBody ItemReq req) {
    		return this.ok(salaryItemService.findItem(req));
    }
    /**
     * 薪资计算-配置薪资项目编辑/ 添加
     * @param req
     * @return
     */
    @PostMapping("/save/groupitems")
    public ResponseEntity save(@RequestBody SalaryItemSaveReq req  ) {
    	salaryItemService.save(req);
    	return this.ok();
    }
 
    
    
}
