package com.bcxin.rest.web.apis.controllers.salarycal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Consumer;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.bcxin.Infrastructures.components.ExcelProvider;
import com.bcxin.api.interfaces.rbacs.ISalaryCurrentService;
import com.bcxin.api.interfaces.salary.req.SalaryStatisticsHead;
import com.bcxin.api.interfaces.salary.req.SalaryStatisticsPageReq;
import com.bcxin.rest.web.apis.constants.RestConstants;
import com.bcxin.rest.web.apis.controllers.ControllerAbstract;


@RestController
@RequestMapping("/{organizationId}")
public class SalaryHistoryController extends ControllerAbstract{
	
	


@Autowired
private ExcelProvider excelProvider;
@Autowired
private  ISalaryCurrentService salaryCurrentService ;



    /**
     * 历史工资-列表 时间倒序 分页
     * @param req   月份
     * @return
     *     月份
	工资表名称
	计薪人数
	应发工资
	实发工资
	个税总额
	薪资锁定时间
     */
    @PostMapping("/list")
    public ResponseEntity pageHistory(@RequestBody SalaryStatisticsPageReq req) {
        return this.ok(salaryCurrentService.listStatistic(req));
    }
    /** 导入
     *   parm 1 工资表名称 2 所属月份 3 file
     * @return
     * @throws IOException 
     */
    @RequestMapping("/import")
    public ResponseEntity importHistory(MultipartFile file, String fileName ,String month) throws IOException {
    	excelProvider.read(file.getInputStream(), SalaryStatisticsHead.class,100,new Consumer<List<SalaryStatisticsHead>>() {
    		
    		public void accept(List<SalaryStatisticsHead> t) {
    			for (SalaryStatisticsHead item : t) {
    				item.setTabName(fileName);
    				item.setMonth(month);
    				salaryCurrentService.importHisStastic(item);
    			}
    		}
    		
    	},5);
    	return this.ok();
    }
    /**
     * 导出
     * @return
     * @throws IOException 
     */
    @RequestMapping("/export")
    public ResponseEntity exportHistory(HttpServletResponse  response ) throws IOException {
    	
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=demo.xlsx");
        // get current month
        List<SalaryStatisticsHead> rst= salaryCurrentService.listStatisticAll();
        EasyExcel.write(response.getOutputStream(), SalaryStatisticsHead.class).sheet().doWrite(rst);
    	return this.ok();
    }
    /**
     * 删除
     * @return
     */
    @PostMapping("/del")
    public ResponseEntity delHistory(Long id ) {
    	salaryCurrentService.delStastic(id);
    	return this.ok();
    }
    /**
     * 下载模板
     * @return
     * @throws IOException 
     */
    @RequestMapping("/his/template")
    public ResponseEntity template(HttpServletResponse response ) throws IOException {
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=历史工资导入模板.xlsx");
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RestConstants.HISTORY_TEMPLATE);
        ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream())
                .withTemplate(inputStream).build();
        excelWriter.finish();
        response.flushBuffer();
    	return this.ok();
    }
   
    
}
